; file: plotpowerspectrum.pro = for evenly sampled data sequence 
; init: Jan  1 2009 
; last: Jan  9 2016  Rob Rutten  Deil
; note: from ~/rr/tch/practica/dewijn-fourier/answers/answers-sec3.pro

pro plotpowerspectrum,data,cadence,psfilename,$
  figtitle=figtitle,verbose=verbose

;+
 ; NAME:
 ;   plotpowerspectrum
 ; PURPOSE:
 ;   plot powerspectrum of equidistantly sampled data sequence
 ; DESCRIPTION:
 ;   following Alfred de Wijn's Fourier practical at Utrecht University
 ; CALL:
 ;    plotpowerspectrum,data,cadence,psfilename
 ; INPUTS:
 ;   data = vector
 ;   cadence = samling interval in seconds
 ;   psfilename = string specifying output plot file with .eps 
 ; OPTIONAL KEYWORD INPUTS:
 ;   figtitle: string to plot above figure
 ;   verbose = 1/0: show plot on screen
 ; OUTPUTS:
 ;   periodogram  
 ; RESTRICTIONS:
 ;   needs equidistant sampling and RR openpsplot.pro and closepsplot.pro 
 ;   NB: use SSW periodogram.pro for non-evenly sampled data
 ; HISTORY:
 ;   Jan  1 2008 RR: start
 ;   Jul 18 2014 RR: changed to openpsplot and closepsplot 
 ;   Jan  9 2016 RR: added verbose
;-

; default 
if (n_elements(verbose) eq 0) then verbose=0

; get data sequence length
datseq=reform(data)
sizedatseq=size(datseq)
nt=sizedatseq(1)

;; ; x-axis in s
;; xas=findgen(nt)*cadence

; define frequency axis in Hz
fxas=1./(cadence*2)*findgen(nt/2+1)/(nt/2)  ; findgen=0.....1

; compute power spectrum
ftdatseq=fft(datseq,-1)
powerdatseq=float(ftdatseq*conj(ftdatseq))

; make plot
axrat=1.62   ; golden ratio
openpsplot,psfilename,thick=2,fontsize=9,xsize=8.8,ysize=8.8/axrat
plot, fxas, alog10(powerdatseq), $
  xtitle='frequency  [Hz]', ytitle='log(power)',$
  xrange=[0,max(fxas)],xstyle=1;; ,/ylog

; add optional title for identifier
if (n_elements(figtitle) ne 0) then xyouts,0.5,0.94,/norm,$
  alignment=0.5,figtitle

closepsplot,psfilename,opengv=verbose

end
