; file: planck.pro = Planck function (wavelength units, micron)
; last: Jan  2 2012 

function planck,temp,wav

;+
; computes Planck function in erg / cm2 sec [delta lambda=1 micron] ster
; input: temp = temperature (K)
; wav = wavelength in micron
;-

; constants in cgs from http://physics.nist.gov/cuu/Constants Jan  2 2012 
k=1.380658D-16        ; Boltzmann constant (erg K; double precision)
h=6.6260696D-27       ; Planck constant (erg s)
c=2.99792458D10       ; velocity of light (cm/s; definition)

wavcm=wav*1E-4        ; change wav into cm
blambda = 2*h*c^2/(wavcm^5*(exp(h*c/(wavcm*k*temp))-1))
blambda=blambda*1E-4  ; change B_lambda into per micron

return,blambda
end
