
       CONTEMPORARY LABORATORY EXPERIENCES IN ASTRONOMY (CLEA)


                 Laboratory Exercise for Windows
                                
                CLASSIFICATION OF STELLAR SPECTRA


                      SOFTWARE USER'S GUIDE


                       By Glenn A. Snyder
                      Department of Physics
                       Gettysburg College
                         Gettysburg, PA


I.   INTRODUCTION


I-1. Purpose

This document provides specific technical information for users
of the CLEA software module "Classification of Stellar Spectra".
Included are discussions of hardware and operating system
requirements (Section II); software installation and operation
(Section III); files associated with the exercise (Section IV);
user options and file formats for possible user modifications
(Section V); and astronomical data, models and algorithms
employed in the exercise (Section VI).  The material in this
guide is intended for use by the instructor and by other
personnel involved in installing and configuring the exercise
software and PC hardware.  It is not intended for distribution to
the students.  (The word "user" when it appears herein should be
interpreted as "instructor", and not "student".)

Readers of this document are assumed to have available the
General Users' Guide to CLEA Windows Software (SUG), which
contains technical information that applies to all CLEA Windows
software.  Information contained therein is generally not
repeated here.


I-2. Acknowledgements

Development of CLEA exercises and materials, including this
guide, is supported in part by the National Science Foundation
(Grants USE 9155927 and ...) and by Gettysburg College.


II.  SYSTEM REQUIREMENTS


This software runs on IBM and compatible PCs under Microsoft
Windows 3.0/3.1.  It requires a hard disk with approximately 4
MByte of available storage (significantly more than the 1-2 MByte
required by most of the other CLEA modules), and a color VGA
monitor.  The "Photo" spectrum display mode is not available on
systems operating in a 16-color display mode (see Section VI-3).
For additional information on systems requirements, including a
discussion of color modes and video drivers, see the SUG.


II-1. Recommendation

This exercise includes a number of displays designed to assist
the student in the classification of stars.  In particular, it is
especially advantageous if the atlas spectra selection display
and the spectral line list, as well as the Classification Window,
are visible in their entirety throughout the classification
process.  To permit this, we recommend that, if possible, this
exercise be run in a 1024 x 768 pixel display mode.  In this
mode, the main window is sufficiently reduced in size that the
aforementioned displays can be moved off to the side and bottom
areas of the screen and remain visible.  This eliminates the
annoyance of constant repositioning and/or minimizing/maximizing
of the windows.  If your video card and monitor support a 1024 x
768 mode, you can switch to it by following the instructions in
the SUG for changing the video driver.


III. INSTALLATION AND OPERATION


Files for this exercise are compacted into two distribution
files, CLEA_SPE.ZIP and JSPECTRA.ZIP.  The working files must be
extracted using the PKUNZIP program (also included on the
distribution diskette), and placed together in a single
directory, such as C:\SPEC_LAB.  (Be sure that you unzip both
files).  Details of unpacking, running, and installing CLEA
software under Windows are given in the SUG.


IV.  FILES INCLUDED WITH EXERCISE


This exercise requires a large number of files for its operation.
Most of these are compressed into the distribution files
CLEA_SPE.ZIP and JSPECTRA.ZIP, and should be present in your
working directory after unpacking with PKUNZIP.  These files are
described in Sections IV-1 and IV-2 below.  Section IV-3
identifies additional files that are not included in the
distribution, but will appear in the working directory
during/after execution of the exercise software.


IV-1. Files in CLEA_SPE.ZIP

The following files are compressed into the distribution file
CLEA_SPE.ZIP.  The list is grouped by function, with references
to related discussions in this document.


     Software and Documentation

     README.SPC   - Notes on the current version, including any
                    incompatibilities with previous versions, old
                    files that should be deleted, etc.

     UPDATE.SPC   - A list of updates (by version) since version
                    0.86 (the first version to be widely
                    circulated).

     USRGUIDE.SPC - This document, in text form.

     CLEA_SPE.EXE - The executable code for the exercise.

     CLASSIFY.KEY - A text file containing the names and spectral
                    types of the stars in the version of
                    CLASSIFY.LST provided with the exercise.

     JACOBY.DOC   - A brief description of the Jacoby spectral
                    data provided with the exercise (see Section
                    VI-1).

     JACOBY2.INX  - An Index File to the Jacoby spectra, giving
                    star IDs, spectral types, and other
                    information (see Section VI-1 and JACOBY.DOC
                    above)..


     Bitmap Files for Displays

     CLEALOGO.BMP - 256-color bitmap data for the CLEA Logo
                    screen.

     CLEALG16.BMP - 16-color bitmap data for the CLEA Logo
                    screen.

     SPECLAB.BMP  - 256-color bitmap data for the Title screen.

     SPECL16.BMP  - A 16-color version of the Title screen.


     Atlases of Standard Spectra (Section V-2.1)

     ATLAS2.LST   - A list of the available atlases of standard
                    stars.

     MS.ATL       - An Atlas Index File for the Main Sequence.

     O8_LUM.ATL   - An Atlas Index File for luminosity near O8.

     B2_LUM.ATL   - An Atlas Index File for luminosity near B2.

     A3_LUM.ATL   - An Atlas Index File for luminosity at A3.

     F5_LUM.ATL   - An Atlas Index File for luminosity at F5.

     G2_LUM.ATL   - An Atlas Index File for luminosity at G2.

     K0_LUM.ATL   - An Atlas Index File for luminosity at K0.

     M2_LUM.ATL   - An Atlas Index File for luminosity near M2.


     Data for Star Fields (Section V-2.2)

     SPECFILS.DAT - A list of available star fields.

     SPECFLD1.DAT - Data for a synthetic star field.

     PLEIADES.DAT - Data for the Pleiades star field.

     JSPEC.SPI    - An Index File linking CLEA spectral type
                    codes (Section V-2.2.4) with the available
                    spectra.


     Unknowns for Classification (Section V-2.3)

     CLASSIFY.LST - A list of "unknowns" for classification by
                    the students.


     Help and Related Files (Section V-4)

     CLEAHELP.HLP - Text for "Help"..."On Help".

     SPECHLP.LST  - Topic Index List for Help on taking spectra.

     SPECLAB.HLP  - Text for Help topics on taking spectra.

     CLASSHLP.LST - Topic Index List for Help on classifying
                    spectra.

     CLASSIFY.HLP - Text for Help topics on classifying spectra.

     SPECLNS.LNL  - List of spectral lines giving wavelength in
                    ngstroms, line identification, and
                    associated Help file.

     SPECLNS.HLP  - Text for Help on spectral lines.

     REMINDER.SPC - Text to display when "Quit" selected.


IV-2. Files in JSPECTRA.ZIP

The Jacoby spectra provided with this exercise (files J001.SP
through J161.SP) are compacted into distribution file
JSPECTRA.ZIP.  In their expanded form the files require
approximately 2 MBytes of disk storage.  The format of these
files is given in Section V-2.4, the Jacoby spectral material is
described in Section VI-1.  (See also JACOBY.DOC, JACOBY2.INX, &
JSPEC.SPI above.)


IV-3. Files Generated During Execution

The following files are generated during execution of this
exercise, and will appear in the working directory.  (CLEALOG.LOG
and SPECOPTS.INI are automatically created.  Files with
extensions .CSP and .CTX are created on option, as noted.)

     CLEALOG.LOG  - A record that includes the program name
                    (CLEA_Spe), the date and time, and the names
                    and table number from the Login dialog is
                    appended to this file whenever the exercise
                    is started, and when it is terminated.  This
                    file is in text format and can be read and/or
                    printed at any time.  Since this file can
                    grow without limit it should be deleted from
                    time to time (via DOS or the Windows File
                    Manager).  A new file will then be started at
                    the next login.  This file can optionally be
                    given a different name (see Section V-1.2).

                    NOTE: A logout record will be written to this
                    file only if the students exit correctly from
                    the program (select "Quit" from the main
                    menu).  They should be instructed to do this,
                    rather than simply abandoning the computer or
                    turning it off.

     SPECOPTS.INI - Current settings for file names and options.
                    This file can be deleted if desired, it will
                    then be re-created from internal defaults
                    when the program is run.  If the options are
                    updated (see Section V-1), the previous
                    version is saved as SPECOPTS.BAK.

     *.CSP        - Files with the extension .CSP are created
                    when a spectrum is saved via selection "Save"
                    on the spectrometer menu.  Spectra taken with
                    the simulated telescopes must be saved in
                    this manner before they can be classified.
                    Names for these files are generated from the
                    first login name ("Student #1") and a three
                    character ID provided by the student, as
                    described below (Section IV-3.1).  These
                    files are in the spectrum file format
                    described in Section V-2.4.

     *.CTX        - A file with extension .CTX is written to the
                    working directory when "Results"..."Save to
                    File" is selected from the classification
                    menu.  (The file name is generated from the
                    first login name - see Section IV-3.1 below.)
                    This file is written in a format (tab
                    delineated text) that can be used as input to
                    most commercial spreadsheet programs.  See
                    Section V-3 for information about using a
                    spreadsheet program with this exercise, and
                    the contents of the .CTX file.

NOTE:  Files *.CSP and *.CTX should be periodically deleted from
the working directory when they are no longer needed.  This can
be done under DOS or via the Windows File Manager.
IV-3.1. Naming .CSP and .CTX Files

Names for the student-generated .CSP and .CTX files are created
from the first login name ("Student #1").  If the login entry
includes both a first and last name, the first letter of the name
is combined with the first seven (if present) letters of the last
name.  If only one name is entered, the first eight (if present)
letters are used.  Since only one .CTX file may be generated (new
classifications may be appended to an existing file), the .CTX
extension is simply concatenated to the generated file name.  For
.CSP files, the name is truncated (if necessary) to five
characters.  A three character (max) id is then solicited from
the student and added, along with the .CSP extension.  Examples:

     Login Name               File Names

     Annie Jump Cannon        ACANNON.CTX
                              ACANOxxx.CSP

     Martin Schwarzschild     MSCHWARZ.CTX
                              MSCHWxxx.CSP

     Galileo                  GALILEO.CTX
                              GALILxxx.CSP

If the first login name is blank, the files are named NOLOG.CTX
and NOLOGxxx.CSP.


V.   USER OPTIONS


This software has been designed to provide the user with a great
deal of flexibility in configuring the facility for specific
needs.  Users may provide their own spectra (both standards and
unknowns), configure atlases of standards and lists of unknown
spectra, adjust the wavelength range, modify the Help facility
(including the wavelength table), add or modify star fields,
modify telescope and star image parameters, attach a spreadsheet
program, and select from a list of optional features.  Details of
the facilities providing this adaptability are given in Sections
V-1 through V-4 below.


V-1. Parameters and Selectable Options

In all CLEA software, modification of control parameters and
options is accomplished through an options dialog that is
accessed through the login dialog, via a password.  Details of
this feature, including the password access, are provided in the
SUG.  Due to the number of modifiable features associated with
this exercise, the options facility comprises three dialog
windows, as detailed in the Sections that follow (V-1.1 through
V-1.3).


V-1.1. Switches and Parameters

The following switches and parameters appear on the window titled
"Startup Parameters/Options", which appears as the main dialog
when the options facility is accessed.

     UT-Local Time: Enter the value (in integer hours) of
          Universal Time minus local (zone) time for the presumed
          location of the  "observatory" for this exercise.  This
          number is used to convert the time obtained from the
          system clock on the individual PC to Universal Time.
          The table below gives the standard time values for
          North American time zones.  (For daylight time,
          subtract one from the table value.)  The default is 5
          hours (Eastern Standard Time).

                      Zone         UT-ST (Hrs)

                    Atlantic            4
                    Eastern             5
                    Central             6
                    Mountain            7
                    Pacific             8
                    Alaska              9
                    Hawaii             10

     Base Magnitude: The base magnitude for spectrum integration
          and other computations (see Section VI-2).  The default
          value is 9.00.

     Sky Magnitude: The sky brightness for spectrum integration
          and other computations, expressed as a magnitude (see
          Section VI-2).  The default value is 19.00.

     Base Photon Count: The photon count associated with the base
          magnitude (see Section VI-2).  The default value is 50.

     Timer Wait: The time (in milliseconds) between successive
          counting steps during spectrum integration.  The
          default value of 1 means that the speed of integration
          is normally limited by the speed (CPU and display) of
          the computer.  This parameter is provided so that in
          the future, extremely fast processors may be slowed
          down to realistic rates of spectrum integration.

     Wavelength Range: The wavelength range in ngstroms () for
          the spectral displays.  For best results in labeling
          and appearance these values should be multiples of 100
          .  If the available data (Sections V-2.4, VI-1) does
          not cover the range specified, the spectra will appear
          truncated.  The default range is 3900 to 4500 , which
          is the range of the spectral data supplied with the
          exercise.

     "Difference" Option: When this switch is set, the control
          panel in the Classification Window includes a button
          labeled "Difference".  When this button is pressed the
          lower spectral standard is replaced by a point by point
          plot of the intensity of the upper standard minus the
          unknown (in display mode "Intensity Trace" only).  If
          this switch is not set, the option is not available and
          the button does not appear.  The default is "On".

     Spectral Line Table: When this switch is set, the spectral
          line table and associated Help facility (see Section V-
          4.2) is available under "Load" on the Classification
          Window menu.  The default is "On".

     Use Small Help Font: When this switch is set, a small type
          face is used for the Help windows to improve their
          appearance and use less space on the screen.  This font
          may be too small to be read easily in some screen
          modes.  The default is "On".

     Restrict Telescope Access: When this switch is set, the
          student must apply for access to the larger (1 and 4
          meter) telescopes, and receives a limited number of
          uses if access is granted (see Section V-1.3 for
          associated parameters).  The default is "On".

     Restrict File Access: When this switch is set, the student
          has access to only those .CSP and .CTX files whose
          names correspond to the current 1st login name (see
          Section IV-3.1).

     Table Number: This field allows the instructor to preset the
          table number for each machine in the lab.  This number
          then appears as the default on the Login dialog.  The
          table number has a maximum length of 4 characters, but
          need not be numeric.

     Password: This is the password for access to the Options
          dialog.  Allowable passwords have a maximum length of
          16 characters, and are case sensitive.  The default
          password is "CLEA".

     Login Required: This switch is provided for those who may
          wish to avoid the login process when using this
          software as a demonstration.  When this switch is off,
          the "Run" selection on the main menu, as well as
          "Login", is enabled when the program starts.  If "Run"
          is then selected before "Login", the program proceeds
          as if the login process had actually occurred.  (In
          this case the 1st login name is set to "Demonstration",
          the file name base becomes "DEMO", and the "Login" menu
          selection is disabled.)  The default is "On".


V-1.2. File Name Options

The following file and path name parameters appear on the window
titled "File Name Options".  To access this dialog press the
button labeled "Files..." on the "Startup Parameters/Options"
window.  See the SUG for discussions of Windows bitmap (.BMP)
files, including logo and title screens and color issues.

     Directory Path: See the SUG for a discussion of this
          parameter.  This field is normally left blank.  The
          default is "" (no entry).

     256-Color Logo: A 256-color bitmap for the CLEA logo screen.
          The default is "CLEALOGO.BMP".

     16-Color Logo: A 16-color bitmap for the CLEA logo screen.
          The default is "CLEALG16.BMP".

     256-Color Title: A 256-color bitmap for the exercise title
          screen.  The default is "SPECLAB.BMP".

     16-Color Title: A 16-color bitmap for the exercise title
          screen.  The default is "SPECL16.BMP".

     Star Fields List: A list of star fields for the exercise
          (see Section V-2.2.1).  The default is "SPECFILS.DAT".

     Atlas Files List: A list of atlas files for the exercise
          (see Section V-2.1.1).  The default is "ATLAS2.LST".

     Spectra Index List: An index file linking CLEA spectral type
          codes (Section V-2.2.4) with the available spectra.
          See Section V-2.2.3 for details.  The default is
          "JSPEC.SPI".

     Spectral Line List: A list of spectral lines that are
          important in the classification of stellar spectra (see
          Section V-4.2).  The default is "SPECLNS.LNL".

     Unknowns List: A list of unknowns for classification by the
          students (see Section V-2.3).  The default is
          "CLASSIFY.LST".

     Main Help List: An index list of Help topics for the Main
          Window (telescope controls for taking spectra) (see
          Section V-4.1).  The default is "SPECHLP.LST".

     Classify Help List: An index list of Help topics for the
          Classification Window (see Section V-4.1).  The default
          is "CLASSHLP.LST".

     User Help File: Site-specific Help information available
          under "Help"..."User" (see Section V-4.1).  The default
          is "" (no entry).

     Reminder File; Text to be displayed when the students want
          to terminate the exercise (see Section V-4.1).  The
          default is "REMINDER.SPC".

     Spreadsheet Program File: The full file name (including
          path) of a spreadsheet program to be accessed during
          the exercise for data manipulation and analysis (see
          Section V-3 for details).  The file must be of type
          .EXE or .PIF, and must be accessible from the student's
          computer in the drive and file specified (example:
          C:\EXCEL\EXCEL.EXE). This parameter is completely
          optional.  There is no default.

     Log File: A file (text) where log information is written
          during login and at termination of the exercise (see
          Section IV-3).  The default is "CLEALOG.LOG".


V-1.3. Telescope Parameters

This exercise provides the students access to three telescopes, a
0.4 meter (16 inch) default telescope that is always available to
them, and 1 meter and 4 meter (40 and 160 inch) instruments whose
use may (optionally) be restricted.  If the "Restrict Telescope
Access" switch is set (Section V-1.1), the students must apply
for time on the larger instruments, and are given a limited
number of uses if time is awarded.  The rate of integration of
spectra is accurately scaled to the size of the telescope in use.
The following parameters, which appear on the window titled
"Telescope Parameters", allow the user to modify various aspects
of this facility.  To access this dialog, press the button
labelled "Scopes..." on the "Startup Parameters/Options" window.

     Name: The name or identification of the telescope.  (38
          characters)

     Site: The site of the telescope.  (35 characters)

     Availability: The fraction of applications for telescope
          time that will be approved.  (0.0 to 1.0)

     Reapply Wait: The amount of time the student must wait to
          reapply if an application is not approved.  The
          software automatically informs the student when
          reapplication can be made.  (1 to 255 minutes)

     Minimum Allocation: The minimum number of uses that are
          granted if time is awarded.

     Maximum Allocation: The maximum number of uses that are
          granted if time is awarded.

     Scope Factor: The "gain" in light gathering power of the
          telescope, expressed in magnitudes (see Section VI-2
          for details, including calculation of this parameter).
          The zero point is determined by the "Base Magnitude"
          parameter on the Startup Parameters/Options dialog
          (Section V-1.1).  The scope factor determines the
          relative speed at which the spectra are collected, and
          is also used to scale the appearance of star images on
          the "Spectrometer" display.

     Finder Factor: The relative "gain" in light gathering power
          of the telescope finder.  This parameter is used to
          scale the appearance of star images on the "Finder"
          display.  It is not used in calculations or for any
          other purpose.

Allocation of observing time is random, based on the
"Availability", "Minimum Allocation" and "Maximum Allocation"
parameters.  (These parameters, along with "Reapply Wait", do not
apply to the default (0.4m) telescope.)  The student is kept
informed of uses remaining as spectra are taken with the
restricted telescopes.


V-2. Data Files


In order to provide maximum adaptability, data for this exercise
is read from files that can be created and modified with a text
editor.  The various file formats used to identify and define
spectral atlases, star fields, unknowns for classification, and
stellar spectra are described in Sections V-2.1 through V-2.4
below.  In addition to conforming to the appropriate format, all
data files should adhere to the general rules listed below.  Bad
data will almost always result in program failure!

     1)   Data should be entered one record per line.

     2)   Fields within records are separated by at least one
          space.  Do not use commas or other separators, and do
          not embed spaces in numeric fields.

     3)   String fields are enclosed in single quotes ('), and
          the number of characters + spaces between the quotes
          must be <= the maximum length of the field.

     4)   Real fields may carry a sign, and may be in decimal
          (1.0, -2.345) or exponential (0.1234E-06, -8.549E+18)
          form.  Real fields will also accept integer (0, 1, -99)
          values.

     5)   Integer fields may carry a sign, and cannot include a
          decimal point or exponent.

     6)   Boolean fields may be assigned only the values 0
          (false) and 1 (true).

     7)   The maximum allowed values for all numeric fields (in
          terms of both absolute value and number of digits) are
          much larger than required for any reasonable values for
          the quantities they represent.

     8)   Values must be provided for all fields in a record, in
          the proper order.  (Exception: all remaining empty
          fields on the end of records may be omitted.)  For null
          strings enter two single quotes (''), for null numeric
          fields enter 0 or 0.0.

     9)   There is no specific limit on the number of records in
          a file.  However, these files are read into and
          maintained in memory when they are used, so there is
          some risk of running out of heap space with a large
          file.

     10)  Do not include blank records in a file.  Take special
          care to insure that there are no blank records at the
          beginning or end of a file.

     11)  Records should not contain carriage return, line feed,
          or other non-alphanumeric characters.  Such characters
          may sometimes be inserted during file transfers by
          "Text Mode" protocols.


V-2.1. Spectral Atlases

Atlases of spectral standards can be created to include any of
the available spectra.  Each available spectral atlas must be
identified in the Atlas List File (Section V-2.1.1) and defined
in an Atlas Index File (Section V-2.1.2).


V-2.1.1. The Atlas List

The Atlas List File (default ATLAS2.LST) contains records that
identify each available atlas and supply the name of its
associated Atlas Index File.  This information is carried in two
string fields, as follows:

     Field             Data Type   Contents

     Atlas ID          String[65]  Name/ID of the atlas to appear
                                   on the "Select Spectral Atlas"
                                   list.

     File Name         String[12]  Name of the associated Atlas
                                   Index File (name + qualifier,
                                   no path).

There is no fixed limit to the number of entries in this file,
and thus to the number of atlases that may be defined.  The Atlas
List File ATLAS2.LST is supplied with the exercise, and is
identified in the field labeled "Atlas Files List" on the File
Name Options dialog (Section V-1.2).


V-2.1.2. Atlas Index Files

The Atlas Index File contains records that identify each spectral
type in the atlas and supply the name of the file containing the
spectrum.  The format of the records carrying this information is
as follows:

     Field             Data Type   Contents

     Spectral Type     String[12]  The spectral type for the
                                   atlas entry.

     (Unused)          Longint     This field is designed to hold
                                   a spectral type code (Section
                                   V-2.2.4).  The field is
                                   currently unused and should be
                                   set to 0.

     File Name         String[12]  Name of the file containing
                                   the spectrum (name +
                                   qualifier, no path).  (See
                                   Section V-2.4 for the format
                                   of this file.)

An Atlas Index File must be supplied for every atlas identified
in the Atlas List File (Section V-2.1.1).  An Atlas Index File
may contain a maximum of 20 entries.  The following Atlas Index
Files, identified in ATLAS2.LST, are supplied with the exercise:

          MS.ATL         Main Sequence
          O8_LUM.ATL     Luminosity near O8
          B2_LUM.ATL     Luminosity near B2
          A3_LUM.ATL     Luminosity at A3
          F5_LUM.ATL     Luminosity at F5
          G2_LUM.ATL     Luminosity at G2
          K0_LUM.ATL     Luminosity at K0
          M2_LUM.ATL     Luminosity near M2
          

V-2.2. Star Fields

The star fields for this exercise are identified in the Star
Field List File (Section V-2.2.1).  Data for each star field is
carried in a Star Field Data File (Section V-2.2.2).  The format
and purpose of these files is the same as those used to define
the star fields in the CLEA exercises "Photoelectric Photometry
of the Pleiades" and "The Hubble Redshift-Distance Relation",
with the exception that various specific fields are important to
some exercises and not used in others.

Two star fields are supplied with the exercise.  The file
PLEIADES.DAT contains data for stars in the region of the
Pleiades.  This file is identical to that supplied with the
Pleiades photometry exercise, except that spectral type codes
have been added.  (This version of PLEIADES.DAT can be used with
the Pleiades photometry exercise, and should replace the one
supplied therein if the exercises are kept in the same
directory.)  The file SPECFLD1.DAT contains an artificial star
field that was generated with the following parameters:

          Right Ascension:    6 Hr 0 Min to 6 Hr 24 Min
          Declination:        30.0 Deg to 35.0 Deg
          Number of Stars:    500
          Magnitude Range:    3.5 to 15.0
          Percent Type O:      1%
             "     "   B:      4%
             "     "   A:     10%
             "     "   F:     15%
             "     "   G:     30%
             "     "   K:     30%
             "     "   M:     10%
          Percent Lum. I:      5%
             "     "   III:   25%
             "     "   V:     70%
          

When creating new star fields for this exercise, or modifying
existing fields, give consideration to the following:

     1)   The "finder" (wide) field of the simulated telescope is
          2.5 degrees square.  Users should, in general, provide
          fields that are at least 5 degrees square to allow
          slewing from edge to edge of the field that first
          appears.  Fields should not be larger than 7.5 degrees
          square.

     2)   This software does not currently provide for displaying
          galaxies.  If fields from the Hubble redshift exercise
          are used, the galaxy records should be removed, and
          spectral type codes (Section V-2.2.4) should be added
          to the records for the stars.

     3)   Avoid high declinations (stay within -60 < dec < +60).
          The display algorithm is relatively simple, basically a
          "square" projection.

     4)   Similarly, avoid fields that straddle the 24Hr/0Hr
          dichotomy in right ascension.  (The program will not
          identify a coordinate of, for example, 23Hr 50Min RA as
          being "near" one at 0Hr 5Min, etc..)


V-2.2.1. The Star Field List

This file provides a list of the files that contain the star data
for each star field, along with the coordinates of the field
centers.  It is identified in the field labeled "Star Fields
List" on the File Name Options dialog (Section V-1.2); the
default is  SPECFILS.DAT.  Records in this file have the
following format (see general rules under V-2):

     Field             Data Type   Contents

     File Name         String[12]  Name of Star Field Data File
                                   (name + qualifier, no path).

     Right Ascension   Real        RA of field center in decimal
                                   hours (0.0..24.0, but see
                                   Section V-2).

     Declination       Real        Dec of field center in decimal
                                   degrees (-90.0..+90.0, but see
                                   Section V-2).

     Field Name        String[20]  Field identification for
                                   selection lists.

     Default           Boolean     One record in the file may
                                   carry a 1 (True) in this field
                                   to identify the default star
                                   field.  All other records
                                   should carry a 0 (False) in
                                   this field.

When the telescope is moved via the "Set Coordinates" button, the
program searches the star fields list to find the field center
closest to the target coordinates, and loads the corresponding
Star Field Data File.

     NOTE: the star fields list is not searched during a slew
     (using the N-S-E-W buttons).  It is therefore possible to
     slew off a star field into empty space, even though a
     neighboring field may be available.  Always use the "Set
     Coordinates" button or the "Change Field" menu selection to
     change fields.  (Of course, if the nearest field center is
     too far away or the field is small you may still get an
     empty screen when using the "Set Coordinates" button.)


V-2.2.2. Star Field Data Files

These files contain positional and other data for each star in a
field.  Each entry in the star fields list (Section V-2.2.1)
identifies a field data file, which must be present in the
working directory when the exercise is run.  (Note that these
files are not identified on the Options dialog (Section V-1).)
Two of these files are supplied with the exercise (Section V-
2.2).  The user may add as many as desired (supplying
corresponding entries in SPECFILS.DAT), and may also
add/delete/modify data in the files provided.  Star Field Data
File records have the following format (see general rules under
V-2):

     Field             Data Type   Contents

     Star ID           String[15]  Optional name, HD/BD number,
                                   or other identification.
                                   *Note 1*

     Right Ascension   Real        RA of star in decimal hours
                                   (0.0..24.0).

     Declination       Real        Dec of star in decimal degrees
                                   (-90.0..+90.0).

     V Magnitude       Real        Apparent magnitude of star.

     B-V Color         Real        Not used in this exercise.

     U-B Color         Real        Not used in this exercise.

     (Unused)          Real        For future use.

     (Unused)          Real        For future use.

     (Unused)          Byte        For future use.

     (Unused)          Byte        For future use.

     (Unused)          Byte        For future use.

     (Unused)          Byte        For future use.

     Spectrum          Longint     Spectral type code (see
                                   Section V-2.2.4).

     Comment           String[23]  Optional additional
                                   information.  (The supplied
                                   files carry the spectral type
                                   in this field.)  *Note 1*.

     
     Notes:
     
     (1)  Enter two single quotes ('') to blank out this field.


V-2.2.3. The Spectrum Index File

The Spectrum Index File contains records that link spectral types
to the files containing the spectra.  The default Spectrum Index
File supplied with the exercise (JSPEC.SPI) associates spectral
types with the supplied Jacoby spectral library (Section VI-1).
Records in the Spectrum Index File have the following format:

     Field             Data Type   Contents

     Spectrum          Longint     Spectral type code (see
                                   Section V-2.2.4).

     File Name         String[12]  Name of the file containing
                                   the spectrum (name +
                                   qualifier, no path).  (See
                                   Section V-2.4 for the format
                                   of this file.)

When used, the records in this file are read into memory and
sorted by spectral type code.  The file itself need not be
sorted.


V-2.2.4. The CLEA Spectral Type Code

In order to provide indexing of spectral types to expedite table
searches, etc., we have developed a spectral type code.  The
coded spectral type consists of 8 decimal digits and is stored in
a long integer (4 byte) field.  The digits are set in pairs as
follows:

               Spectral Type Code:  "aabbccdd"

               Field "aa" (Temperature Class)

                    O:   10
                    WR:  11
                    
                    B:   20
                    Be:  21
                    
                    A:   30
                    Am:  31
                    Ap:  32
                    
                    F:   40
                    
                    G:   50
                    
                    K:   60
                    
                    M:   70
                    R:   71
                    N:   72
                    S:   73

               Field "bb" (Temp. Subclass)

                    0:   00
                    0.5: 05
                    .
                    .
                    .
                    9:   90
                    9.5: 95

               Field "cc" (Luminosity Class)

                    I:        10
                    Ia:       11
                    Ib:       12
                    I-II:     15
                    II:       20
                    II-III:   25
                    III:      30
                    III-IV:   35
                    IV:       40
                    IV-V:     45
                    V:        50
                    VI/SD     60
                    WD        70

               Field "dd" (Other)

                    (For future enhancements)

               Examples:

                    G2V       = 50205000
                    B9.5IV-V  = 20954500
                    M2III     = 70203000

To match a spectral type to an available spectrum, the software
searches the spectrum index (Section V-2.2.3) for a match on the
spectral type code.  If an exact match is not found, a search is
made for the closest earlier type of the correct luminosity
class.  If none is found, the closest earlier spectral type in
the Index File, regardless of luminosity class, is returned.
Thus, the spectrum obtained for a star may not exactly correspond
to the spectral type code given in the Star Field Data File
(Section V-2.2.2), but the algorithm attempts to minimize the
error in absolute magnitude resulting from an inexact match.


V-2.3. List of Unknowns for Classification

The file identified in the "Unknowns List" field on the File Name
Options dialog (Section V-1.2) provides a list of unknown spectra
to be classified by the students, and identifies the
corresponding files containing the spectra.  (These spectra do
not have to be "taken" by the students to be classified.)  The
file CLASSIFY.LST is provided with the exercise as the default
unknowns list.  (The correct spectral classifications for the
stars in CLASSIFY.LST are provided in the file CLASSIFY.KEY.)
Records in the unknowns list file have the following format:

     Field             Data Type   Contents

     Unknown ID        String[65]  Name/ID of the star to appear
                                   on the program stars selection
                                   list.

     File Name         String[12]  Name of the file containing
                                   the spectrum (name +
                                   qualifier, no path).  (See
                                   Section V-2.4 for the format
                                   of this file.)


V-2.4. Data Format for Spectra

Stellar spectra used in this exercise are stored individually in
text files as lists of wavelengths and associated normalized
intensities.  This format is used both for spectra supplied with
the exercise (*.SP, Section VI-1) and spectra "taken' by the
students and saved for classification (*.CSP, Section IV-3).  The
format of an individual record in a spectrum file is as follows:

     Field             Data Type   Contents

     Wavelength        Real        Wavelength in ngstroms.

     Intensity         Real        Normalized intensity (see
                                   below) at the given
                                   wavelength. (0.0 to 1.0)

The following rules should be followed when preparing additional
spectra for use in this exercise:

     1)   The file should be in ascending order by wavelength.

     2)   The range in wavelengths should include the display
          range specified in "Wavelength Range" on the Startup
          Parameters/Options dialog (Section V-1.1).

     3)   The wavelength interval between data points is not
          fixed, but must be uniform.  (The software makes
          internal use of a fast interpolator that requires
          uniform spacing.)  The nominal value of the interval is
          1 .

     4)   Intensities should be normalized to the highest value
          in the range of data provided.  All intensity values
          should be in the range 0.0 to 1.0.


V-3. Using a Spreadsheet Program


This software provides the following features to expedite
students' use of a spreadsheet program for data reduction and
analysis:

     1)   Classification results may be saved in a file (*.CTX)
          that is formatted for import into most commercial
          spreadsheet programs.

     2)   If an available spreadsheet program is identified in
          the "Spreadsheet Program File" field on the File Name
          Options dialog (see Section V-1.2), the spreadsheet may
          be accessed directly from the exercise.


Selecting "Results"..."Save to File" from the main menu on the
Classification Window causes recorded classifications to be
written to a file (qualifier .CTX) that is suitable for import
into a spreadsheet program.  Included in this file are the date,
time, table number and students name(s) from the login data; and
the object identification, magnitude, spectral classification,
and remarks for each star classified and recorded, arranged in
tab-delineated columns.  This file may also be used to save
classifications between sessions if the exercise must be
interrupted for any reason.  If the software locates an existing
.CTX file with the appropriate name (see Section IV-3), the
student is given the chance to reload it the first time the
Classification Window is accessed.


     NOTE: Do not use a text editor on a .CTX file if you intend
     to import it into a spreadsheet.  Many text editors convert
     tab characters to spaces when the file is re-written, which
     will cause the columnization to be lost.  Do all editing
     within the spreadsheet program itself, or make a copy of the
     file for the text editor.


If the software finds an entry in the "Spreadsheet Program File"
field on the File Name Options dialog (Section V-1.2), the
"Spreadsheet" item on the "Results" sub-menu is enabled.
Selecting "Results"..."Spreadsheet" will then start the
spreadsheet software.  The exact technique for loading the .CTX
file will depend on the spreadsheet - consult your documentation.
(As examples, the file can be opened directly into Microsoft
Excel Version 4.0, while Lotus 123 Version 2.2 requires
"File"..."Import"..."Numbers".)  To return to the exercise,
either minimize the spreadsheet program or exit from it.
(Remember to save the results again If you make additional
classifications and wish to return to the spreadsheet.  In this
case you must also re-load the file into the spreadsheet to get
the new data.)


V-4. Revised CLEA Help Facility

This exercise utilizes an extension of the Help facility
described in the SUG.  The main features of the revised facility
are a Help topic selection list, with related topics indented
under group headings, and the ability to place the text for
multiple Help topics in a single file.  Both the selection list
and the individual Help windows now include a string search
capability to assist the user.  As has been the case, all files
related to the Help facility are in text format to facilitate
modification or replacement by the instructor.  The revised
general Help facility is described in Section 4.1.  (This
facility will eventually be used in all CLEA exercises, and the
material in Section 4.1 will appear in the SUG.)

This exercise also employs a specialized extension of the Help
facility that provides a list of spectral features by wavelength,
including cursor tracking and line marking on the spectrum
displays, and related individual Help windows for each line in
the list.  This facility is described in Section 4.2.


V-4.1. General Help Facility

The revised general Help facility includes several components.
The Help Index File (Section V-4.1.1) identifies the available
Help topics and provides for indentation under group headings
when the list is displayed for selection.  The text for each Help
topic is placed in a Help Text File (Section V-4.1.2), under a
topic heading that duplicates the Index File entry.  A string
search capability speeds topic searches in both the selection
list and the individual Help windows.  Its use is self-evident.

The "User Help" and logout "Reminder" features are retained as
described in the SUG.


V-4.1.1. The Help Index File

The Help Index File identifies available Help topics for
selection and points to the file containing the text for each
topic.  Entries in the Help Index File also provide topic
grouping for indentation under group headings on the selection
list.

Records in the Help Index File have the following format:

     Field             Data Type   Contents

     Topic/Group Hdr   String[65]  Topic or group header (see V-
                                   4.1.1.1 below) to appear on
                                   the Help selection list.

     File Name         String[12]  Name of the file containing
                                   the text for the Help topic
                                   (name + qualifier, no path).
                                   (See Section V-4.1.2 for the
                                   format of this file.)  If the
                                   record's topic field contains
                                   a group header, this field
                                   must contain either 'begin' or
                                   'end' (see V-4.1.1.1 below).

Two Help Index Files are used in this exercise.  They are
identified on the File Name Options dialog (Section V-1.2) as
"Main Help List" and "Classify Help List".  The default file
names are "SPECHLP.LST" and "CLASSHLP.LST".


V-4.1.1.1. Topic Grouping and Indentation

Topics on the Help selection list may be grouped and indented
under group headings.  To identify a group, place a record in the
Help Index File with the group header in the first field and
'begin' in the second.  All topics below this header will be
indented two spaces on the selection list until a record with the
same group header in the first field and 'end' in the second is
encountered.  Groupings may be nested, each will indent an
additional two spaces.  Be sure that 'end' records for all groups
are provided, in the opposite order of the 'begin' records.  For
examples, see the default Help Index File SPECHLP.LST provided
with the exercise.

Group headings appear on the selection list with a "-" at each
end.  If the user selects a group heading from the dialog list,
he/she is instructed to select a specific subtopic under the
heading.


V-4.1.2. Help Text Files

Text for the Help screens is maintained in Help Text Files
(usually identified with the qualifier .HLP).  If there is only
one topic in the file, it may simply contain the text for that
topic (as described in the SUG).  If one file contains multiple
topics, the text for each is entered under a topic header.  Each
topic header appears on a single line and must be identical to
the entry in the first field of the Help Index File record
(Section V-4.1.1), except that the Help Text File entry is
enclosed in asterisks ("*"), rather than single quotes ("'").
There are no special rules for the text entered under the
headers, except that a maximum of 72 characters per line is
recommended.  Users who create new Help text should check its
actual appearance in a Help window.  Variable width fonts can
cause unanticipated changes in appearance.

Group headers do not have associated text, and therefore should
not have related entries in a Help Text File.  For examples of
Help Text Files, see SPECLAB.HLP and CLASSIFY.HLP provided with
the exercise.


V-4.2. The Spectral Line List/Help Facility

A modified version of the general Help facility described above
is used for the spectral line identification list and associated
Help facility.  The Line List File described in Section V-4.2.1
is a modification of the general Help Index File (Section V-
4.1.1), and serves in its place.  The Line Help File (Section V-
4.2.2 is essentially the same as the general Help Text File
(Section V-4.1.2), except for a slight change to the headers.


V-4.2.1. The Line List File

The Line List File is much like the general Help Index File
described in Section V-4.1.1, with an added real field to hold
the wavelength.  In addition, topic grouping and the associated
records are not used in this file.  Records in the Line List File
have the following format:

     Field             Data Type   Contents

     Wavelength        Real        Wavelength of the spectral
                                   line/feature in ngstroms.

     Line ID           String[65]  Identification of line/feature
                                   to appear on the Line ID list.

     File Name         String[12]  Name of the file containing
                                   the Help text for the line
                                   (name + qualifier, no path).
                                   (See Section V-4.2.2 for the
                                   format of this file.)

One Line List File is used in this exercise.  It is identified on
the File Name Options dialog (Section V-1.2) as "Spectral Line
List".  The default file name is "SPECLNS.LNL".


V-4.2.2. The Line Help File

A special format is required for the topic (line) headers in this
file, which is otherwise similar to the general Help Text File
described in Section V-4.1.2.  Each header begins with an
asterisk ("*") in column 1, as before.  This is immediately
followed by the wavelength of the line (), rounded to two
decimal places.  This is followed by three spaces, then the Line
ID as it appears in the Line List File (Section V-4.2.1), then a
final asterisk.  Help text for each line is entered following the
header, as before.  For an example, see SPECLNS.HLP included with
the exercise.


VI.  ASTRONOMICAL DATA, MODELS AND ALGORITHMS


VI-1. The Jacoby Spectral Library

One hundred sixty-one stellar spectra (files J001.SP through
J161.SP) are included with this exercise.  This material was
prepared for CLEA by Dr. Gordon Spear of Sonoma State University
from the spectral library originally published by Jacoby, Hunter,
and Christian in 1984.  Additional information is given in the
file JACOBY.DOC, the format of the .SP files is described in
Section V-2.4.  The file JACOBY2.INX identifies the stars and
gives spectral types and dereddened colors.  Associations between
the spectra and the CLEA spectral type codes (Section V-2.2.4)
are assigned in the file JSPEC.SPI (Section V-2.2.3).  These
spectra are used both as standards and as unknowns in this
exercise.


VI-2. Integration of Spectra (Magnitudes, Telescopes and Noise)

Integration of ("taking") stellar spectra involves the following
user-modifiable parameters:

          Base Magnitude (Section V-1.1)
          Sky Magnitude          "
          Base Photon Count      "
          Wavelength Range       "
          Timer Wait             "
          Scope Factor   (Section V-1.3, also see VI-2.1 below)

In addition, we have:

          Sp(Wvl) = the spectrum assigned to the star (normalized
                    intensity as a function of wavelength (Wvl)).
                    The value of Sp(Wvl) lies in the range
                    (0.0..1.0).  (See Sections V-2.4, V-2.2.4,
                    VI-1)

          m       = the apparent magnitude of the star

To integrate a spectrum, we begin by computing

          mBase = Base Magnitude + Scope Factor(Current Scope)

We also determine the Slit Factor, which is a fraction (0.0..1.0)
reflecting the accuracy with which the star is centered in the
slit.  (If the Slit Factor is less than 0.05, we assume we are
reading only the sky (B=0).)  We compute a brightness (B) from
the magnitude equation and the Slit Factor:

          B = Slit Factor * 10**((m - mBase) / -2.5)

Similarly, a sky brightness (BSky) is computed from the Sky
Magnitude parameter (mSky):

          BSky = 10**((mSky - mBase) / -2.5)

We now compute an array of intensities (Int(i)) at 500 discrete
points ("spectrometer channels") covering the specified
wavelength range:

          Int(i) = B * Sp(Wvl(i))

(The values of Sp(Wvl) at points intermediate to the original
tabulated values are determined by 3-point interpolation (Meeus,
Ch.3).)  A related array of photon counts (Count(i)) is
initialized to zero, as are accumulators for the total signal
counts, total sky counts, and elapsed time.

The software now initiates a timer, using the Timer Wait
parameter.  At each timer interrupt we perform the following
calculations for all points in the array Count(i):

          XM = Base Photon Count * Int(i)
          New = PoiDev(XM)
          add New to Total Signal
          SM = Base Photon Count * BSky
          Sky = PoiDev(SM)
          add Sky to Total Sky
          add New + Sky to Count(i)

where PoiDev(XM) is an integer value that is a random deviate
drawn from a Poisson distribution of mean XM (Press, et al, Ch.
7).  We then calculate the signal to noise ratio (SNR) from:

          Total Count = Total Signal + Total Sky
          SNR = (Average Signal) / (Average Count)

where the averages are computed by dividing the Total Signal and
Total Count by the number of points (500).  The values in array
Count(i) are normalized for plotting by dividing by MaxCount,
where MaxCount is the largest current value in Count(i).

This process continues until stopped by the user, at which time
the plot display changes to connect the individual points, and
the normalized values may be saved in a .CSP file (Section V-2.4)
for classification.

The effects of varying the parameters can be summarized as
follows:

     1)   To speed up the overall rate at which the spectra
          integrate, lower the Base Magnitude (increase the
          numeric value), increase the Base Photon Count, or
          both.

     2)   To lower the overall integration rate, raise the Base
          Magnitude (decrease the numeric value), decrease the
          Base Photon Count, increase the Timer Wait, or any
          combination of the above.

     3)   To increase the effect of the sky on the spectra, raise
          the Sky Magnitude (decrease the numeric value), and
          vice versa.

     4)   To vary the relative integration rates for the various
          telescopes, change the Scope Factors (see IV-2.1
          below).

Some "tuning" of the parameters may be required to achieve
satisfactory results.  The effective overall integration rates
vary significantly with processor speed and video display
performance.


VI-2.1 Calculating the Scope Factors

The scope factors (Section V-1.3) set the relative "gain" in
light gathering power for telescopes of various sizes.  Scope
factors (SF) are calculated from the magnitude equation as
follows:

     Let  A = aperture (diameter) of telescope
          B = aperture of "base" telescope

     then SF = 2.5 * log((A/B)**2)
             = 5 * log(A/B)

For example, in this exercise the base telescope has an aperture
of 0.4 meters.  Therefore, for a 1 meter telescope:

          SF = 5 * log(1.0/0.4)
             = 5 * log(2.5)
             = 2

And for a 4 meter telescope:

          SF = 5 * log(4.0/0.4)
             = 5 * log(10.0)
             = 5

The scope factor for the base telescope should be set to 0.0.
(In this exercise we could, for example, make the 1 meter
telescope the base.  Then the scope factor for the 0.4 meter
would be -2, and for the 4 meter, SF = 3.)  Note that the Base
Magnitude and Base Photon Count parameters (Section V-1.1) apply
to the base telescope, and establish the reference point for
spectral integration rates and other calculations (see VI-2 above
for details).


VI-3. "Photo" Displays

The following technique is employed to create the spectrum
displays in the "Photo" mode.  To make the display more
authentically "photographic", the value of the intensity (range
0.0 to 1.0) from the spectrum data (Section V-2.4) is replaced by
its square root.  Then, to prevent the brightest areas of the
display from merging into the white background, this value is
multiplied by 0.9.  The resulting value, in the range 0.0 to 0.9,
is mapped to the nearest color in a palette consisting of 64
levels of gray scale between black (0) and white (255).  The
resulting color (gray shade) is displayed across the breadth of
the spectrum at the corresponding wavelength position.

16-color video modes provide insufficient levels of gray scale
and yield a display that is distinctly non-photographic and
generally unsatisfactory.  For this reason the "Photo" mode is
disabled when the software detects 16-color video.  If your
system is operating in a 16-color mode, it may be possible to
change it.  See the SUG for details.


VI-4. Measuring Equivalent Widths

The equivalent width of a spectral line represents the total
energy absorbed in the line, divided by the energy per unit
wavelength emitted by the star in its continuum spectrum around
the wavelength of the line.  The equivalent width may be thought
of as the width of a completely black strip in the spectrum whose
area is the same as the area within the line profile, and is
generally expressed in ngstroms or millingstroms.  (For further
information, see Harwit, Ch.7, or other references on
astrophysics and stellar atmospheres.)  In this exercise we
provide a facility for measuring equivalent widths as a method of
quantifying line strengths for comparison.  To determine
equivalent widths, the software calculates the area between the
intensity levels within the line and the continuum level, using a
Simpson's rule integrator (Press, et al, Ch.4).

Equivalent width measurement is available on the Classification
Window.  Follow the instructions provided on the Help screen
(select "Help"..."Measure Equivalent Widths").  Take care in
marking the "shoulders" of the line for measurement, you must
accurately indicate both the continuum level and the wavelength
limit of the line on each side.  Equivalent width measurement is
not available in the "Photo" spectrum display mode (Section VI-
3).


                           REFERENCES




The following are excellent (fairly technical) references for
spectral classification of stars:

Jaschek, C. and Jaschek, M.: The Classification of Stars,
     Cambridge University Press, Cambridge, 1990

Kaler, J.B.: Stars and Their Spectra, Cambridge University Press,
     Cambridge, 1989


The following are referenced in the text:

Harwit, M.: Astrophysical Concepts, 2nd ed., Springer-Verlag, New
     York, 1988

Meeus, J.: Astronomical Algorithms, Willmann-Bell, Richmond, 1991

Press, W.H., Flannery, B.P., Teukolsky, S.A., and Vetterling,
     W.T.: Numerical Recipes, Cambridge University Press,
     Cambridge, 1986


The Jacoby spectral library was originally published by Jacoby,
Hunter, and Christian in 1984.  The reference is Astrophys. J.
Suppl. 56, 256.


