PRO LAMBDA_ITERATE,TAU,B,EPSILON,J,S,STEP,TIME,NOPLOT=NOPLOT
;; MAIN PROCEDURE

;; INPUT:
;; tau          OPTICAL DEPTH SCALE
;; B            PLANCK FUNCTION AS A FUNCTION OF TAU
;; epsilon      DESTRUCTION PROBABILITY PER EXTINCTION
;;                      NOTE: EPSILON IS SMALL!

;; OUTPUT:
;; J            MEAN INTENSITY, LAMBDA-TRANSFORMED SOURCE FUNCTION
;; S            SOURCE FUNCTION AFTER NUMBER OF ITERATIONS
;; step         NUMBER OF ITERATIONS NEEDED FOR

;; LAST: FEB 3 2000, JMK

IF NOT keyword_set(NOPLOT) THEN begin
 plot_oi,tau,B,line=1,yr=[0,1.1*max(B)],ys=1,$
  xtitle='!4t!3',ytitle='B (erg cm!e-2!n)',chars=1.    ;charsize(1.2)
 oplot,[2e-4,1e-3],([.91,.91])*1.1*max(B),line=1
 xyouts,2e-3,.9*1.1*max(B),'B',chars=1.    ;charsize(1.2)
 oplot,[2e-4,1e-3],([.81,.81])*1.1*max(B),line=2
 xyouts,2e-3,.8*1.1*max(B),'J',chars=1.    ;charsize(1.2)
 oplot,[2e-4,1e-3],([.71,.71])*1.1*max(B)
 xyouts,2e-3,.7*1.1*max(B),'S',chars=1.    ;charsize(1.2)
 xyouts,2e-4,.5*1.1*max(B),$
    '!4e!3 ='+string(epsilon,format='(f5.3)'),chars=1.    ;charsize(1.2)
ENDIF

;;;;First guess:
 step=0
 S=B
 t1=systime(0)
 Lambda=lmbd(tau)

;;;;Iterations:
NEXT:
 prevs=S
 S=(1-epsilon)*Lambda##S+epsilon*B
 dev=max(abs(prevS-S)/S)
 IF dev lt (epsilon)/100. THEN GOTO,READY
 step=step+1
 GOTO,NEXT
;;;;

READY:
 J=Lambda##S

IF NOT keyword_set(NOPLOT) THEN begin
 xyouts,2e-4,.61*1.1*max(B),'# steps ='+string(step),chars=1.    ;charsize(1.2)
 oplot,tau,J,line=2
 oplot,tau,S
ENDIF

 print,'TOTAL # STEPS : ',step
 t2=systime(0)
 dt1=fix(strmid(t1,14,2))*60+fix(strmid(t1,17,2))
 dt2=fix(strmid(t2,14,2))*60+fix(strmid(t2,17,2))
 time=dt2-dt1
 print,'TIME ELAPSED: ',time,' SEC'
END
