; file: sst_gettiming.pro
; init: Jan 13 2020  Rob Rutten  Deil
; last: Jan 13 2020  Rob Rutten  Deil

;+

pro sst_gettiming,obsdate,timefile,$
    nt=nt,utstart=utstart,utend=utend,cadence=cadence

 ; PURPOSE:
 ;   get and print start time, end time, cadence from SST tseries file
 ;   
 ; INPUTS:
 ;   obsdate: eg '2018.06.10'  
 ;   timefile: eg ,'chromis/tseries_chromis.sav'
 ;
 ; OUTPUTS PER KEYWORD:
 ;   obvious
 ;
 ; HISTORY:
 ;   Jan 13 2020 Rob Rutten   
;-

; answer no-parameter query 
if (n_params(0) lt 2) then begin
  sp,sst_gettiming
  return 
endif

; do the work
restore,timefile
nt=n_elements(time)
datetime=obsdate+'_'+time
timearr=anytim2tai(datetime)
utstart=time[0]
utend=time[nt-1]
cadence=(timearr[nt-1]-timearr[0])/(nt-1)

print,' ===== nt ='+trimd(nt)+'  ut = '+utstart+$
  ' - '+utend+'  cadence ='+trimd(cadence,4)

end


; =============== main for testing per IDLWAVE H-c ======================

cd,'/media/rutten/SSTNEW/alldata/SST/2018-06-10-vasco'
obsdate='2018.06.10'

timefile='crisp/tseries.8542.12:21:09.calib.sav'
timefile='crisp/tseries.6302.12:21:09.calib.sav'
timefile='crisp/tseries.6563.12:21:09.calib.sav'
timefile='chromis/tseries_chromis.sav'

sst_gettiming,obsdate,timefile,$
    nt=nt,utstart=utstart,utend=utend,cadence=cadence

end

