; file: sst_fitsparams.pro
; init: Dec  3 2019  Rob Rutten  Deil
; last: Dec 22 2019  Rob Rutten  Deil
; note: email Luc Rouppe van der Voort Dec  3 2019  

pro sst_fitsparams,filename,time,lambda,xcent0,ycent0

; open the FITS file
 hdr = headfits(filename)
 bitpix = fxpar(hdr, 'BITPIX')
 dimensions = long(fxpar(hdr, 'NAXIS*'))
 nx = dimensions[0]
 ny = dimensions[1]
 nl = dimensions[2]
 ns = dimensions[3]
 nt = dimensions[4]
 case bitpix of
     16 : array_structure = intarr(nx, ny, nl)
     -32 : array_structure = fltarr(nx, ny, nl)
     else : stop
 endcase
 Nlines = where(strmatch(hdr, 'END *'), Nmatch)
 Nlines = Nlines+1
 Npad = 2880 - (80L*Nlines mod 2880)
 Nblock = (Nlines-1)*80/2880+1  ; Number of 2880-byte blocks
 offset = Nblock*2880           ; Offset to start of data
 openr, lun, filename, /get_lun, /swap_if_little_endian
 fileassoc = assoc(lun, array_structure, offset)

 ; get time and wavelength
 lambda=[0.]
 wcs = mrdfits(filename,'WCS-TAB',whdr, /silent)
 if nl eq 1 then begin ; wideband?
     coords = wcs.hpln_hplt_time
     time = reform(coords[2,0,0,*]) ; seconds from midnight
 endif else begin ; nb cube?
     coords = wcs.hpln_hplt_wave_time
;         hpln   = reform(coords[0,*,*,0,*])
;         hplt   = reform(coords[1,*,*,0,*])
     lambda = reform(coords[2,0,0,*,0])
     time   = reform(coords[3,0,0,*,*])
 endelse
 xcent0=avg(coords[0,*,*,0])   ; pointing center FOV
 ycent0=avg(coords[1,*,*,0])

end
