; file: sst_fits2timesav.pro
; init: Dec 22 2019  Rob Rutten  Deil
; last: Dec 22 2019  Rob Rutten  Deil

;+

pro sst_fits2timesav,obsdate,fitsfile,timesavfile

 ; PURPOSE: reform fits-style timings into classical tseries file
 ;    
 ; INPUTS:
 ;   obsdate: e.g. '2018.06.10'  (format mandatory)
 ;   fitsfile: string name fits files
 ;   timesavfile: string output file
 ;
 ; OUTPUTS:
 ;   timesavfile   
 ;   
 ; HISTORY:
 ;   Dec 22 2019 RR: start   
;-

; answer no-parameter query 
if (n_params(0) lt 3) then begin
  print,'sst_fits2times,fitsfile,timesavfile'
  sp,sst_fits2timesav
  return       ;RR return,-1 when this is a function
endif

; get parameters from fits file with Luc recipe
; time = 2D array: seconds past UT midnight for each wavelength per scan
sst_fitsparams,fitsfile,time,lambda,xcent0,ycent0
sztime=size(time)
nwav=sztime[1]
nscan=sztime[2]

; rework time into classical SST tseries format
timearr_sst=anytim2tai(obsdate)+time[fix(nwav/2),*]  
midtimes=anytim2utc(timearr_sst,/vms,/time_only)
time=reform(midtimes)

; now time = 1D time-notation array of midtimes UT per scan
save,time,filename=timesavfile

end


; =============== main for testing per IDLWAVE H-c ======================

cd,'/media/rutten/SSTNEW/alldata/SST/2018-06-10-vasco/sst'
obsdate='2018.06.10'
fitsfile='nb_3950_2018-06-10T12:21:19_scans=0-286_corrected_int_im.fits'
timesavfile='tseries_chromis.sav'

sst_fits2timesav,obsdate,fitsfile,timesavfile

end
