; file: makesstsav.pro = make standard SST idlsave files for 2008-06-15-RBEs
; init: Mar  6 2019  Rob Rutten  Eindhoven
; last: Mar  6 2019  Rob Rutten  Eindhoven

; make timing savefile such as "tseries.8542.09:48:31.calib.sav"
;   date = nt values date  2016-09-05 
;   time = 09:48:40.112 etc   nt values
;; a 24 minute Hα sequence started at 09:15 UT cadence 6.7
nt=212
times=strarr(nt)
cad=6.7
hh=09
mm=15
ss=00.000
;RR ####### let be, generate when necessary
;; for it=0,nt-1 do begin
;;   time[it]=....
;; endfor


; make wavelength savefile auch as "spectfile.6563.idlsave"
;   spect_pos = full wavs in AA with lc = 6563.000 (fixed regardless of mu)
;; RBE pub 2009ApJ...705..272R:
;;   For the Hα data set, we used a 25 line position sequence, with 10
;;   pm steps ranging from −160 pm to +80 pm from line center
;; 1 nm = 10 AA; 1 pm = 10 mA

cd,'/home/rutten/data/SST/2008-06-15-RBEs/sst'
spect_pos=indgen(25)*0.1+6563.0-1.6
save,filename='spectfile.6563.idlsave'

print,spect_pos
; Ha_lc iw=16
; furthest red wing 0.8 AA iw=24

end
