; file: makecubefromscan.pro
; init: Aug  3 2014  Rob Rutten  Deil
; last: Aug  3 2014  Rob Rutten  Deil

pro makecubefromscan,infile,dummyout,nt=nt,selwav=selwav

;+
 ; NAME:  makecubefromscan.pro
 ; PURPOSE: convert single-moment CRISP scan in [x,y,t] cube(s) per wavelength
 ; DESCRIPTION: no time dependence!  Just to make blinkers with [x,y,t] SDO
 ; CALL:  makecubefromscan,infile,dummyout,nt=nt,selwav=selwav
 ; INPUTS: infile = string 'path/fitsfilename'
 ;         dumyout = dummy for call with doallfiles.pro
 ;         nt = desired cube time axis length
 ;         selwav = select this wavelength index 
 ;           if selwav=-1 then make cubes for all wavs, but watch disk space!!
 ; OUTPUTS: one or nwav fits files with _cube_iwav.fits extension in same dir
 ; HISTORY: Aug  3 2014 Rob Rutten start, for EB5
;-

; get infile
scan=readfits(infile) ; int array [964, 970, 41]
sizescan=size(scan)
nx=sizescan[1]
ny=sizescan[2]
nwav=sizescan[3]

; select one or all wavs
if (selwav ne -1) then begin
  startwav=selwav
  endwav=selwav
endif  else begin
  startwav=0
  endwav=nwav-1
endelse

; write cube(s)
for iwav=startwav,endwav do begin
  outcube=intarr(nx,ny,nt)
  outfile=str_replace(infile,'.fits',$
    '_cube_'+strmid(string(iwav+1E2,format='(I3)'),1,5)+'.fits')
  print,' ---- patience! -- now write '+outfile
  for it=0,nt-1 do outcube[*,*,it]=scan[*,*,iwav]
  writefits,outfile,outcube
endfor

end

; ============== run per IDLWAVE S-c or with doallfiles.pro =========

path='/home/rutten/data/SDO/2013-07-04-EB5/sstscans/'
infile=path+'ha_mg_rot.fits'
makecubefromscan,infile,outfile,nt=898,selwav=20

end
