; file: lp_openassoc.pro
; init: Jun 24 2017  Rob Rutten  Deil
; Jul 20 2017 

;+

pro lp_openassoc,file,$
  lun,xsize,ysize,zsize,bitpix,headeroffset,swap_endian

 ; NAME:
 ;   lp_openassoc   
 ;   
 ; PURPOSE:
 ;   open a "La Palma" SST file for assoc
 ;   
 ; DESCRIPTION:
 ;   straightforward
 ;   
 ; CALL:
 ;   see above
 ;   
 ; INPUTS:
 ;   file = string with path/filename
 ;   lun = the logical unit number to assoc into; must be specified
 ;         1-128 to avoid limitation to only 100-128 of /get_lun
 ;   
 ; OUTPUTS:
 ;   xszize,ysize,zsize = 3 dimensions
 ;   bitpix = word type (8=byte, 16=integer, -32=float)
 ;   headeroffset = size of the header needing to be offset in associng
 ;   swap_endian: need for endian swapping on this machine
 ;
 ; HISTORY:
 ;   Jun 24 2017 RR: start   
;-

; answer no-parameter query 
if (n_params(0) lt 8) then begin
  print,'lp_openassoc,file,'
  print,'  lun,xsize,ysize,zsize,bitpix,headeroffset,swap_endian'
  xp,lp_openassoc
  return  
endif

; check file extension
dummy=cgrootname(file,extension=ext)  ;RR needs coyotelib
if not(ext eq 'icube' or ext eq 'fcube' or ext eq 'bcube') then begin
  print,' ##### lp_openassoc abort: file '+file+' has no .*cube extension'
  return
end

; get cube geometry and file datatype from the LP header
lp_readheader,file,dims=ndim,header=header,datatype=datatype,$
  nx=xsize,ny=ysize,nt=zsize,endian=endian_file

; check
if (ndim ne 3) then begin
  print,' ##### lp_openassoc abort: '+file+' is not a 3D cube'
  return
endif
if (xsize eq 0 or ysize eq 0) then begin
  print,' ##### lp_openassoc abort: nx or ny zero in header '+file
  return
endif

; set bitpix
if (datatype eq 1) then bitpix=8
if (datatype eq 2) then bitpix=16
if (datatype eq 4) then bitpix=-32

; set header size
headeroffset=512

; set endian swap for this computer (usually LP files are little endian)
if ((byte(1L, 0, 1))[0] eq 1) then endian = 'l' else endian='b'
if (abs(bitpix) gt 8) and (endian ne endian_file) then $
  swap_endian=1 else swap_endian=0

; now open assoc
close,lun 
openr,lun,file,swap_endian=swap_endian

end



; =============== main for testing per IDLWAVE H-c ======================

cd,'/home/rutten/data/SST/2016-09-05-demo/'
file='crispex/crispex.6563.09:48:31.time_corrected.aligned.icube'

lun=1
lp_openassoc,file,$
  lun,xsize,ysize,zsize,bitpix,headeroffset,swap_endian

print,lun,xsize,ysize,zsize,bitpix,headeroffset,swap_endian

end
