; file: lp_im2spfile.pro
; init: Jun  3 2017  Rob Rutten  Deil, from Gregal; found in my laptop
; last: Jun 11 2017  Rob Rutten  Deil
; note: any size since uses assoc; exceedingly slow

;+

PRO lp_im2spfile, inputcube, NLP=nlp,NS=ns,VERBOSE=verbose,TMP_SIZE=tmp_size

 ; NAME:
 ;    lp_im2spfile.pro 
 ;
 ; PURPOSE: 
 ;   This routine produces a CRISPEX-ready spectral cube based
 ;   on an input image cube.   Based on im2spcube.pro from Gregal Vissers
 ;RR    Rob Rutten modifications labeled with ;RR lines
 ;RR    input order/dimensions:  nx, ny, nwav*nstokes*nt
 ;RR    output order/dimensions: nwav, nt, nstokes*nx*ny
 ;
 ; CATEGORY:
 ;   Data reduction
 ;
 ; CALLING SEQUENCE:
 ;   IM2SPCUBE, inputcube
 ;
 ; INPUTS:
 ;   inputcube - filename of the image cube
 ;
 ; KEYWORD PARAMETERS:
 ;   NLP     - number of datapoints in the spectral dimension. Defaults to 1.
 ;   NS      - number of datapoints in the Stokes dimension. Defaults to 1.
 ;   TMP_SIZE- size of data cube to be taken into memory 
 ;     (best not to exceed RAM). Defaults to 2.
 ;   VERBOSE - give user feedback
 ;
 ; OUTPUTS:
 ;   CRISPEX-ready spectral cube of same size and data type as input
 ;   image cube. Filename according to input filename, however with
 ;   '_sp' added before the cube extension.
 ;
 ; PROCEDURES USED:
 ;   Procedures: LP_HEADER, LP_GET, ;RR PROCESS_TIMER
;
; EXAMPLE:
;   lp_im2spfile, 'im.cube', NLP=6, /VERBOSE
;
; MODIFICATION HISTORY:
; 	Written by:	Gregal Vissers, 2013 Feb 1; from MK_SP_FROM_IM_CUBE
;       Jun  6 2017 RR: less printout, no huge cubes in memory
;   $Id
;-


IF (N_PARAMS() LT 1) THEN BEGIN
  MESSAGE,'Syntax: IM2SPCUBE, inputfilename [, NLP=nlp] [, NS=ns] [, TMP_SIZE=tmp_size] [, /VERBOSE]',/INFO
  RETURN
ENDIF

lp_readheader, inputcube, datatype=imtype, dims=imdims, nx=nx, ny=ny, nt=imnt, endian=endian_file			
IF (N_ELEMENTS(NLP) NE 1) THEN nlp = 1
IF (N_ELEMENTS(NS) NE 1) THEN ns = 1 
nt = imnt / nlp / ns  ;RR input nt, nwavs, nstokes
spnt = LONG(ns)*LONG(nx)*LONG(ny) ;RR output 3rd dim = nstokes images onto 1D

outputfilename = STRMID(inputcube,0,STRPOS(inputcube,'.',/REVERSE_SEARCH))+'_sp'

;; IF KEYWORD_SET(VERBOSE) THEN BEGIN
;;   MESSAGE,'About to create a '+STRING(spnt/1024E6*LONG(nt)*LONG(nlp)*LONG(imtype),$
;;                                       FORMAT='(F3.1)')+'GB cube with filename: '+outputfilename+'. Press [.c] to continue.',$
;;     /INFO
;;   STOP
;; ENDIF
;RR 
if (verbose ne 0) then PRINT,'Creating empty spectral cube...'
IF (imtype EQ 1) THEN BEGIN
  ext = '.bcube'
;RR  spfile = BYTARR(nlp,nt,spnt, /NOZERO)  ; unnecessary
ENDIF ELSE IF (imtype EQ 2) THEN BEGIN
  ext = '.icube'
;RR  spfile = INTARR(nlp,nt,spnt, /NOZERO) ; unnecessary; needed 17 GB memory
ENDIF ELSE IF (imtype EQ 4) THEN BEGIN
  ext = '.fcube'
;RR  spfile = FLTARR(nlp,nt,spnt, /NOZERO) ; unnecessary
ENDIF
;RR if (verbose ne 0) then PRINT,'Done!'
outputfilename += ext
IF (ns EQ 4) THEN extra_header = 'stokes=[I,Q,U,V], ns=4' ELSE $
  IF (ns EQ 2) THEN extra_header = 'stokes=[I,V], ns=2' ELSE extra_header=''
offset = 512

OPENR, lun, inputcube, /GET_LUN
OPENW, luw, outputfilename, /GET_LUN
readfile = ASSOC(lun, MAKE_ARRAY(nx,ny,nlp,TYPE=imtype,/NOZERO), offset)
;  readfile = ASSOC(lun, MAKE_ARRAY(nx,ny,TYPE=imtype,/NOZERO), offset)

gb = 1024.^3
IF (N_ELEMENTS(TMP_SIZE) NE 1) THEN tmp_size=2.
my = LONG(tmp_size*gb/nlp/nt/nx/4.) < ny
tmp = MAKE_ARRAY(nlp,nt,nx,my, TYPE=imtype,/NOZERO)

  ; Create header
dims = 3
case imtype of
  1: typestring = '(byte)'
  2: typestring = '(integer)'
  3: typestring = '(long)'
  4: typestring = '(float)'
  else: typestring = '(-)'
endcase
bheader = ' datatype='+strtrim(imtype,2)+' '+typestring
bheader += ', dims='+strtrim(dims,2)
IF KEYWORD_SET(INVERSE) THEN BEGIN
  bheader += ', nx='+strtrim(nx,2)
  bheader += ', ny='+strtrim(ny,2)
  bheader += ', nt='+strtrim(LONG(nlp)*LONG(nt),2)
ENDIF ELSE BEGIN
  bheader += ', nx='+strtrim(nlp,2)
  bheader += ', ny='+strtrim(nt,2)
  bheader += ', nt='+strtrim(LONG(nx)*LONG(ny),2)
ENDELSE
  ; add endianess
if ((byte(1L, 0, 1))[0] eq 1) then endianstr = 'endian=l'  $ ; little endian
else endianstr = 'endian=b'                                  ; big endian
bheader += ', '+endianstr
header = extra_header+' : '+bheader
;RR IF KEYWORD_SET(VERBOSE) THEN BEGIN
if (verbose ne 0) then PRINT,' header_out ='+header
;RR  STOP
;RR ENDIF
writefile = ASSOC(luw, BYTARR(512))
writefile[0] = BYTE(header)

writefile = ASSOC(luw, MAKE_ARRAY(nlp,nt,nx,TYPE=imtype,/NOZERO), offset)

pass = 0L
nsweep = (ny*2-1)/my
totpass = ULONG(nsweep)*ULONG(nt)
t0 = SYSTIME(/SECONDS)
FOR y0=0,ny-1,my DO BEGIN
  y1 = (y0+my-1) < (ny-1)
  FOR t=0,nt-1 DO BEGIN
    pass += 1L
    image = readfile[t]
    imout = TRANSPOSE(image,[2,0,1])
    tmp[*,t,*,0:(y1-y0)] = imout[*,*,y0:y1]
    ;RR PROCESS_TIMER, pass, totpass, t0, $
    ;RR   EXTRA='('+STRTRIM(t,2)+','+STRTRIM(y0,2)+','+STRTRIM(y1,2)+')'
  ENDFOR
  t1 = SYSTIME(/SECONDS)
  subpass = 0L
  subtotpass = LONG((y1-y0)+1)
  FOR y=y0,y1 DO BEGIN
    subpass += 1L
    writefile[y] = tmp[*,*,*,y-y0]
;RR     IF KEYWORD_SET(VERBOSE) THEN PROCESS_TIMER, subpass, subtotpass, t1
  ENDFOR
ENDFOR

FREE_LUN, lun, luw
END

; ===================== test per IDLWAVE Hyper-C ==================


cd,'/home/rutten/data/SST/2016-09-05-demo'
imfile='sdo_sst_xyt_0_0_0_nxyt_932_920_377_wavs_11_15_25.icube'
crispnwavs=15
crispnstokes=1

lp_im2spfile,imfile,nlp=crispnwavs,ns=crispnstokes,verbose=1

end
