; file: hawings2reeb.pro
; init: Dec 25 2018  Rob Rutten  Deil
; last: Dec 26 2018  Rob Rutten  Deil
; note: may run out of memory since loading full cubefiles

;+

pro hawings2reeb,bwfile,rwfile,reebfile,$
  cuthigh=cuthigh,cutlow=cutlow,show=show,success=success

 ; PURPOSE:
 ;   make (QS)EB and RE (RBE + RRE) enhancing Halpha wing fitscube  
 ;   EB = take brightest (QS)EB pixels of the two wings
 ;   RE = add darkest pixels in blue wing (RBEs) and in red wing (RREs)
 ;   
 ; INPUTS:
 ;   bwfile = Halpha blue-wing sampling fits file
 ;   rwfile = Halpha red-wing fits file at same separation from line center
 ;
 ; OPTIONAL KEYWORD INPUTS
 ;   cuthigh = histo_opt fraction for bright (QS)EBs (default 0.1)
 ;   cutlow = histo_opt fraction for dark RBEs and RREs (default 0.2)
 ;   show = 1/0: showex the three
 ; 
 ; OUTPUTS:
 ;   reebfile = output fits file   
 ;   
 ; OPTIONAL KEYWORD OUTPUT
 ;   success = 1/0: cutting worked or abort
 ;
 ; HISTORY:
 ;   Dec 25 2018 RR: start
;-

; answer no-parameter query 
if (n_params(0) lt 3) then begin
  sp,hawings2reeb
  return       
endif

; keyword defaults
if (n_elements(cuthigh) eq 0) then cuthigh=0.1
if (n_elements(cutlow) eq 0) then cutlow=0.2
if (n_elements(show) eq 0) then show=0
success=1

; get qseb upper cutoff value
bw=readfits(bwfile)
ebopt=histo_opt_rr(bw,cuthigh,/top_only) ; QSEB selection; they are rare
ebcut=max(ebopt)
ebopt=0 ; clean memory
if (ebcut eq max(bw)) then begin
  print,' ##### ABORT: cuthigh does not cut max, wide bright borders?'
  success=0
  return
endif
  
;; ; inspect
;; showex,bw-ebopt

; take brightest in blue wing or red wing
rw=readfits(rwfile)
reeb=bw
reeb[where(bw gt ebcut)]=bw[where(bw gt ebcut)]>rw[where(bw gt ebcut)]

;; ; inspect
;; showex,reeb,bw,rw,reeb-bw

; get RE lower cutoff value
reopt=histo_opt_rr(bw,cutlow,/bottom_only) ; RBE selection
recut=min(reopt)
reopt=0 ; clean memory
if (recut eq min(bw)) then begin
  print,' ##### ABORT: cutlow does not cut min, wide dark borders?'
  success=0
  return
endif

; take the darkest in the blue wing and add the darkest in the red wing
reeb[where(bw lt recut)]=bw[where(bw lt recut)]<rw[where(bw lt recut)]
reeb[where(rw lt recut)]=bw[where(rw lt recut)]<rw[where(rw lt recut)]

; inspect
if (show) then showex,bw,reeb,rw

; write result
writefits,reebfile,reeb

end


; =============== main for testing per IDLWAVE H-c ======================

cd,'/home/rutten/data/SST/2014-06-19-qi/sst'
cd,'/media/rutten/SSTDATA/alldata/SST/2015-10-11/sst'
bwfile='ha_bw.fits'
rwfile='ha_rw.fits'
reebfile='ha_reeb.fits'

hawings2reeb,bwfile,rwfile,reebfile,success=success,cutlow=0.35

; inspect
if (success) then showex,reebfile,bwfile,rwfile

end
