; file: sdo_viewlevel2.pro
; init: Jun  2 2020  Rob Rutten  Deil
; last: Jun  3 2020  Rob Rutten  Deil

;+
pro sdo_viewlevel2,wav,plotshifts=plotshifts

 ; showex all wav files in this SDO level2 dir (my notation for SDO 1.5)
 ; if the files for wav are .fz compressed they get uncompressed
 ; wav: AIA: '94','131','171','193','211','304','335','1600','1700','4500' 
 ;      HMI: 'mag','cont','dop'
 ; keyword input: plotshifts = plot shifts from successive ross-correlations
 ;
 ; Jun  2 2020 Rob Rutten
;-

; get current dir path; \ flag spaces in path if present (bloody Mac?)
; https://groups.google.com/forum/#!topic/comp.lang.idl-pvwave/Lo10H5XtN80
cd,current=thisdir
thisdir=strjoin(strsplit(thisdir,' ',/extract),'\ ') 

; define SDO "channel" search strings
sdowavs=''
if (strmatch(thisdir,'*level2*')) then $
  sdowavs=['_0094','_0131','_0171','_0193','_0211','_0304','_0335',$
           '_1600','_1700','_4500','_mag','_cont','_dop'] 
; check we are in level2 dir
if (sdowavs[0] eq '') then begin
  print,' ##### sdo_viewkevel2 abort: currrent dir is not level2'
  return
endif

; define permitted input wav strings
wavs=['94','131','171','193','211','304','335','1600','1700','4500', $  ; AIA
      'mag','cont','dop']                                               ; HMI
nwavs=n_elements(wavs)

; check wav specification 
iselwav=-1
for iw=0,nwavs-1 do if (wavs[iw] eq wav) then iselwav=iw
if (iselwav eq -1 ) then begin
  print,' ##### sdo_viewlevel2 abort: wav invalid = ',wav
  print,' ===== valid: ',wavs
  sp,sdo_getimage
  return
endif
selwav=wav

; if file rice-compressed (.fz) first uncompress
spawn,'funpack -D '+thisdir+'/*'+wavs[iselwav]+'.fits.fz'

; get file names
files=findfile(thisdir+'/*'+sdowavs[iselwav]+'*.fits')

; set up image cube
; (cannot showex files when nr of time steps exceeds IDL unit range)
read_sdo,files[0],indexim,/nodata
nx=indexim.naxis1
ny=indexim.naxis2
nt=n_elements(files)
imcube=intarr(nx,ny,nt)

; fill the cube
for it=0,nt-1 do begin
  read_sdo,files[it],indexim,im
  imcube[*,*,it]=im[*,*]
endfor

; show the sequence
print,' ----- plotshifts will be done when quitting showex'
showex,imcube

; optional plotshifts
if (plotshifts eq 1) then begin
  print,' ----- start crossalignments for shifts, takes long'
  xshifts=fltarr(nt)
  yshifts=fltarr(nt)
  sumxshifts=fltarr(nt)
  sumyshifts=fltarr(nt)
  for it=1,nt-1 do begin
    im1=imcube[*,*,it-1]
    im2=imcube[*,*,it]
    thisshift=findimshift_rr(im1,im2,/cropborders,filter=10)
    xshifts[it]=-thisshift[0]
    yshifts[it]=-thisshift[1]
    sumxshifts[it]=sumxshifts[it-1]+xshifts[it]
    sumyshifts[it]=sumyshifts[it-1]+yshifts[it]
  endfor

;; ; plot pairwis image shifts
  ;; plot,indgen(nt),xshifts,yrange=[-0.5,+1.5],ystyle=1
  ;; oplot,indgen(nt),yshifts,linestyle=2

  ; plot cumulative shifts
  window,/free
  ymin=min(sumxshifts)
  ymax=max(sumxshifts)
  if (abs(ymax-ymin) lt 0.01) then begin
    print,' ----- sumxshifts are alle near zero, no plot'
    STOP
  endif
  yrange=[ymin-0.1*(ymax-ymin),ymax+0.1*(ymax-ymin)]
  plot,indgen(nt),sumxshifts,$
    xrange=[0,nt],xstyle=1,yrange=yrange,ystyle=1,$
    xtitle='time step',ytitle='cumulative shifts  [px = 0.6 arcsec]',$
    charsize=2
  
  oplot,indgen(nt),sumyshifts,linestyle=2
STOP

endif


end

; =============== main for testing per IDLWAVE H-c ======================

;; cd,'/home/rutten/data/SDO/2014-06-14-small/center/level2'
;; cd,'/home/rutten/data/SDO/2014-06-14-small/target/level2'

;; cd,'/home/rutten/data/SDO/2019-11-11-transit/complete_track/center/level2'
;; cd,'/home/rutten/data/SDO/2019-11-11-transit/complete_track/target/level2'
cd,'/home/rutten/data/SDO/2019-11-11-transit/complete_notrack/center/level2'
;; cd,'/home/rutten/data/SDO/2019-11-11-transit/complete_notrack/target/level2'

wav='171'

sdo_viewlevel2,wav,/plotshifts

end
