; file: sdo_printtranges.pro
; init: May 21 2020  Rob Rutten  Deil
; last: May 28 2020  Rob Rutten  Deil

;+
pro sdo_printtranges
 ; print t_obs in UT for first and last file each SDO sequence in current dir
 ; run in level1 or in my-style "level2" dir (same results)
 ; files maybe level1 SDO-compressed or level2 .fz compressed by me
 ; May 21 2020 Rob Rutten
;-

; get current dir path; \ flag spaces in path if present (bloody Mac?)
; https://groups.google.com/forum/#!topic/comp.lang.idl-pvwave/Lo10H5XtN80
cd,current=thisdir
thisdir=strjoin(strsplit(thisdir,' ',/extract),'\ ') 

; define SDO "channel" search strings
if (strmatch(thisdir,'*level1*')) then $
  sdowavs=['.94.','.131.','.171.','.193.','.211.','.304.','.335.',$
           '.1600.','.1700.','.4500.',$
           '.magnetogram','.continuum.','.Dopplergram.'] 
if (strmatch(thisdir,'*level2*')) then $
  sdowavs=['_0094','_0131','_0171','_0193','_0211','_0304','_0335',$
           '_1600','_1700','_4500','_mag','_cont','_dop'] 

; do the job
nwavs=n_elements(sdowavs)
for iwav=0,nwavs-1 do begin
  files=findfile(thisdir+'/*'+sdowavs[iwav]+'*.fits*')
  nfiles=n_elements(files)
  if (files[0] ne '') then print,'  '+sdowavs[iwav]+$
    ' tfirst '+sdo_gettobsfile(files[0])+$
    ' tlast '+sdo_gettobsfile(files[nfiles-1])
endfor

end

; =============== main for testing per IDLWAVE H-c ======================

cd,'/home/rutten/data/SDO/test/center/level1'
;; cd,'/home/rutten/data/SDO/test/center/level2' ; same as level1 of course

sdo_printtranges

end
