; file: sdo_printkeywords.pro 
; init: Dec 23 2016  Rob Rutten  Deil
; last: Dec 23 2016  Rob Rutten  Deil

;+

pro sdo_printkeywords,dirname,filename,keywords

 ; PURPOSE:
 ;    prints values of SDO image-file keywords
 ; CALL:
 ;    see above
 ; INPUTS:
 ;    dirname, filename, [array keyword names] (in caps): all strings   
 ; HISTORY:
 ;    Dec 23 2016 RR: start = quickie for im_patch problem  
;-

; default keyword selection
if (keywords eq 0) then keywords=['T_OBS',$
  'NAXIS1','NAXIS2',$
  'X0_MP','Y0_MP',$
  'CRPIX1','CRPIX2',$
  'CDELT1','CDELT2',$
  'CROTA2',$
  'CRVAL1','CRVAL2',$
  'XCEN','YCEN']

values=sdo_getkeywords(dirname,filename,keywords)
nkeywords=n_elements(keywords)
for ikey=0,nkeywords-1 do $
  print,' ===== '+keywords[ikey]+' = ',values[ikey]

end

; =========== test per Hyper-C ==================

dirname='/home/rutten/data/SDO/2014-06-14-benchmark/trial11'
filename='center/level1/aia.lev1_euv_12s.2014-06-14T070001Z.304.image.fits'
keywords=['DATE_OBS','CRPIX1','CRPIX2']
keywords=0
sdo_printkeywords,dirname,filename,keywords

end
