; file: sdo_orderssw.pro
; init: Aug 17 2016  Rob Rutten  Deil = copy of sdo_orderjsoc,pro
; last: Aug 18 2016  Rob Rutten  Deil

;+

pro sdo_orderssw,datetimestart,duration,xsol,ysol,email,$  
  xsize=xsize,ysize=ysize,wavs=wavs,cadence=cadence,notrack=notrack,$
  requestident

 ; NAME:
 ;   sdo_orderssw
 ;
 ; PURPOSE:
 ;   order SDO cutouts with ssw_cutout_service.pro
 ;   
 ; INPUTS:
 ;   datetimestart (UTC): fixed-format string, e.g., '2015.09.27_07:00'
 ;   duration: integer, minutes, e.g., 60  (no quotes)
 ;   xsol, ysol: solar (X,Y) in arcsec of desired cutout center at start
 ;   email: requester's 
 ;
 ; OPTIONAL KEYWORD INPUTS:
 ;   xsize, ysize: cutout field of view in arcsec (default: 150x150 = SST)
 ;   wavs: desired SDO channels in 1D string array
 ;     (default: AIA all EUV and UV)
 ;   cadence: string, e.g. '5m'
 ;       default = 'fast' = fastest each: EUV 12s, UV 24s, HMI 45s 
 ;   notrack=1/0: switch off cutout tracking, default 0 = do track rotation 
 ;
 ; OUTPUTS
 ;   requestident: string with request identifier or 'oops-none'
 ;   
 ; EXAMPLE:
 ;   below program end below
 ;  
 ; RESTRICTIONS:
 ;   requires IDL 6.4 or later
 ;
 ; HISTORY:
 ;   Aug 18 2016 RR: start = copy of sdo_orderjsoc.pro
;-

; answer no-parameter query
if (n_params() lt 6) then begin
  sp,sdo_orderwws
  return
endif

; default keywords
if (n_elements(xsize) eq 0) then xsize=150.  ;RR good for SST
if (n_elements(ysize) eq 0) then ysize=150.
if (n_elements(wavs) eq 0) then $
  wavs=['94','131','171','193','211','304','335','1600','1700']
if (n_elements(cadence) eq 0) then cadence='fast'
if (n_elements(notrack) eq 0) then notrack=0

; define endtime
starttai=anytim2tai(datetimestart)
stoptai=starttai+fix(duration*60.)
datetimestop=anytim2utc(stoptai,/ccsds) 
strput,datetimestart,'-',4
strput,datetimestart,'-',7
strput,datetimestart,' ',10
strput,datetimestop,'-',4
strput,datetimestop,'-',7
strput,datetimestop,' ',10

; cadence and max_frames (assume EUV cadence)
if (cadence ne 'fast') then $
  if (strpos(cadence,'s') gt 0 and fix(cadence) lt 12) then begin
  cadence='fast'
  print,' ===== sdo_orderjsoc: cadence increased to minimum value'
endif
if (cadence eq 'fast') then maxcadence=12. else begin
  if (strpos(cadence,'s') gt 0) then maxcadence=fix(cadence)
  if (strpos(cadence,'m') gt 0) then maxcadence=fix(cadence*60.)
  if (strpos(cadence,'h') gt 0) then maxcadence=fix(cadence*3600.)
endelse 
max_frames=float(duration)*60./maxcadence+1

;; ; convert [xsol,ysol] to heliographic [long,lat]
;; ;RR use xcen,ycen option instead of ref_helio in SDO guide
;; arcsec2helio,xsol,ysol,lat,long
;; ref_helio=ssw_helio2string([lat,long])

; now order
queryout='oops-none' ; initialize
ssw_cutout_service,datetimestart,datetimestop,cgiquery,queryout,$
  xcen=xsol,ycen=ysol,ref_time=datetimestart,$
  fovx=xsize,fovy=ysize,waves=wavs,max_frames=max_frames,$
  instrument='AIA',rice=1,notrack=notrack,email=email ;;; ,/nosubmit

; distill request identifier from queryout
if (queryout[0] ne 'oops-none') then begin
  slashpos=strsplit(queryout[0],'/')
  nslash=n_elements(slashpos)
  requestident=strmid(queryout[0],slashpos[nslash-1])
endif else requestident=queryout

; print requestident to check 
print,' ======= sdo_orderssw request ident = ',requestident

;RR if answer stays "oops-none" get requestident instead from
;   http://www.lmsal.com/solarsoft/ssw_service/queue/requested/
; how to?

end

; ============== test per Hyper-C =====================

sdo_orderssw,'2014.06.14_05:00',7,90,90,'robenrietjerutten@gmail.com',$
  xsize=150,ysize=150,wavs=['304,171,1600'],$
  requestident

print,' ======== queryout = ',requestident

end

