; file: sdo_maketargetmovie.pro = IDL main
; init: Jan 23 2016  Rob Rutten  Deil
; last: Apr  8 2017  Rob Rutten  Deil
; note: as sdo_makereconnectionlocator.pro but 304 and 171, no 1700 or mult

;+
pro sdo_maketargetmovie,$
    cubesdir=cubesdir,moviedir=moviedir,$
    xrange=xrange,yrange=yrange,trange=trange,verbose=verbose

 ; make a 4-panel overview movie
 ; CALL:
 ;   see above
 ; INPUTS:
 ;   in ./cubes: aia1600.fits, aia304.fits, aia171.fits, hmimag.fits
 ; OPTIONAL INPUTS:
 ;   cubesdir: with fitscubes, default ./target/cubes
 ;   moviedir: where the movie should go (default ./target/mpegs)
 ;   xrange=xrange,yrange=yrange,trange=trange (defaults full range)
 ;     hint: use trange=[0,3] for fast check on field-of-view selection
 ;   verbose=1/0: more/less printout 
 ; OUTPUTS:
 ;   4psdotarget.mpg in moviedir
 ; HISTORY:
 ;   Jan 23 2016 RR: variant of sdo_makereconnectionlocator.pro
 ;   Apr  7 2016 RR: moviedir, cubesdir
 ;   Apr  5 2017 RR: 1700 replaced by 171
;-

; keyword defaults
if (n_elements(cubesdir) eq 0) then cubesdir='./target/cubes'
if (n_elements(moviedir) eq 0) then moviedir='./target/mpegs'
if (n_elements(xrange) eq 0) then xrange=[0,-1]
if (n_elements(yrange) eq 0) then yrange=[0,-1]
if (n_elements(trange) eq 0) then trange=[0,-1]
if (n_elements(verbose) eq 0) then verbose=0

; print warning
print,' ===== make_targetmovie starts but takes long'

; make moviedir if not yet existing 
spawn,'mkdir -p '+moviedir

;; ; define max and min per cube
;; mmmag=minmaxcubefile(cubesdir+'/hmimag.fits')
;; mm1600=minmaxcubefile(cubesdir+'/aia1600.fits')
;; mm304=minmaxcubefile(cubesdir+'/aia304.fits')
;; mm171=minmaxcubefile(cubesdir+'/aia171.fits')

; make 4-panel movie
cubefiles=[cubesdir+'/hmimag.fits',cubesdir+'/aia1600.fits',$
  cubesdir+'/aia304.fits',cubesdir+'/aia171.fits']
moviefile=moviedir+'/4psdotarget.mpg'
make4panelmovie,cubefiles,moviefile,$
  xrange=xrange,yrange=yrange,trange=trange,$   %RR ??? fix size to 200?
  /cutxga,$ ; /sharpen,$
  bytscale=[4,2,2,2],$  
  cutmin=[-50,0,0,0],cutmax=[-50,0,0,0],$ ;RR mag only half amplitude 
  wrappercent=[0,1000,0,0],$   ;RR 1600 wrap at 10*mean
  wraprms=[0,0,5,5],$ ;RR EUV wrap at mean+X*rms
  /channelident,/datetime,/clock,/location,/sundisk,$
  verbose=verbose

; show movie
if (verbose ne 0) then spawn,'play '+moviefile

end

; ====================== test per Hyper-C ===============================

datadir='/home/rutten/data/SDO/2014-06-14-small/target'
cubesdir=datadir+'/cubes'
moviedir=datadir+'/mpegs'

sdo_maketargetmovie,cubesdir=cubesdir,moviedir=moviedir

spawn,'play '+datadir+'/mpegs/4psdotarget.mpg'

end
