; file: sdo_maketargetfitscubes.pro
; init: Mar 30 2017  Rob Rutten  Deil
; last: Jul 19 2021  Rob Rutten  Deil

;+
pro sdo_maketargetfitscubes,targetdir=targetdir,refwav=refwav,$
  sdoprep=sdoprep,notrack=notrack,diffdesolrot=diffdesolrot,$
  nocrossalign=nocrossalign,driftsdir=driftsdir,border=border,$
  clipmin=clipmin,clipmax=clipmax,no_intscale=no_intscale,$
  addfires=addfires,mpegs=mpegs,targetmovie=targetmovie,moviedir=moviedir,$
  nopack=nopack

 ; produce SDO target fitscubes from level2, perhaps with new parameters
 ;   
 ; OPTIONAL KEYWORD INPUTS:
 ;   targetdir: default 'target/', must have sdo-prepped level2 subdir 
 ;   refwav: reference channel for SDO synchronization, default '171'  
 ;   sdoprep = 1/0 do aia_prep level1 > level2 ("level 1.5", default 0)
 ;   notrack = 1/0: JSOC did not track rotation in im_patch cutting out
 ;   diffdesolrot = 1/0: differentially derotate target
 ;   nocrossalign = 1/0: default 0 = co-align target cubes using driftsplines
 ;   driftsdir: default 'driftscenter/', spline alignment data
 ;   border: value to clip borders, default 15
 ;   clipmin: see sdo_intscale.pro; default=-1
 ;   clipmax: see sdo_intscale,ro; default=0
 ;   no_intscale = 1/0: do not intscale target AIA and HMIcont intensities
 ;   addfires = 1/0: add 304x131 "fires" fitscubes (see LAR-1), default 0
 ;     (needs cutlevels from center processing, or run sdo_alignaia_rr)
 ;   mpegs: option to produce an mpeg movie from each fitscube
 ;   targetmovie: option to make a 4-panel overview movie 
 ;   moviedir: default targetdir+./mpegs'
 ;   nopack=1: don't fpack level2 files when done (slow, don't if repeat) 
 ;
 ; OUTPUTS:
 ;   assembled SDO fitcubes in target/cubes (rename _align or _noalign?)
 ;   
 ; OPTIONAL OUTPUTS:
 ;   movies
 ;   
 ; HISTORY:
 ;   Mar 30 2017 RR: start
 ;   Apr 18 2020 RR: crossalign, border,  nopack
 ;   Jul  5 2020 RR: diffdesolrot
 ;   Nov 16 2020 RR: addfires
;-

; answer wrong-parameter query 
if (n_params(0) gt 0) then begin
  sp,sdo_maketargetfitscubes
  return 
endif

; set wall-clock timer (seconds)
timestarttarget=systime(1) 

; defaults for keywords
if (n_elements(targetdir) eq 0) then targetdir='target/'
if (n_elements(refwav) eq 0) then refwav='171'
if (n_elements(notrack) eq 0) then notrack=0
if (n_elements(diffdesolrot) eq 0) then diffdesolrot=0
if (n_elements(nocrossalign) eq 0) then nocrossalign=0
if (n_elements(driftsdir) eq 0) then driftsdir='driftscenter/'
if (n_elements(border) eq 0) then border=15
if (n_elements(sdoprep) eq 0) then sdoprep=0
if (n_elements(clipmin) eq 0) then clipmin=-1   ; special
if (n_elements(clipmax) eq 0) then clipmax=-2   ; special
if (n_elements(no_intscale) eq 0) then no_intscale=0
if (n_elements(addfires) eq 0) then addfires=0
if (n_elements(mpegs) eq 0) then mpegs=0
if (n_elements(targetmovie) eq 0) then targetmovie=0
if (n_elements(moviedir) eq 0) then moviedir=targetdir+'/mpegs/'
if (n_elements(nopack) eq 0) then nopack=0

; process /target data using crossalignment driftsdir data 
sdo_allimages2fitscubes,targetdir,refwav=refwav,sdoprep=sdoprep,$
  notrack=notrack,diffdesolrot=diffdesolrot,$
  nocrossalign=nocrossalign,driftsdir=driftsdir,$
  clipmin=clipmin,clipmax=clipmax,no_intscale=no_intscale,$
  mpegs=mpegs,targetmovie=targetmovie,moviedir=moviedir,nopack=nopack,$
  border=border

; optionally add "fire detector" 304x131 fitscubes (LAR-1 "campfires")
; NB: requires same intscale clip settings center/cubesxal and target/cubes 
if (addfires eq 1) then begin
  readcol,driftsdir+'/fireclips.dat',aia3013cut,aia3013color
  aia3013cut=aia3013cut[0]      ; readcol problem for non-array writes
  aia3013color=aia3013color[0]
  sdo_addfires,aia3013cut,aia3013color,cubesdir=targetdir+'/cubes'
endif

; add labels in the cubes dir
if (nocrossalign eq 0) then $
  spawn,'touch '+targetdir+'/cubes/00-NB_cubes_aligned' $
else spawn,'touch '+targetdir+'/cubes/00-NB_cubes_NOT_aligned'
spawn,'touch '+targetdir+'/cubes/00-NB_not_EUV_corrrected'
if (diffdesolrot ne 0) then $
  spawn,'touch '+targetdir+'/cubes/00-NB_cubes-diffdesolrotated'

; print elapsed time
timedone=systime(1)
timelaps=ntostr((timedone-timestarttarget)/60.,format='(F11.1)')
print,' ===== sdo_maketargetfitscubes took '+timelaps+' minutes'

if (nocrossalign eq 1) then print,' @@@@@ rename dir cubes to cubes_noalign'

end


; =============== main for testing per IDLWAVE H-c ======================

cd,'/home/rutten/data/SDO/2014-06-14-small'
;; cd,'/media/rutten/RRDATA/alldata/SDO/2019-11-11-transit/complete_notrack_1700'
;; cd,'~/data/SDO/2019-11-11-transit/complete_notrack_1700'

;; border=40 ;RR Jun 10 2020 needed for Mercury full transit - no longer?

sdo_maketargetfitscubes
  ;; /nocrossalign
  ;; border=border,/nopack 
   ;;   sdoprep=1,$
  ;;   clipmin=0,clipmax=0;; ,/mpegs,/targetmovie

end
