; file: sdo_makeeblocmovie.pro = IDL main
; init: Nov 10 2014 Rob Rutten  Pune 
; last: Sep  2 2020  Rob Rutten  Deil
; note: Jan  2 2021 replaced by sdo_addebfafs.pro + sdo_makeebfafmovie.pro

;+
pro sdo_makeeblocmovie,$
    xrange=xrange,yrange=yrange,trange=trange,verbose=verbose

 ; make an EB check movie for Rob Rutten EB talks
 ; INPUTS:
 ;   at least in ./cubes: aia1600.fits, aia1700.fits, hmimag.fits
 ; OPTIONAL INPUTS:
 ;   there may be more cubes in dir cubes
 ;   xrange=xrange,yrange=yrange,trange=trange (defaults full range)
 ;     hint: use trange=[0,3] for fast check on field-of-view selection
 ;   verbose=1/0:more/less printout 
 ; OUTPUTS:
 ;   mpegs/4panel-EBs.mpg @ 12s cadence  
 ; RESTRICTIONS:
 ;   selected size must fit 4-panel mpeg making  
 ; HISTORY:
 ;   Nov 10 2014 RR: start for Pune talk
 ;   Jan 19 2016 RR: changed 1700x1600 cubefile name and dir
;-

; keyword defaults
if (n_elements(xrange) eq 0) then xrange=[0,-1]
if (n_elements(yrange) eq 0) then yrange=[0,-1]
if (n_elements(trange) eq 0) then trange=[0,-1]
if (n_elements(verbose) eq 0) then verbose=0

;; ; make othercubes dir
;; spawn,'mkdir -p cubes/othercubes'

; make 1600x1700 movie
a1600=readfits('cubes/aia1600.fits',head1600)
a1700=readfits('cubes/aia1700.fits')
a1600=float(a1600) ; small range,why?  always?
a1700=float(a1700)
a1600=a1600/avg(a1600)
a1700=a1700/avg(a1700)

multcube=fix(a1600*a1700*100)  ;RR minmax = -73 5406
multhead=head1600
sxaddpar,multhead,'channel','AIA 1700x1600'
;; writefits,'cubes/othercubes/aiamult.fits',multcube,multhead
writefits,'cubes/aia1600x1700.fits',multcube,multhead

; double cadence (e.g. if there was no 304 as reference cube, to 12s)
cadence1600=fxpar(head1600,'cadence')
if (cadence1600 gt 15) then begin
  doallfiles,'cubes/','cubes/','.fits','-double.fits',$
    'reformcubefile',cadence_in=24,cadence_out=12
  spawn,'cd cubes; chfil -double ; back'
endif

; make 4-panel movie
cubefiles=['cubes/hmimag.fits','cubes/aia1700.fits','cubes/aia1600.fits',$
;;           'cubes/othercubes/aiaEBlocator.fits']
           'cubes/aia1600x1700.fits']
spawn,'mkdir -p mpegs'
spawn,'mkdir -p `echo $cwd | sed -e "s|.*data/|/home/rutten/rr/wrk/|g"`/mpegs'
moviefile='mpegs/4panel-EBs.mpg'
make4panelmovie,cubefiles,moviefile,$
  xrange=xrange,yrange=yrange,trange=trange,$   %RR ??? fix size to 200?
  /cutxga,$ ; /sharpen,$
  bytscale=[4,2,2,2],$  ;RR FIXED SCALES !!!!
  cutmin=[-7500,0,0,0],cutmax=[7500,0,0,0],$
  wrappercent=[0,800,1200,8000],$   ;RR FIXED SCALES !!!! 
  /channelident,/datetime,/clock,/location,/sundisk,$
  verbose=verbose

; show movie
spawn,'play '+moviefile

;; ; shift to wrk dir (always available)
;; spawn,'mv mpegs/*  `echo $cwd | sed -e "s|.*data/|/home/rutten/rr/wrk/|g"`/mpegs/.'
;; spawn,'rmdir mpegs'

end

; ============================ run per hyper-C

;; cd,'/home/rutten/data/SolO/2020-05-30-first/sdo/target'
;; sdo_makeeblocmovie
;; showex,'cubes/aia1600.fits','cubes/aia1600x1700.fits'

;; cd,'/media/rutten/RRHOME/alldata/SDO/2013-01-11-crackling/cubes/othercubes'
;; showex,'aiaEBlocator.fits','aiamult.fits'
;
cd,'/media/rutten/RRHOME/alldata/SDO/2013-01-11-crackling'
sdo_makeeblocmovie


end
