; file: sdo_gettobsfile.pro
; init: May 20 2020  Rob Rutten  Deil
; last: Jun 22 2020  Rob Rutten  Deil

;+
function sdo_gettobsfile,file
 ; return t_obs from header SDO file but in UT when TAI (HMI files)
 ;   may be a level1 SDO-compressed file or a level2 fits or fits.fz one
 ; May 20 2020 Rob Rutten
;-

; answer no-parameter query 
if (n_params(0) lt 1) then begin
  sp,sdo_gettobsfile
  return,-1
endif

; read file; if file rice-compressed (.fz) first uncompress
  dummy=cgrootname(file,extension=ext)  ;RR also needs coyotelib
  if (ext eq 'fz') then begin
    fileonly=file_basename(file,'.fz')
    tmpfile='/tmp/'+fileonly
    spawn,'cp '+file+' '+tmpfile+'.fz'
; if no funpack then also no .fz present
    spawn,'funpack -D '+tmpfile+''
    read_sdo,tmpfile,indexim,/nodata
    spawn,'rm -f '+tmpfile+'*'
  endif else read_sdo,file,indexim,/nodata

; get t_obs and convert to UT if TAI
  tobs=indexim.t_obs
  tobs=anytim2utc(tobs,/ccsds)  ; when TAI convert to UT (-37s since 2017)
  
return,tobs
end


; =============== main for testing per IDLWAVE H-c ======================

;; file='/home/rutten/data/SDO/test/center/level2/AIA20190616_090052_1700.fits.fz'

;; file='/home/rutten/data/SDO/test/center/level1/aia.lev1_uv_24s.2019-06-16T090035Z.1700.image.fits'

file='/home/rutten/data/SDO/test/center/level1/hmi.M_45s.20190620_090000_TAI.2.magnetogram.fits'

print,sdo_gettobsfile(file)

end
