; file: sdo_getsumsplineshift.pro
; init: Feb 23 2016  Rob Rutten  Deil
; last: Mar  2 2022  Rob Rutten  Deil

;+

function sdo_getsumsplineshift,wav,tai,driftsdir,$
  euvanchor=euvanchor

 ; NAME:
 ;   sdo_getsumplineshift   
 ;   
 ; PURPOSE:
 ;   sum SDO shifts appropriately to get the one for this wav
 ;   
 ; INPUTS:
 ;   wav = string, e.g.'304'
 ;   tai = time in TAI seconds
 ;   driftsdir = directory where the spline.dat files are (driftscenter)
 ;   
 ; OUTPUTS:
 ;   2-elem vector with shifts x,y to HMI
 ;   
 ; OPTIONAL KEYWORD INPUTS:
 ;   euvanchor = anchor EUV in reversed order, default ['304','mag']
 ;
 ; HISTORY:
 ;    Feb 23 2016 RR: start   
 ;    May  7 2016 RR: better EUV pairs
 ;    Feb 15 2020 RR: euvanchor
 ;    May 31 2020 RR: default euvanchor from 1600 to 1700
 ;    Jun 11 2020 RR: default euvanchor to mag
 ;    Mar  2 2022 RR: 131 and 94 changed
;-

; answer no-parameter query 
if (n_params(0) lt 2) then begin
  sp,sdo_getsumsplineshift
  return,-1
endif

; default keyword values
if (n_elements(euvanchor) eq 0) then euvanchor=['304','mag'] ; Jun 11 2020 

; RR_channel definitions (counting fingers)
wavnames=['94','131','171','193','211','304','335',$
;;;;        1    2     3     4     5     6     7
          '1600','1700','4500','mag','cont','dop'] 
;;;;         8      9     10     11    12    13

; get all pertinent shifts
sum=-1E5

; DEFAULT from Jun 11 2020: 304 on mag as EUV anchor
; Mar  2 2022: now 94 > 335, better; test data/NISP/2012-08-15-quiet superb
; NB: selected pairs must be ordered in sdo_writeallpairsplines.pro
if (euvanchor[1] eq 'mag' and euvanchor[0] eq '304') then begin
  s611=sdo_getonesplineshift(tai,611,driftsdir) ;  304 > mag ; anchor
  s911=sdo_getonesplineshift(tai,911,driftsdir) ; 1700 > mag   ; for check
  s89=sdo_getonesplineshift(tai,89,driftsdir)   ; 1600 > 1700  
  s56=sdo_getonesplineshift(tai,56,driftsdir)   ;  211 >  304
  s36=sdo_getonesplineshift(tai,36,driftsdir)   ;  171 >  304
  s43=sdo_getonesplineshift(tai,43,driftsdir)   ;  193 >  171
  s75=sdo_getonesplineshift(tai,75,driftsdir)   ;  335 >  211
  s17=sdo_getonesplineshift(tai,17,driftsdir)   ;   94 >  335
  s27=sdo_getonesplineshift(tai,27,driftsdir)   ;  131 >  335
; wavs long to short  
  if (wav eq '1700') then sum=s911  ; 1700 on mag: UV anchor on HMI
  if (wav eq '1600') then sum=s911+s89   ; 1600 on 1700, no further use
  if (wav eq '304')  then sum=s611      ; 304 on mag: EUV anchor on HMI
  if (wav eq '171')  then sum=s611+s36   ; 171 on 304
  if (wav eq '211')  then sum=s611+s56   ; 211 on 304
  if (wav eq '335')  then sum=s611+s56+s75  ; 335 on 211
  if (wav eq '193')  then sum=s611+s36+s43  ; 193 on 171
  if (wav eq '131')  then sum=s611+s56+s75+s27  ; 131 on 335
  if (wav eq '94')   then sum=s611+s56+s75+s17  ;  94 on 335
endif

; default from May 31 2020 until Jun 11 2020 
if (euvanchor[1] eq '1700' and euvanchor[0] eq '304') then begin
  s911=sdo_getonesplineshift(tai,911,driftsdir) ; 1700 > mag
  s89=sdo_getonesplineshift(tai,89,driftsdir)   ; 1600 > 1700
;;  s68=sdo_getonesplineshift(tai,68,driftsdir)   ;  304 > 1600 ; no longer
  s69=sdo_getonesplineshift(tai,69,driftsdir)   ;  304 > 1700
  s56=sdo_getonesplineshift(tai,56,driftsdir)   ;  211 >  304
  s36=sdo_getonesplineshift(tai,36,driftsdir)   ;  171 >  304
  s15=sdo_getonesplineshift(tai,15,driftsdir)   ;   94 >  211
  s75=sdo_getonesplineshift(tai,75,driftsdir)   ;  335 >  211
  s43=sdo_getonesplineshift(tai,43,driftsdir)   ;  193 >  171
  s27=sdo_getonesplineshift(tai,27,driftsdir)   ;  131 >  335
  if (wav eq '1700') then sum=s911  ; 1700 on mag
  if (wav eq '1600') then sum=s911+s89   ; 1600 on 1700, no further use
  if (wav eq '304')  then sum=s911+s69   ; 304 on 1700
  if (wav eq '171')  then sum=s911+s69+s36   ; 171 on 304
  if (wav eq '211')  then sum=s911+s69+s56   ; 211 on 304
  if (wav eq '335')  then sum=s911+s69+s56+s75  ; 335 on 211
  if (wav eq '193')  then sum=s911+s69+s36+s43  ; 193 on 171
  if (wav eq '94')   then sum=s911+s69+s56+s15  ;  94 on 211 
  if (wav eq '131')  then sum=s911+s69+s56+s75+s27  ; 131 on 335
endif

; default until May 31 2020 
if (euvanchor[1] eq '1600' and euvanchor[0] eq '304') then begin
  s911=sdo_getonesplineshift(tai,911,driftsdir) ; 1700 > mag
  s89=sdo_getonesplineshift(tai,89,driftsdir)   ; 1600 > 1700
  s68=sdo_getonesplineshift(tai,68,driftsdir)   ;  304 > 1600 
;;  s69=sdo_getonesplineshift(tai,69,driftsdir)   ;  304 > 1700 ; later
  s56=sdo_getonesplineshift(tai,56,driftsdir)   ;  211 >  304
  s36=sdo_getonesplineshift(tai,36,driftsdir)   ;  171 >  304
  s15=sdo_getonesplineshift(tai,15,driftsdir)   ;   94 >  211
  s75=sdo_getonesplineshift(tai,75,driftsdir)   ;  335 >  211
  s43=sdo_getonesplineshift(tai,43,driftsdir)   ;  193 >  171
  s27=sdo_getonesplineshift(tai,27,driftsdir)   ;  131 >  335
  if (wav eq '1700') then sum=s911  ; 1700 on mag
  if (wav eq '1600') then sum=s911+s89   ; 1600 on 1700
  if (wav eq '304')  then sum=s911+s89+s68   ; 304 on 1600
  if (wav eq '171')  then sum=s911+s89+s68+s36   ; 171 on 304
  if (wav eq '211')  then sum=s911+s89+s68+s56   ; 211 on 304
  if (wav eq '335')  then sum=s911+s89+s68+s56+s75  ; 335 on 211
  if (wav eq '193')  then sum=s911+s89+s68+s36+s43  ; 193 on 171
  if (wav eq '94')   then sum=s911+s89+s68+s56+s15  ;  94 on 211 
  if (wav eq '131')  then sum=s911+s89+s68+s56+s75+s27  ; 131 on 335
endif

;; ; trial uv2euv pair Feb 15 2020
;; if (euvanchor[1] eq '1700' and euvanchor[0] eq '131') then begin
;;   s911=sdo_getonesplineshift(tai,911,driftsdir) ; 1700 > mag
;;   s89=sdo_getonesplineshift(tai,89,driftsdir)   ; 1600 > 1700
;;   s29=sdo_getonesplineshift(tai,29,driftsdir)   ;  131 > 1700 
;;   s62=sdo_getonesplineshift(tai,62,driftsdir)   ;  304 > 131
;;   s56=sdo_getonesplineshift(tai,56,driftsdir)   ;  211 >  304
;;   s36=sdo_getonesplineshift(tai,36,driftsdir)   ;  171 >  304
;;   s15=sdo_getonesplineshift(tai,15,driftsdir)   ;   94 >  211
;;   s75=sdo_getonesplineshift(tai,75,driftsdir)   ;  335 >  211
;;   s43=sdo_getonesplineshift(tai,43,driftsdir)   ;  193 >  171
;;   if (wav eq '1700') then sum=s911
;;   if (wav eq '1600') then sum=s911+s89
;;   if (wav eq '131')  then sum=s911+s89+s29
;;   if (wav eq '304')  then sum=s911+s89+s29+s62
;;   if (wav eq '171')  then sum=s911+s89+s29+s62+s36
;;   if (wav eq '211')  then sum=s911+s89+s29+s62+s56
;;   if (wav eq '335')  then sum=s911+s89+s29+s62+s56+s75
;;   if (wav eq '193')  then sum=s911+s89+s29+s62+s36+s43
;;   if (wav eq '94')   then sum=s911+s89+s29+s62+s56+s15
;; endif

; check
if (sum[0] eq -1E5) then begin
  print,', ###### ,sdo_getsumsplineshift abort, no wav = '+wav
  return,-1
endif

;; return,[0,0]  ; test
return,sum

end


; =============== main for testing per IDLWAVE H-c ======================

driftsdir='/home/rutten/data/SDO/2014-06-14-small/driftscenter'
datetime='2014-06-14 07:00'
tai=anytim2tai(datetime)

wav1='193'
shift1=sdo_getsumsplineshift(wav1,tai,driftsdir)
print,trim(shift1)

wav2='211'
shift2=sdo_getsumsplineshift(wav2,tai,driftsdir)
print,trim(shift2)
print,trim(shift1-shift2)

end
