; file: sdo_getssw.pro
; init: Aug 18 2016  Rob Rutten  Deil from sdo_getjsoc.pro
; last: Aug 18 2016  Rob Rutten  Deil

;+

pro sdo_getssw,requestident,level1dir

 ; NAME:
 ;   sdo_getssw
 ;   
 ; PURPOSE:
 ;   get ssw SDO order without opening emails or manual downloading
 ;   
 ; DESCRIPTION:
 ;   use requestident from sdo_orderssw.pro or from Sam Freeland email
 ;   
 ; CALL:
 ;   see above
 ;   
 ; INPUTS:
 ;   requestident: string request ident only (no url)
 ;   level1dir = directory where the FITS files will go 
 ; 
 ; OUTPUTS:
 ;   SDO "level1" FITS files in ssw format in level1dir
 ;   
 ; HISTORY:
 ;   Aug 18 2016: start following sdo_getjsoc.pro
;-

; answer no-parameter query 
if (n_params(0) lt 2) then begin
  print,'sdo_getjsoc,requestident,level1dir'
  return
endif

; get current dir path; \ flag spaces in path if present (bloody Mac?)
; https://groups.google.com/forum/#!topic/comp.lang.idl-pvwave/Lo10H5XtN80
cd,current=thisdir
thisdir=strjoin(strsplit(thisdir,' ',/extract),'\ ') 

; go to level1dir
cd,level1dir

; check whether ready
REPEATCHECK:
sock_list,'http://www.lmsal.com/solarsoft/ssw_service/queue/finished/'+requestident+'.html',readycheck
if (n_elements(readycheck) lt 20) then begin
  print,' ===== sdo_getssw: not ready yet; retry in 5 min'
  wait,300
  goto,REPEATCHECK
endif

; get data
ssw_service_get_data,requestident,/loud

; return to calling dir
cd,thisdir

end


; =============== main for testing per IDLWAVE H-c ======================

cd,'/home/rutten/data/SDO/2014-06-14-small/trygetssw'
sdo_orderssw,'2014.06.14_07:00',8,120,120,'robenrietjerutten@gmail.com',$
  xsize=150,ysize=150,wavs=['304,171,1600'],$
  requestident

print,' ===== requestident =',requestident

sdo_getssw,requestident,$
  '/home/rutten/data/SDO/2014-06-14-small/trygetssw'

end
