; file: sdo_getonesplineshift.pro
; init: Feb 23 2016  Rob Rutten  Deil
; last: Jan 15 2021  Rob Rutten  Deil

;+
function sdo_getonesplineshift,tai,wavpair,driftsdir

 ; get spline values for xshift and yshift from spline file pair
 ;   
 ; INPUTS:
 ;   tai = desired sample time in TAI (double)
 ;   wavpair: in RR_channel values, eg 911
 ;   driftsdir: dir where the spline.dat files are (usually 'driftscenter')
 ;
 ; OUTPUTS:
 ;   [shiftx,shifty] (apply negatively)   
 ;   
 ; HISTORY:
 ;   Feb 23 2016 RR: start 
 ;   Apr 19 2016 RR: spline IMSL > Vitas for the Mac-challenged   
;-

; answer no-parameter query 
if (n_params(0) lt 3) then begin
    sp,sdo_getonesplineshift
    return,-1
endif

; find filex
pairstring=ntostr(wavpair)
filex=findfile(driftsdir+'/splinx-'+pairstring+'.dat')

; check
if (filex eq '') then begin
;RR too much print output if not all SDO channels asked
;;  print,' ##### sdo_getonesplineshift finds no splinx file for '+pairstring
  return,-1
endif

; find filey
filey=findfile(driftsdir+'/spliny-'+pairstring+'.dat')

; check
if (filey eq '') then begin
;RR too much print output if not all SDO channels asked
;;  print,' ##### sdo_getonesplineshift finds no spliny file for '+pairstring
  return,-1
endif

; read the files ;RR Sep 22 2016 add [0] for list, from Gregal Vissers email 
readcol,filex[0],timearrx,ax,bx,cx,dx,format='D',/silent 
readcol,filey[0],timearry,ay,by,cy,dy,format='D',/silent

; evaluate both 
splinx=splinapp_get(tai,timearrx,ax,bx,cx,dx)
spliny=splinapp_get(tai,timearry,ay,by,cy,dy)

return,[splinx,spliny]
end


; =============== main for testing per IDLWAVE H-c ======================

driftsdir='/home/rutten/data/SDO/2014-06-14-small/driftscenter'
wavpair=911
datetime='2014-06-14 07:00'
tai=anytim2tai(datetime)

print,sdo_getonesplineshift(tai,wavpair,driftsdir) 

end
