; file: sdo_getkeywords.pro 
; init: Dec 23 2016  Rob Rutten  Deil
; last: Dec 25 2016  Rob Rutten  Deil

;+

function sdo_getkeywords,path,filename,keywords

 ; PURPOSE:
 ;    returns the values of specified keywords in one SDO image file
 ; CALL:
 ;    see above
 ; INPUTS:
 ;    path, filename, array [keyword names] (in caps): all strings   
 ; OUTPUTS:
 ;    string array with keyword values
 ; EXAMPLE:
 ;    xcen=double(sdo_getkeywords,path,filename,'XCEN')
 ; HISTORY:
 ;    Dec 23 2016 RR: start = quickie for im_patch problem  
;-

read_sdo,path+'/'+filename,index,nodata,/noshell
tags=tag_names(index)
ntags=n_elements(tags)
nkeywords=n_elements(keywords)
values=strarr(nkeywords)
for ikey=0,nkeywords-1 do begin
for itag=0,ntags-1 do $
  if (tags(itag) eq keywords[ikey]) then values[ikey]=string(index.(itag))
endfor
return,values
end

; =========== test/demo per Hyper-C ==================

path='/home/rutten/data/SDO/2014-06-14-benchmark/trial11'
filename='center/level1/aia.lev1_euv_12s.2014-06-14T070001Z.304.image.fits'
keywords=['DATE_OBS','CRPIX1','CRPIX2']

; get a list per single read, distill value 
values=sdo_getkeywords(path,filename,keywords)
crpix2=double(values[2])
crpix2=crpix2[0]
help,crpix2

; get one keyword value (but needs file reading for each such request)
xcen=double(sdo_getkeywords(path,filename,'XCEN'))
help,xcen[0]  ; fuck IDL

end
