; file: sdo_getjsoc.pro
; init: Apr  5 2016  Rob Rutten  Deil
; last: May 22 2020  Rob Rutten  Deil

;+

pro sdo_getjsoc,requestidents,level1dir

 ; NAME:
 ;   sdo_getjsoc
 ;   
 ; PURPOSE:
 ;   get JSOC orders without opening emails or manual downloading
 ;   
 ; DESCRIPTION:
 ;   use the order identifiers delivered by sdo_orderjsoc.pro 
 ;   
 ; INPUTS:
 ;   requestidents: string array with request idents
 ;   level1dir = directory where the FITS files will go 
 ; 
 ; OUTPUTS:
 ;   SDO "level1" FITS files in level1dir
 ;   
 ; RESTRICTIONS:
 ;   if a tarfile is not yet available a retry follows after 10 min
 ;   
 ; HISTORY:
 ;   Apr  5 2016 RR: start following suggestion Peter Young   
 ;   Apr 19 2016 RR: wget > curl for the Mac-challlenged
;-

; answer no-parameter query 
if (n_params(0) lt 2) then begin
  print,'sdo_getjsoc,requestidents,level1dir'
  sp,sdo_getjsoc
  return
endif

; get current dir path; \ flag spaces in path if present (bloody Mac?)
; https://groups.google.com/forum/#!topic/comp.lang.idl-pvwave/Lo10H5XtN80
cd,current=thisdir
thisdir=strjoin(strsplit(thisdir,' ',/extract),'\ ') 

; go to level1dir
cd,level1dir

nidents=n_elements(requestidents)
for iset=0,nidents-1 do begin

REPEATJSOC:
  sock_list,'http://jsoc.stanford.edu/cgi-bin/ajax/jsoc_fetch?op=exp_status&requestid='+requestidents[iset],page
  if (n_elements(page) eq 1) then begin
    print,' ===== sdo_getjsoc: ident '+requestidents[iset]+' invalid'
    print,'       wrong?  Likely JSOC not ready > automatic retry in 5 min'
    wait,300
    goto,REPEATJSOC
  endif
  tarstring=page[11]

; check we are in business
  check=strmid(tarstring,2,7)
  if (check ne 'tarfile') then begin
    print,' ##### sdo_getjsoc ABORT: start page[11] is not <tarstring>'
    return
  endif

; distill the tarfile site
  quotepos=strsplit(tarstring,'"')
  tarfile=strmid(tarstring,quotepos[3],quotepos[4]-quotepos[3]-1)
  tarlink='http://jsoc.stanford.edu'+tarfile

; get the tarfile with check on success, retry if no success
  for itry=0,5 do begin
;RR Gregal Vissers had no wget under MacOS at UiO, changed to curl
    ;; spawn,'wget -q '+tarlink+$
    ;; ' && echo "1" > wgetsuccess || echo "0"  > wgetsuccess'
    spawn,'curl -s '+tarlink+' -o temp.tar '+$
     ' && echo "1" > wgetsuccess || echo "0"  > wgetsuccess'
    readcol,'wgetsuccess',success,format='I',/silent 
    if (success eq 1) then break else begin
      print,' ##### wget/curl failure for tarlink '+tarlink+$
        ' > automatic retry' 
      wait,30
    endelse
  endfor

; untar
  spawn,'tar xf temp.tar'

; cleanup
  spawn,'rm -f *tar wgetsuccess JSOC_* index.*'
  
endfor

; back to calling dir
cd,thisdir

end


; =============== main for testing per IDLWAVE H-c ======================

requestidents=['JSOC_20200206_341']
sdo_getjsoc,requestidents,$
  '/home/rutten/data/SDO/testjsoc/level1'
; inspect

;; ; manual inspect
;; cd,'/home/rutten/data/SDO/testjsoc/level1'
;; read_sdo,'aia.lev1_uv_24s.2014-06-14T091105Z.1700.image.fits',index,image
;; sv,image


end
