; file: sdo_getdriftsplines.pro
; init: Feb 21 2016  Rob Rutten  Deil
; last: Jul  6 2020  Rob Rutten  Deil

;+

pro sdo_getdriftsplines,datadir,$ 
  sdoprep=sdoprep,trimbox=trimbox,notrack=notrack,euvanchor=euvanchor,$
  xalpair=xalpair,refwav=refwav,verbose=verbose
 
 ; produce SDO drift splines
 ;   wrapper calling programs to get data, prep, cross-correlate, spline
 ;   
 ; INPUTS:
 ;   datadir = string path center dir with subdirs level2, cubes 
 ;   
 ; OPTIONAL KEYWORD INPUTS:
 ;   sdoprep = 1/0: pass on down the line
 ;   trimbox = align only over selected subfield [xmin,ymin,xmax,ymax]
 ;   notrack = 1/0: JSOC did not track rotation in cutting out
 ;   euvanchor = anchor EUV in reversed order, default ['304','mag']
 ;   refwav: string defining reference SDO channel, default '171', 
 ;   verbose = 1/0: more/less screen output
 ;   
 ; OUTPUTS:
 ;   spline solution files and plots  
 ;
 ; KEYWORD OUTPUT:
 ;   xalpair for alignment check, defined in sdo_writeallpairsplines.pro
 ;
 ; HISTORY:
 ;   Feb 21 2016 RR: start
 ;   Feb  8 2020 RR: euvanchor
 ;   Feb 14 2020 RR: pass xalpair
;-

; answer no-parameter query 
if (n_params(0) lt 1) then begin
  sp,sdo_getdriftsplines
  return
endif

; defaults for keywords
if (n_elements(sdoprep) eq 0) then sdoprep=0
if (n_elements(refwav) eq 0) then refwav='171'
if (n_elements(notrack) eq 0) then notrack=0
if (n_elements(trimbox) eq 0) then trimbox=[-1,-1,-1,-1]
if (n_elements(euvanchor) eq 0) then euvanchor=['304','mag']
if (n_elements(verbose) eq 0) then verbose=0

; set wall-clock timer (seconds)
timestartgetdrift=systime(1) 

; print pacifier
if (verbose ne 0) then print,' ===== sdo_getdriftsplines started at UT = '+$
  anytim2utc(timestartgetdrift,/vms)

; make non-cross-aligned center cubes 
sdo_allimages2fitscubes,datadir,$
  notrack=notrack,$
  nocrossalign=1,$         ; no driftsplines yet, they come from these
  clipmin=-1,clipmax=-1,$  ; use standard values for nice grey scales
  no_intscale=0,$          ; always int_scale all AIAs in the center dir
;;  border=30,$              ; large center cutouts ; default 15 for SOLNET
  diffdesolrot=0,$  ; no diffdesolrot for center cubes (fast comparisons)
  refwav=refwav,sdoprep=sdoprep,verbose=verbose

; measure pair shifts and spline them
; defines xalpair in sdo_writeallpairspline.pro
sdo_writeallpairsplines,datadir,xalpair,$
  trimbox=trimbox,euvanchor=euvanchor,verbose=verbose

; print elapsed time
timedone=systime(1)
timelaps=ntostr((timedone-timestartgetdrift)/60.,format='(F11.1)')
if (verbose ne 0) then $
  print,' ===== sdo_getdriftsplines took '+timelaps+' min'

end


; =============== main for testing per IDLWAVE H-c ======================


datadir='/home/rutten/data/SDO/2014-06-14-small/center/'
;; datadir='/home/rutten/data/IRIS/2016-01-14-sainzdalda/sdo/center/'

sdo_getdriftsplines,datadir,/verbose

end
