; file: sdo_ebfafmovie.pro 
; init: Dec 30 2020  Rob Rutten from sdo_makeeblocmovie.pro
; last: Jan  2 2021  Rob Rutten  Deil

;+
pro sdo_ebfafmovie,mode=mode,$
  bytscale=bytscale,cutmin=cutmin,cutmax=cutmax,trange=trange,$
  quietbox=quietbox,wrappercent=wrappercent,wraprms=wraprms,$
  show=show,verbose=verbose

 ; make EB check movie for EB debunk talks, call from target/cubes
 ; after applying option addebfafs in pipeline programs
 ;
 ; INPUTS:
 ;   at least in calling dir: aia1600.fits, aia1700.fits, hmimag.fits
 ;   and the aia1617xxx.fits cube for desired mode(s) from sdo_addebfafs.pro
 ;
 ; OPTIONAL INPUTS:
 ;   mode = 1: ratio 
 ;          2: multiplication 
 ;          3: classic EB movie as used in 2014-1017 talks 
 ;          4: all 1-3
 ;   bytscale:   4-element vector options for bytscaling that movie panel
 ;     bytscale = 0 don't bytscale the data (should be bytes, not applicable)
 ;     bytscale = 1 use (min,max) of first image for whole movie
 ;     bytscale = 2 use (min,max) of the whole image sequence
 ;     bytscale = 3 bytscale every movie frame individually (not for mag, dop)
 ;     bytscale = 4 use cutmin and cutmax values for this movie
 ;     cutmin = 4-element vector with minimum value for bytscale=4
 ;       negative = - percentage fraction of min of the whole sequence
 ;       for mag and dop cutmin is set to -cutmax to maintain zero
 ;     cutmax = 4-element vector with maximum value for bytscale=4
 ;       negative = - percentage fraction of max of the whole sequence
 ;   quietbox = trimbox quiet area [xmin,ymin,xmax,ymax] for setting % rms 
 ;   wrappercent =  4-element vector wrap mean + (value/100)*mean
 ;   wraprms =  4-element vector wraparound at mean + value*rms
 ;   trange=trange (default full range): eg for quick check
 ;   show=1/0: showex result 
 ;   verbose=1/0: more/less printout
 ;
 ; OUTPUTS:
 ;   movie(s) in subdir mpegs (for me in wrk dir)
 ;
 ; NB:
 ;   classic had bytscale=[4,2,2,2], cutmin=[-7500,0,0,0],
 ;     cutmax=[7500,0,0,0], wrappercent=[0,800,1200,8000], here all default
 ;   Vissers 2019A&A...626A...4V: 5rms \sim wraprms=[0,5,5,10], here default 
 ;
 ; RESTRICTIONS:
 ;   field size must fit 4-panel mpeg making
 ;
 ; HISTORY:
 ;   Nov 10 2014 RR: start for Pune talk
 ;   Jan 19 2016 RR: changed 1700x1600 cubefile name and dir
 ;   Dec 30 2020 RR: mode, quietbox
;-

; keyword defaults
if (n_elements(mode) eq 0) then mode=1
if (n_elements(bytscale) eq 0) then bytscale=[4,2,2,2]
if (n_elements(cutmin) eq 0) then cutmin=[-7500,0,0,0]
if (n_elements(cutmax) eq 0) then cutmax=[7500,0,0,0]
if (n_elements(wrappercent) eq 0) then wrappercent=[0,800,1200,8000]
if (n_elements(wraprms) eq 0) then wraprms=[0,5,5,10]
if (n_elements(quietbox) eq 0) then quietbox=-1
if (n_elements(trange) eq 0) then trange=[0,-1]
if (n_elements(verbose) eq 0) then verbose=0
if (n_elements(show) eq 0) then show=0

; check that normal input files exist
if (not(file_test('aia1600.fits') and $
        file_test('aia1700.fits') and $
        file_test('hmimag.fits'))) then begin
  print,' ##### sdo_ebfafmovie abort: no file aia1600, aia1700, hmimag'
  return
endif

; make mpegs dir
spawn,'mkdir -p mpegs'

; goto loop over thismode when mode=4
thismode=mode
if (mode eq 4) then thismode=1

NEXTMODE:

; check that mode file exists
if ((thismode eq 1 and not(file_test('aia1617rat.fits'))) or $
    (thismode eq 2 and not(file_test('aia1617mul.fits'))) or $
    (thismode eq 3 and not(file_test('aia1617ebs.fits')))) then begin
  print,' ##### sdo_ebfafmovie abort: no file aia1617xxx.fits'
  return
endif

; ratio with wraprms
if (thismode eq 1) then begin
  moviefile='mpegs/4panel-1617rat.mpg'
  cubefiles=['hmimag.fits','aia1700.fits','aia1600.fits',$
             'aia1617rat.fits']
  make4panelmovie,cubefiles,moviefile,$
    xrange=xrange,yrange=yrange,trange=trange,$ 
    /cutxga,$                                       
    bytscale=bytscale,cutmin=cutmin,cutmax=cutmax,$
    quietbox=quietbox,wrappercent=[0,0,0,0],wraprms=wraprms,$
    /channelident,/datetime,/clock,/location,/sundisk,$
    verbose=verbose

endif

; multiplication with wraprms
if (thismode eq 2) then begin
  moviefile='mpegs/4panel-1617mul.mpg'                     ; multiplication
  cubefiles=['hmimag.fits','aia1700.fits','aia1600.fits',$
             'aia1617mul.fits']
  make4panelmovie,cubefiles,moviefile,$
    xrange=xrange,yrange=yrange,trange=trange,$ 
    /cutxga,$                                       
    bytscale=bytscale,cutmin=cutmin,cutmax=cutmax,$
    quietbox=quietbox,wrappercent=[0,0,0,0],wraprms=wraprms,$
    /channelident,/datetime,/clock,/location,/sundisk,$
    verbose=verbose
  wrappercent=[0,0,0,0]
endif

; classic = multiplication, no quietbox, fixed wrappercent
; shown in older talk displays of EP pubs 2014-2016
if (thismode eq 3) then begin
  moviefile='mpegs/4panel-ebs.mpg'  ; old have -EBs, don't overwrite those
  cubefiles=['hmimag.fits','aia1700.fits','aia1600.fits',$
             'aia1617ebs.fits']
  make4panelmovie,cubefiles,moviefile,$
    xrange=xrange,yrange=yrange,trange=trange,$ 
    /cutxga,$                                       
    bytscale=bytscale,cutmin=cutmin,cutmax=cutmax,$
    quietbox=-1,wrappercent=[0,800,1200,8000],wraprms=[0,0,0,0],$
    /channelident,/datetime,/clock,/location,/sundisk,$
    verbose=verbose
endif

; show movie
if (show ne 0) then spawn,'play '+moviefile

; repeat for other modes if mode=4
thismode=thismode+1
if (mode eq 4 and thismode lt 4) then goto,NEXTMODE

; if this is me: shift mpegs to wrk dir on laptop disk
spawn,'whoami > sdo_getdata_reqester'
readcol,'sdo_getdata_reqester',username,format='A',/silent
spawn,'rm -f sdo_getdata_reqester'
if (username eq 'rutten' or username eq 'rutte101') then begin
  spawn,'echo $cwd | sed -e "s|.*data/|/home/rutten/rr/wrk/|g" > path'
  spawn,'cat path | sed -e "s|/cubes||g" > path2'
  spawn,'cat path2 | sed -e "s|/target||g" > path3'
  spawn,'mkdir -p `cat path3`/mpegs'
  spawn,'mv mpegs/* `cat path3`/mpegs'
  spawn,'rm -rf mpegs path*'
endif

end

; ============================ run per hyper-C

;; cd,'/home/rutten/data/SolO/2020-05-30-first/sdo/target'
;; cd,'/media/rutten/RRHOME/alldata/SDO/2013-01-11-crackling' ; no target
;; cd,'/media/rutten/RRHOME/alldata/SST/2017-09-22-peb/target'
cd,'/media/rutten/RRHOME/alldata/SDO/2011-08-18-bello/sdo/target/cubes'

mode=4
trange=[0,40]
;; quietbox=[15,50,90,160]

sdo_ebfafmovie,mode=mode,$
  quietbox=quietbox,wrappercent=wrappercent,wraprms=wraprms,$
  trange=trange,verbose=verbose

end
