; file: sdo_allfitscubes2mpegs.pro
; init: Feb  6 2014  Rob Rutten  Deil
; last: Aug 19 2014  Rob Rutten  Deil

pro sdo_allfitscubes2mpegs,cubesdir,moviedir,$
  xrange=xrange,yrange=yrange,trange=trange,$
  rebin=rebin,cutxga=cutxga,sharpen=sharpen,$
  wraprms=wraprms,$
  clock=clock,datebanner=datebanner,jpeg=jpeg,verbose=verbose

;+
 ; NAME:
 ;   sdo_allfitscubes2mpegs
 ; PURPOSE:
 ;   convert all SDO fitscubes in cubesdir to mpeg movies
 ; CALL:
 ;   see fitscube2mpeg for the keywords   
 ; HISTORY:
 ;   Feb  6 2014 RR: start    
;-

; answer no-parameter query
if (n_params() lt 2) then begin
  print,'sdo_allfitscubes2mpegs,cubesdir,moviedir,$'
  print,'  xrange=xrange,yrange=yrange,trange=trange,$'
  print,'  rebin=rebin,cutxga=cutxga,sharpen=sharpen,$'
  print,'  wrapmrs=warpmrs,$'
  print,'  clock=clock,datebanner=datebanner,jpeg=jpeg,verbose=verbose]'
  return
endif

; set wall-clock timer (seconds)
timestart=systime(1)

; keyword defaults
if (n_elements(xrange) eq 0) then xrange=[0,-1]
if (n_elements(yrange) eq 0) then yrange=[0,-1]
if (n_elements(trange) eq 0) then trange=[0,-1]
if (n_elements(rebin) eq 0) then rebin=1
if (n_elements(cutxga eq 0)) then cutxga=0
if (n_elements(sharpen) eq 0) then sharpen=0
if (n_elements(wraprms) eq 0) then wraprms=0
if (n_elements(clock) eq 0) then clock=0
if (n_elements(datebanner eq 0)) then datebanner=0
if (n_elements(jpeg) eq 0) then jpeg=0
if (n_elements(verbose) eq 0) then verbose=0

; get list of cubefiles
cubefiles=findfile(cubesdir+'*.fits')
if (cubefiles[0] eq '') then message,' ##### no cubes found'
ncubes=n_elements(cubefiles)

; process each cube
for icube=0,ncubes-1 do begin

; set path and filename
  cubefile=cubefiles[icube]
  mpegfile=str_replace(cubefile,cubesdir,moviedir)  
  mpegfile=str_replace(mpegfile,'.fits','.mpg')

  if (verbose) then print,' --- start on '+cubefile+' => '+mpegfile

; distill diagname
  diagname=str_replace(mpegfile,moviedir,'SDO ')
  diagname=str_replace(diagname,'.mpg','')
  diagname=str_replace(diagname,'/','')

; set zeromid to 1 for mag and cont 
 zeromid=0
 if (strmatch(diagname,'*mag*') eq 1) then zeromid=1
 if (strmatch(diagname,'*dop*') eq 1) then zeromid=1

; wraprms the AIAs if requested
thiswraprms=0
if (wraprms ne 0) then $
   if (strmatch(diagname,'*aia*') eq 1) then thiswraprms=wraprms

; make the mpeg
  fitscube2mpeg,cubefile,mpegfile,$
    xrange=xrange,yrange=yrange,trange=trange,$
    rebin=rebin,cutxga=cutxga,sharpen=sharpen,$
    wraprms=thiswraprms,$
    zeromid=zeromid,clock=clock,datebanner=datebanner,$
    jpeg=jpeg,verbose=verbose

endfor

; print elapsed time
timedone=systime(1)
timelaps=ntostr((timedone-timestart)/3600.,format='(F10.2)')
print,' === sdo_allfitscubes2mpegs took '+timelaps+' hours'

end

; ================= main = test for IDLWAVE H-c ==========================

; need full path for proper path conversion, or just last subdir
cubesdir='/home/rutten/data/SDO/2014-06-14-small/target/cubes/'
moviedir='/home/rutten/data/SDO/2014-06-14-small/target/mpegs/'

sdo_allfitscubes2mpegs,cubesdir,moviedir,$
  /cutxga,/clock,/datebanner,/sharpen,wraprms=3.

;; spawn,'playfs '+moviedir+'/aia1600.mpg'
spawn,'playfs '+moviedir+'/aia94.mpg'
;; spawn,'playfs '+moviedir+'/aia171.mpg'

end

