;; file: writewavetable.pro = make RH wavetable
;; init: Feb 13 2012 
;; last: Jun 14 2016  Rob Rutten  Deil

pro writewavetable,wavetablefile,wav1,wav2,delwav

; no input query response
if (n_params() lt 1) then begin  
  print,'  usage: writewavetable, wavetablefile, wav1, wav2, delwav'
  print,'         wavetablefile = "filename.wave"'
  print,'         wavs in Angstrom'
  return
endif

nwav=(wav2-wav1)/delwav+1
nlambda=long(nwav)
print,' ===== nwav =',nwav
lambda=airtovacuum(wav1/10D0+delwav/10*dindgen(nlambda))
openw,1,/xdr,wavetablefile
writeu,1,nlambda,lambda
close,1

end

; ========= run per Hyper C below ===================

path='/home/rutten/rr/wrk/codes/rh/source_v2/rhf1d/run_2016_ALC7_mg12/'
writewavetable,path+'IR_100_130000_20ma.wave',1000.,13000.,0.02

end
