; file: testnaprof.pdf = tests Halpha profile shape
; init: Aug 24 2013  Rob Rutten, Eindhoven
; last: Sep 13 2013  Rob Rutten, Deil
; note: run in xssw in RH run dir, I did in rh/source_v2/rhf1d/run_2013_FALC
;       run @doinitrh
;       run @doinitline selecting Halpha 
;       newest test at the bottom
;       uncomment STOP statements for earlier tests to see them

; physics constants
hcgs=6.62607D-27            ; Planck constant (erg s)
ccgs=2.99792458D10          ; velocity of light (cm/s)
kev=8.61734D-5              ; Boltzmann constant (eV/deg)
kcgs=1.380658D-16	    ; Boltzmann constant (erg/deg)
hckcgs=hcgs*ccgs/kcgs       ; hc/k in cgs
massH=1.008                 ; hydrogen atomic mass
matom=1.6605D-24            ; constant 
melectron=9.1094E-28        ; electron mass in gram
eelectron=4.803204E-10      ; electron charge in cgs = e.s.u

; ============= first get RH output values

; RH atmosphere parameters 
rheltemp=atmos.T
rheldens=atmos.N_elec*1E-6        ; su to cgs
rhnhtotal=total(atmos.NH,2)*1E-6  ; total hydrogen density, su to cgs
rhnproton=atmos.nh[*,9]*1E-6      ; proton density, su to cgs
rhnhneutral=rhnhtotal-rhnproton   ; neutral hydrogen density, su to cgs
rhpgas=((1+0.086)*rhnhtotal+rheldens)*kcgs*rheltemp
rhvmicro=atmos.vturb              ; in m/s

; RH Halpha wavelengths
iwav1=thisatom.transition[itrans].nblue         ; line start 
nwav=thisatom.transition[itrans].nlambda        ; nr samples
iwav2=iwav1+nwav

; RH extinction coefficients line and continuum
delwav=fltarr(nwav)
extha=fltarr(nwav,nh)
extcont=fltarr(nwav,nh)
for iwav=iwav1,iwav2-1 do begin
  readj,iwav
  readopacity,iwav
  delwav[iwav-iwav1]=10.*(spectrum.lambda[iwav]-spectrum.lambda[iwavlc]) ; AA
  extha[iwav-iwav1,*]=chi_as*1.E-2     ; from per m to per cm
  extcont[iwav-iwav1,*]=chi_c*1.E-2  ; from per m to per cm
endfor

; RH Voigt a value 
rhadamp=(*thisatom.transition[itrans].adamp_ptr)

; ######### select one sample height

; select sample height
ih=70 ; T=6340, Nhyd=1E17, Ne=6E13
ih=60 ; T=4880, Nhyd=2.3E16, Ne=2.6E12
ih=50 ; T=4900, Nhyd=4E14, Ne=7E10 
ih=80 ; T=9140, Nhyd=1.3E17, Ne= 3E15  ; very deep photosphere, large Stark

; fixed params at selected ih sample height
eltemp=rheltemp[ih]
nhneutral=total(rhnhneutral[ih,*])
eldens=rheldens[ih]
pgas=rhpgas[ih]
vmic=rhvmicro[ih]
rhadamp=(*thisatom.transition[itrans].adamp_ptr)[ih]
; print,rhadamp ; 0.30276260  ; very large value deep in atmosphere

; Ha Dopplerwidth 
hawavaa=6563.
airtovac,hawavaa
hawavcm=hawavaa*1.E-8  ; Halpha vacuum wavelength in cm
hadldcm=(hawavcm/ccgs)*sqrt(2*kcgs*eltemp/(massH*matom)+(vmic*1.E2)^2) ; in cm
hadldaa=hadldcm*1.E8  ; in AA


; ##### tests to check normalization of the Voigt profile

;; print,total(hav)/(sqrt(!pi)*hadldaa) 
;;     ;RR wrong since delwav is nonlinear sampling
;; print,trapezint(delwav,hav)/(sqrt(!pi)*hadldaa)
;;   ;RR = 1.0087907  OK, proper normalization 
; test normalization Voigt at very fine linear sampling
deltawav=0.01 ; in AA
nwav=20000  ; not larger to not exceed integer word length
finewav=indgen(nwav)*deltawav-nwav*deltawav/2.
plot,finewav  ; check wavelnegth sampling, sawtooth if over wordlength
finev=finewav/hadldaa
finehav=voigt(rhadamp,abs(finev))
;; print,total(finehav)*deltawav/(sqrt(!pi)*hadldaa)
;;   ;RR = 0.99947623  OK  
;; ; no double precion version; DOUBLE(a) and/or v makes no diference 
;; print,trapezint(finewav,finehav)/(sqrt(!pi)*hadldaa)
;;   ;RR = 0.99947622  trapezintium = same as TOTAL (except endpoints?)
plot,finewav,finehav,/ylog
; STOP ; the plot shows the fine-sampled Voigt function

; ####### tests concerning extinction values at the selected  height

;; print,' === RH ih=',ih,'  temp = ',rheltemp[ih],' eldens = ',rheldens[ih],$
;;   '  nhyd =', rhnhyd[ih,0] 
; print,'  max RH extinction =',max(extha[*,ih]) ; 0.412825
print,'  total RH extinction =',trapezint(delwav,extha[*,ih]) ; 0.273733
;RR dimension cm^-1 * AA because delwav is in AA

; plot RH line and continuum extinction
plot,delwav,extha[*,ih],/ylog,yrange=[max(extha[*,ih])*1E-6,max(extha[*,ih])*2],ystyle=1
oplot,delwav,extcont[*,ih]
; STOP ; the plot shows the RH line-center and cotinuum extinction 

; ##### now overlay my own LTE profile estimates 

; Halpha 
hipf=2.  ; AQ p35   
hag=8
hagf=5.12 ; AQ p70 (de som)  RH f=6.407E-01
hachi=10.1999  ; RH 82258.214 cm-1  => 1.9865E-16*82258.2/1.6022E-12 

; total Halpha line-center extinction (without normalized profile function)
totext=1.E8*!pi*eelectron^2/(melectron*ccgs) $ ; 1.E8: dimension cm^1*AA
  *hawavcm^2/ccgs $     ; = 1.4375535e-19
  *nhneutral*(hagf/hipf)*exp(-hachi/(kev*eltemp)) $ ; level density # gf!
  *(1.-exp(-hckcgs/(hawavcm*eltemp))) ; stimulated emission 
print,'  total RR extinction =',totext

; apply Voigt with the RH a value
voigtv=delwav/hadldaa
profrh=voigt(rhadamp,abs(voigtv))/(sqrt(!pi)*hadldaa)
; print,'  area profrh =',trapezint(delwav,profrh)  ; OK normalized
oplot,delwav,totext*profrh,psym=4  ; 1E*: from AA^-1 to cm^-1
;RR OK my extinction is identical to the RH profile.  Valid only in
; deep layers where LTE holds, see testextha.idl for better tests.
; STOP ; plot = RH Halpha profile at ih overlaid by my voigt with RH adamp

; ##### tests linear Stark broadening by electrons with Holtsmark

; linear wavelength spacing needed for convolution
linwav=indgen(220)*0.1-11.0  ; linear sampling same range as RH Halpha

; Voigt function normalized
linvoigtv=linwav/hadldaa
linhav=voigt(rhadamp,abs(linvoigtv))
linhavnorm=linhav/(sqrt(!pi)*hadldaa)
; print,'   area linhavnorm =',trapezint(linwav,linhavnorm) ; OK, normalized
plot,linwav,linhavnorm,/ylog  ; OK
; STOP ; plot shows the RH normalized Voigt

; oplot RH lorentzian
rhgam=rhgamma[ih]
wavfacaa=hawavaa^2/(ccgs*1E8)  ; c in AA
lorentz=wavfacaa*rhgam/(4*!pi^2)/(linwav^2+(rhgam*wavfacaa/(4*!pi))^2)
arealorentz=trapezint(linwav,lorentz)
; print,'   area lorentz =',arealorentz   ; OK normalized
oplot,linwav,lorentz,linestyle=1  
;RR OK, the Lorentzian wings dupiclate the far RH Voigt wings
; STOP ; plot compares the RH adamp Voigt with RH gamma Lorentzian

; convolve my extinction for Gaussian broadening only with RH Lorentzian
extgauss=totext*exp(-(linwav/hadldaa)^2)/(sqrt(!pi)*hadldaa) 
conlg=convol(extgauss,lorentz,/center,/edge_zero,/normalize) 
plot,delwav,extha[*,ih],/ylog,yrange=[max(extha[*,ih])*1E-6,max(extha[*,ih])*2],ystyle=1
oplot,linwav,conlg,linestyle=3
;RR OK this convolution duplicates the RH extinction profile (except edges)
; STOP ; plot compares convolution my Gauss extinction with Lorentz to RH

; test Voigt approximation = summation
linhavapp=exp(-(linwav/hadldaa)^2)+rhadamp/(sqrt(!pi)*(linwav/hadldaa)^2)
appvoigt=halphaext*linhavapp
oplot,linwav,appvoigt,linestyle=1
; STOP ; plot shows quality sum approx; bad at center because a is not << 1

; do simple Lorentz - Holtsmark shape test
widewav=indgen(20000)*0.1-1000  ; wide linear sampling same range
func1=1./(1+widewav^2)
func2=1./(1+abs(widewav)^2.5)
plot,widewav,func1/trapezint(widewav,func1),/ylog
oplot,widewav,func2/trapezint(widewav,func2),linestyle=2
; print,max(func1/trapezint(widewav,func1)),max(func2/trapezint(widewav,func2))
;RR as expected, Holtsmark decays faster
STOP ; plot = simple comparison wing decay normalized distributions

; very wide linear Stark by electrons following Sutton eqs (15) and (16)
widewav=indgen(30000)*0.1-1500 ; very wide linear sampling 
a1=0.642
nl=2
nu=3
dz=a1*1.66E-13*(nu*nl)^4/(nu^2-nl^2)*eldens^0.6666
 ; print dz  ;  0.56714820 
stark=(3./4)*(dz^1.5)/((dz+abs(linwav))^2.5)  
starkwide=(3./4)*(dz^1.5)/((dz+abs(widewav))^2.5)  
plot,widewav,starkwide,/ylog  

; overplot linear Stark as used with a Voigt in RH 
rhdz=a1*0.60*(nu^2-nl^2)*(eldens*1E6)^0.66667*1.E-4 
; = Sutton eq. 17 = dz in frequency units
; print,rhdz        ; 3.9644078e+10
; print,rhdz*wavfacaa ; 0.56990484 about equal to Sutton dz in AA above
widevoigtv=widewav/hadldaa
starka=wavfacaa*rhdz/(4*!pi*hadldaa)
starkvoigtwide=voigt(starka,abs(widevoigtv))
; print,max(starkwide),max(starkvoigtwide) ; 1.3224057 0.83638155
oplot,widewav,starkvoigtwide/(sqrt(!pi)*hadldaa),linestyle=2
;RR AHA!  The slower decay causes Holtsmark > Voigt in the inner
; wings!  The crossover is at about delta lambda 500 AA!
; STOP ; plot = comparison Sutton Holtzmark with the RH Voigt  

; ######## comapre Halpha Holtsmark to the RH use of Voigt

; van der Waals = Gray 3rd p245 ff, has N_H factored out already
c6=0.3*1E-30*(1/(13.6-10.2-1.2398E4/6563.)^2 - 1/(13.6-10.2)^2)
loggam6=20.+0.4*alog10(c6)+alog10(pgas)-0.7*alog10(eltemp)
gam6=10^loggam6*8.08/17.  

; gamrad=R32+R31
r32=*thisatom.transition[itrans].Rji_ptr
r31=*thisatom.transition[1].Rji_ptr
gamrad=r32[ih]+r31[ih]

; get full Voigt
fulla=wavfacaa*(gamrad+gam6+rhdz)/(4*!pi*hadldaa)
; print,fulla  ;  0.19256317 < rhadamp due to neglect quadratic Stark
fullhav=voigt(fulla,abs(linvoigtv))
; print,'  area fullhav =', trapezint(linwav,fullhav/(sqrt(!pi)*hadldaa)) ; OK
plot,delwav,extha[*,ih],/ylog,yrange=[max(extha[*,ih])*1E-6,max(extha[*,ih])*2],ystyle=1,linestyle=3
oplot,linwav,totext*fullhav/(sqrt(!pi)*hadldaa),linestyle=2
; bit less in wings probably due to neglect quadratic Stark
; STOP ; plot compares RH Ha extinction to RR extinction * full Voigt

; get partial Voigt for only gam6 + gamrad, not gamstark as in RH
parta=wavfacaa*(gamrad+gam6)/(4*!pi*hadldaa)
; print,voigta  ; = 0.025660109  less important
parthav=voigt(parta,abs(linvoigtv))
; print,'  area parthav =', trapezint(linwav,parthav/(sqrt(!pi)*hadldaa)) 
; = 0.99959 OK
oplot,linwav,totext*parthav/(sqrt(!pi)*hadldaa),linestyle=2
; looks good, at ih=80 gamstark >> gam6+gamrad
; STOP  ; plot = RH extinction plus RR extinction * partial Voigt 

; AHA: Gray (11.33)+(11.50)+table 11.4 = how to combine Stark and Voigt

; total extinction without f
nofext=totext*hag/hagf

;; print,max(nofext)*1./(sqrt(!pi)*hadldaa)*voigt(rhadamp,0)*hagf/hag 
;;   ; 0.41173974
;; print,max(extha[*,ih]) 
;;   ; 0.412825  OK, nearly the same (deep enough for LTE)

; first simple summation = Gray 11.50, only valid at large Stark 
; ezero=(4*!pi/3)^0.666667*eelectron*eldens^0.666667   ; Gray (11.33)
; print,ezero ; = 25.686908 = normalization; eldens must go out again
ezero=1. ; Sutton's profile is already normalized
oplot,linwav,nofext*(0.392058*stark/ezero+0.248689*parthav/(sqrt(!pi)*hadldaa)) $ 
,linestyle=0
;RR central part the same but wings HIGHER!! out to 500 AA... see above
; separation top and bottom cuves is the effect of linear Stark = huge
; STOP ; plot shows RH extinction plus Gray summation 

; ==== full convolution
constark=convol(0.392058*stark/ezero,parthav/(sqrt(!pi)*hadldaa),$
   /center,/edge_zero,/normalize)
rrhaext=nofext*(constark+0.248689*parthav/(sqrt(!pi)*hadldaa))
oplot,linwav,rrhaext,psym=1,symsize=0.2
;RR identical to the simpler summation for ih=80 but not for lower Stark
; because summation only holds for gammastark > others

end

