; file: testhagammas.pro = tests broadening functions for Halpha
; init: Sep  3 2013  Rob Rutten, Deil
; last: Sep 12 2013  Rob Rutten, Deil
; note: segment taken originally out of trial testhaext.idl
; note: run in xssw in RH run dir, I did in rh/source_v2/rhf1d/run_2013_FALC
;       run @doinitrh
;       run @doinitline selecting Halpha 

; constants
hcgs=6.62607D-27            ; Planck constant (erg s)
ccgs=2.99792458D10          ; velocity of light (cm/s)
kev=8.61734D-5              ; Boltzmann constant (eV/deg)
kcgs=1.380658D-16	    ; Boltzmann constant (erg/deg)
hckcgs=hcgs*ccgs/kcgs             ; hc/k in cgs
massH=1.008                 ; hydrogen atomic mass
matom=1.6605D-24            ; constant 
melectron=9.1094E-28        ; electron mass in gram
eelectron=4.803204E-10      ; electron charge in cgs

; ============= get RH samples FALC ===============

; 
rheltemp=atmos.T                  ; temperature
rheldens=atmos.N_elec*1E-6        ; electron density, su to cgs
rhnhtotal=total(atmos.NH,2)*1E-6  ; total hydrogen density, su to cgs
rhnproton=atmos.nh[*,9]*1E-6      ; proton density, su to cgs
rhnhneutral=rhnhtotal-rhnproton   ; neutral hydrogen density, su to cgs
rhvmicro=atmos.vturb              ; in m/s
rhpgas=((1+0.086)*rhnhtotal+rheldens)*kcgs*rheltemp

plot,heightkm,rhnhtotal,/ylog
oplot,heightkm,rhnhneutral,linestyle=2
oplot,heightkm,rhnproton,linestyle=2
oplot,heightkm,rheldens,linestyle=1
;RR  Inconsistency N_e < N_p.  At right effect of ionization 

; STOP ; plot shows hydrogen + electron densities.  

; compute and plot Gamma_total used by RH
rhadamp=(*thisatom.transition[itrans].adamp_ptr)
wavlc=airtovacuum(spectrum.lambda[iwavlc])*1E-7  ; line-center wav in cm
freqlc=ccgs/wavlc
doppwidf=freqlc/ccgs*sqrt(2*kcgs*rheltemp/(massH*matom)+(rhvmicro*1E2)^2)
rhgamma=rhadamp*4*!pi*doppwidf
plot,heightkm,rhgamma,/ylog,yrange=[1E7,1E11],ystyle=1 ; solid

; Linear Stark = Sutton formula as used by RH (but RH applies a Voigt)
;; RH: GStark = a_1 * [0.60 * (n_u^2 - n_l^2) * (N_e)^(2/3) * CM_TO_M^2]
nu=3
nl=2
rhgstark=0.642*0.60*(nu^2-nl^2)*(rheldens*1E6)^0.66667*1.E-4 
oplot,heightkm,rhgstark,linestyle=1 

; oplot gamrad
; plots,[0,2000],[Aul,Aul],linestyle=1
;; plots,[0,2000],[Aul,Aul],linestyle=1

r32=*thisatom.transition[itrans].Rji_ptr
r31=*thisatom.transition[1].Rji_ptr
r21=*thisatom.transition[0].Rji_ptr
oplot,heightkm,r32+r32,linestyle=1    ;; RH uses this sum

; now my van der Waals.  H-9.atom specifies UNSOLD.
; RH UNSOLD: Gamma = 8.08 * vrel^3/5 * C_6^2/5 * atmos.H.ntotal_neutral

; van der Waals = Gray 3rd p245 ff, has N_H factored out already
c6=0.3*1E-30*(1/(13.6-10.2-1.2398E4/6563.)^2 - 1/(13.6-10.2)^2)
loggam6=20.+0.4*alog10(c6)+alog10(rhpgas)-0.7*alog10(rheltemp)
; correction: RH has Mihalas II table 9-1 p.286 = 8.08
; while Gray has prefactor 17 in his eq.11.28 on p.245
gam6a=10^loggam6*8.08/17.  
oplot,heightkm,gam6a,linestyle=2 

STOP

; van der Waals following RTSA p 56-57
rhpgas=(rhnhyd+rheldens)*kcgs*rheltemp
; Warner 1967: Bates-Damgaard valid only for n*>l+1, not the case here
; anyhow, for H itself you don't have to do a hydrogenic approximation
;; llow=1
;; lup=2
;; nsqlow=13.6/(13.6-10.2)
;; nsqup=13.6/(13.6-10.2-1.2398E4/6563.)
;; rsqlow=nsqlow/2.*(5*nsqlow+1-3*llow*(llow+1))
;; rsqup=nsqup/2.*(5*nsqup+1-3*lup*(lup+1)) ;; negative
rsqlow=2^4  ; Telfer eq. 10: r=n^2 in atomic units; Bates-Damgaard also n^4
rsqup=3^4  ; nearly the same
loggam6=6.33+0.4*alog10(rsqup-rsqlow)+alog10(rhpgas)-0.7*alog10(rheltemp)
;RR with 20 identical to Gray.  So how did he get 20 instead of 6.33?
gam6b=10^loggam6
oplot,heightkm,gam6b,linestyle=2
;RR a bit smaller than the RH UNSOLD values above

; very simple quadratic Stark: Gray p244, but I don't know c4
; RTSA p56: not for hydrogen
;; logc4=-18
;; loggam4=19.+2./3*logc4+alog10(rhpgas)-(5./6)*alog10(rheltemp)
;; gam4=10^loggam4
;; oplot,heightkm,gam4,linestyle=1

; oplot the sum
;; oplot,heightkm,gam6+Aul+rhgstark,linestyle=3,thick=3
oplot,heightkm,gam6a+r32+r31+rhgstark,linestyle=3,thick=3  
;RR OK, nearly the same as RH
;RR above T-min linear Stark is the next important after gamrad
;RR this neglects linear Stark by protons, formula?
;RR this neglects quadratic Stark, amyybe that is the deep difference
;RR this neglects helium contribution
 
end
