; file: testhaext.pro = tests Halpha extinction my routines against RH
; init: Aug 24 2013  Rob Rutten, Eindhoven
; last: Sep 12 2013  Rob Rutten, Deil
; note: run in xssw in RH run dir, I did in rh/source_v2/rhf1d/run_2013_FALC
;       run @doinitrh
;       run @doinitline selecting Halpha 

; constants
h=6.62607D-27               ; Planck constant (erg s)
c=2.99792458D10             ; velocity of light (cm/s)
k=1.38062D-16               ; Boltzmann constant in erg/deg
kev=8.61734D-5              ; Boltzmann constant (eV/deg)
kcgs=1.380658D-16	    ; Boltzmann constant (erg/deg)
hck=h*c/kcgs                ; hc/k in cgs
mH=1.008                    ; hydrogen atomic mass
matom=1.6605D-24            ; constant 
melectron=9.1094E-28        ; electron mass in gram
eelectron=4.803204E-10      ; electron charge in cgs

; ============= first get RH output values

; RH analyze:  Ha = iwav 5815 cont blue 5796  cont red 5836
; 
rheltemp=atmos.T
rheldens=atmos.N_elec*1E-6  ; su to cgs
rhnhtotal=total(atmos.NH,2)*1E-6  ; total hydrogen density, su to cgs
rhnproton=atmos.nh[*,9]*1E-6      ; proton density, su to cgs
rhnhneutral=rhnhtotal-rhnproton   ; neutral hydrogen density, su to cgs
rhvmicro=atmos.vturb              ; in m/s
rhpgas=((1+0.086)*rhnhtotal+rheldens)*kcgs*rheltemp
rhvmicro=atmos.vturb        ; in m/s

iwav1=thisatom.transition[itrans].nblue         ; line start 
nwav=thisatom.transition[itrans].nlambda        ; nr samples
iwav2=iwav1+nwav

; get populations, compute departure coefficients etc
nlow=(*thisatom.n_ptr)[*,ilow] 
nstarlow=(*thisatom.nstar_ptr)[*,ilow] 
nupp=(*thisatom.n_ptr)[*,jupp] 
nstarupp=(*thisatom.nstar_ptr)[*,jupp] 
blow=nlow/nstarlow
bupp=nupp/nstarupp

; compute epsacc(h) and epsacc*B(h)
Aul=thisatom.transition[itrans].strength
Cul=(*thisatom.Cij_ptr)[*,jupp,ilow]
@constants_si.idl
epsacc=(1.-exp(-hplanck*clight/(wavlc*nm_to_m*kboltzmann*atmos.t)))*Cul/Aul
epsaccB=epsacc*planck(atmos.T,wavlc,/hz)
eps2level=(1.-exp(-hplanck*clight/(wavlc*nm_to_m*kboltzmann*atmos.t)))*Cul $
  /(Aul+(1.-exp(-hplanck*clight/(wavlc*nm_to_m*kboltzmann*atmos.t)))*Cul)

; get extinction coefficients line and continuum
delwav=fltarr(nwav)
extha=fltarr(nwav,nh)
extcont=fltarr(nwav,nh)

for iwav=iwav1,iwav2-1 do begin
  readj,iwav
  readopacity,iwav
  delwav[iwav-iwav1]=10.*(spectrum.lambda[iwav]-spectrum.lambda[iwavlc]) ; AA
  extha[iwav-iwav1,*]=chi_as*1.E-2     ; from per m to per cm
  extcont[iwav-iwav1,*]=chi_c*1.E-2  ; from per m to per cm
endfor

; ##### tests to check my continuum extinction routines against RH 

; my continuous extinction for all heights 
labda=6563. 
extrrhmin=fltarr(nh)
extrrhneu=fltarr(nh)
extrrthomson=fltarr(nh)
extrrrayleigh=fltarr(nh)
labda=6563.
for ih=0,nh-1 do begin
  extrrhmin[ih]=exthmin(labda,rheltemp[ih],rheldens[ih])*rhnhneutral[ih]
  extrrhneu[ih]=(exthneubf(labda,rheltemp[ih]) $
    +exthneuff(labda,rheltemp[ih]))*rhnhneutral[ih]
  extrrthomson[ih]=0.664E-24*rheldens[ih]  ; Thomson
  extrrrayleigh[ih]=1.13/2.*0.664E-24*rhnhneutral[ih]*(1216./6563.)^4
endfor
extrrtotal=extrrhmin+extrrhneu+extrrthomson+extrrrayleigh
plot,heightkm,extcont[0,*],/ylog
oplot,heightkm,extrrtotal,linestyle=3
oplot,heightkm,extrrhmin,linestyle=2
oplot,heightkm,extrrhneu,linestyle=2
oplot,heightkm,extrrthomson,linestyle=1
oplot,heightkm,extrrrayleigh,linestyle=1

;RR not bad, above h=800 km overestimate due to NLTE?

; STOP ; the plot shows my continuous extinction compared to RH but see below

; get population and departure coefficients H groundlevel and ion (proton)
nground=(*thisatom.n_ptr)[*,0] 
nstarground=(*thisatom.nstar_ptr)[*,0] 
bground=nground/nstarground
nproton=(*thisatom.n_ptr)[*,9] 
nstarproton=(*thisatom.nstar_ptr)[*,9] 
bproton=nproton/nstarproton
plot,heightkm,bproton                                
oplot,heightkm,bground

; RR There is only overpopulation of the hydrogen ground state above
; h=1000 km.  The proton b has a peak in T-min due to Balmer-continuum
; overionization, then it drops from the underionization, gets to b=1
; only at full ionization at the top of the TR.

; STOP ; the plot shows b_1 and b_cont for hydrogen against height

; RR Above I used the RH actual neutral hydrogen density.  But the
; exth* routines from Gray suppose LTE to connect the proton density
; to H_neutral.  So do a test with bproton/bground ratio as correction
; factor for both H_bf and H_ff:

for ih=0,nh-1 do begin
  extrrhmin[ih]=exthmin(labda,rheltemp[ih],rheldens[ih])*rhnhneutral[ih]
  extrrhneu[ih]=(exthneubf(labda,rheltemp[ih]) $
    + exthneuff(labda,rheltemp[ih]))*rhnhneutral[ih]*bproton[ih]/bground[ih]
  extrrthomson[ih]=0.664E-24*rheldens[ih]  ; Thomson
  extrrrayleigh[ih]=1.13/2.*0.664E-24*rhnhneutral[ih]*(1216./6563.)^4
endfor
extrrtotal=extrrhmin+extrrhneu+extrrthomson+extrrrayleigh
plot,heightkm,extcont[0,*],/ylog
oplot,heightkm,extrrtotal,linestyle=3
oplot,heightkm,extrrhmin,linestyle=2
oplot,heightkm,extrrhneu,linestyle=2
oplot,heightkm,extrrthomson,linestyle=1
oplot,heightkm,extrrrayleigh,linestyle=1

; STOP ; the plot shows comparison of my continuous extinction against RH

;RR OK, now they are nearly the same.  Conclusion: Gray exthneu
; routines fail where hydrogen goes out of LTE.  Not surprising!
; Above h=1300 km Thomson scattering is the main continuum extinction.
; The difference between H_bf sim N_proton and Thomson is from the
; electron contribution by the metals (N_e approx 1E-4 N_Htot)

; ########### inspect behavior continuous extinction with wavelength

ih=60    ; 81 = bottom   54= T_min
ih=81    ; 81 = bottom   54= T_min
wavarr=indgen(500)*10.+4000.
sizewavarr=size(wavarr)
nwavarr=sizewavarr[1]
extrrhmin=fltarr(nwavarr)
extrrhneu=fltarr(nwavarr)
extrrthomson=fltarr(nwavarr)
extrrrayleigh=fltarr(nwavarr)
for iwav=0,nwavarr-1 do begin
  extrrhmin[iwav]=exthmin(wavarr[iwav],rheltemp[ih],$
    rheldens[ih])*rhnhneutral[ih]
  extrrhneu[iwav]=(exthneubf(wavarr[iwav],rheltemp[ih]) $
    + exthneuff(wavarr[iwav],rheltemp[ih])) $
    *rhnhneutral[ih]*bproton[ih]/bground[ih]
  extrrthomson[iwav]=0.664E-24*rheldens[ih]  ; Thomson
  extrrrayleigh[iwav]=1.13/2.*0.664E-24*rhnhneutral[ih]*(1216./wavarr[iwav])^4
endfor
extrrtotal=extrrhmin+extrrhneu+extrrthomson+extrrrayleigh

plot,wavarr,extrrtotal
oplot,wavarr,extrrhmin,linestyle=1
oplot,wavarr,extrrhneu,linestyle=1
oplot,wavarr,extrrthomson,linestyle=1
oplot,wavarr,extrrrayleigh,linestyle=1

; STOP ; the plot shows continuous extinction versus wavelength at height ih

;RR In the deepest photosphere H_bf larger than H^min_bf.  Always
; increase from 4000 to 8000, typically factor 2.  
; NB: 8542 is beyond Paschen limit!



; ############## now compare my and RH Halpha line-center extinction 

; Ha Dopperwidth
hawavaa=6563.
airtovac,hawavaa
hawavcm=hawavaa*1.E-8  ; Halpha vacuum wavelength in cm
hadldcm=(hawavcm/c)*sqrt(2*k*rheltemp/(mH*matom)+(vmic*1.E2)^2)  
hadldaa=hadldcm*1.E8  ; DLD array AA

; Ha Voigt a values
rhadamp=(*thisatom.transition[itrans].adamp_ptr)[*]

; compute Ha extinction inclusive NLTE departures from RH
harrext=fltarr(nh)
harrext=sqrt(!pi)*eelectron^2/(melectron*c) $
  *(hawavcm^2/c) $
  *(1./hadldcm) $
  *rhnhneutral/bground $  ; LTE neutral H density (correct actual NLTE rhnhneutral)
  *(hagf/hipf)*exp(-hachi/(kev*rheltemp)) $ ; LTE Bolatzmann factor
  *blow $  ; NLTE correction 
  *voigt(rhadamp,abs(delwav[iwavlc-iwav1])/hadldcm) $ ; select line center
  *(1.-(bupp/blow)*exp(-hck/(hawavcm*rheltemp))) ; stimulated emission 

plot,heightkm,extha[iwavlc-iwav1,*],/ylog
oplot,heightkm,harrext,psym=4

; STOP  ; OK, nearly the same; slight deviation may be wrong eldens

end
