;; file: readwavetable.pro = read RH wavetable
;; init: Feb  5 2012 

pro readwavetable, wavetablefile, lambdas=lambdas

; no input query response
if (n_params() lt 1) then begin  
  print,'  usage: readwavetable, wavetablefile, lambda=lambdas'
  print,'         wavetablefile = "filename.wave"'
  print,'         lambdas = wavelength list (dblarr)'
  return
endif

nlambda=0L
openr,/xdr,1,wavetablefile
readu,1,nlambda
print,' ==== nlambda =', nlambda
lambdas=dblarr(nlambda)
readu,1,lambdas
close,1
lambdas=vacuumtoair(lambdas)
print,' nlambda =',nlambda
print,' lambdas[0],[1],..,[n] (nm) =',lambdas[0],lambdas[1],lambdas[nlambda-1]

end
