; file: openactivetransition.pro = define parameters for a active line
; init: Feb  4 2012 
; note: must be called with .r, not @ 
; needs as known input: linewav (nm)
;                       elements=['H','MG','AL','SI','FE']

nrtrans=0
sizeelem=size(elements)   
nelem=sizeelem[1]
text=' - elem,itrans,i,j,wavnr,wavair,wavvac ='
for ielem=0,nelem-1 do begin
  nextatom=readatom('atom.'+elements[ielem]+'.out')
  ntr=nextatom.nline+nextatom.ncont
  for itr=0,ntr-1 do $
    if (abs(nextatom.transition[itr].lambda0-linewav) lt transinterval) $
    then begin
      thisatom=nextatom
      wavlc=thisatom.transition[itr].lambda0
      tabinv,spectrum.lambda,wavlc,iwavlc
      itrans=itr
      nrtrans=nrtrans+1
      iwavlc=long(iwavlc+0.1)
      ilow=thisatom.transition[itr].i
      jupp=thisatom.transition[itr].j
      if (transprint) then print,text,elements[ielem],itr,$
        ilow,jupp,iwavlc,wavlc,airtovacuum(wavlc),$
        format='(A43, A3, I5, I3, I3, I7, F9.3, F9.3)'
;RR how to spread format statement over multiple lines?
     ;; strwavlc=string(wavlc)
      ;; spawn,'grep
      ;; /home/rutten/rr/wrk/linetables/kurucz/gfall.dat'+strwavlc
    endif
endfor 
if (nrtrans eq 0) then print,' ### OPENTRANSITION: no line found'
if (nrtrans gt 1 and transprint eq 0) then $
    print,' ### OPENTRANSITION: multiple lines found'

end



