; file: makefontenlamodel.pro
; init: Feb 11 2012 

; select model
path='/home/rutten/rr/wrk/models/fontenla/2009ApJ...707..482F/'
modelnr='1001'
ndep=91
skiplines=4
atmosid='Fontenla2009-'+modelnr+'_91'
gravitation=27542.287D0    ; = log g = 4.44
scale='GEOMETRIC_SCALE'

; read model as structure
fonmodfile=path+'Model'+modelnr+'.tab'  
fonmodinstruct={ind:0.0,height:0.0,T:0.0,N_elec:0.0,n_p:0.0,$
     n_a:0.0,nh:0.0,vturb:0.0,accel:0.0,b_hminus:0.0,v:0.0,$
     b_h2:0.0,b_h2plus:0.0}
read_struct,fonmodfile,fonmodinstruct,fonin,$
  nlines=ndep+skiplines,skiplines=skiplines

;; nh=0.0D+0

fonout={atmosid:atmosid, gravitation:gravitation, ndep:long(ndep),$
  scale:scale, height:fonin.height, T:fonin.T, n_elec:fonin.n_elec,$
  v: fonin.v, vturb:fonin.vturb,nH:fonin.nh}

;; write1datmos,fonout,$
;;   filename='/home/rutten/rr/wrk/codes/rh/source_v2/Atmos/'+atmosid+'.atmos'

writemulti, fonout, 1, $; hlte=hlte,$
  filename='/home/rutten/rr/wrk/codes/rh/source_v2/Atmos/'+atmosid+'.atmos'

end
