; file: makefigtbspectrum.pro = main to produce RH emergent spectrum plot
; init: Sep 29 2016  Rob Rutten  Deil
; last: May 11 2019  Rob Rutten  Deil


; note: IDL in terminal in RH wrk dir:   @doinitrh   .r makefigtbspectrum

; =============== @@ 2019 vienna irr: flip choices at each ### entry

neckeldir='/home/rutten/wrt_Tosh2/vienna/paper/robfigs/'
psdir='/home/rutten/wrt_Tosh2/vienna/paper/robfigs/'

; #### set outfilename start
;; outfilename='tb-FALC-bruls'
outfilename='tb-FALC-lte-it'     ; it = modfied H ionization threshold 
outfilename='tb-FALC-2level-it'  ; ### move to this directory and repeat IDL

; #### set plotlabel accordingly
;; plotlabel='FALC per RH (Bruls fudge)'
plotlabel='FALC per RH (Kurucz lines S=B)'
plotlabel='FALC per RH (Kurucz lines 2-level S)'

; #### set wavelength range (AA) ## must be same as Neckel plotftsint run
xrange=[3300,3750] ; Vienna UV + overlap to avoid label blocking
xrange=[3700,6700] ; Vienna optical, avoid end partial histrogram bin 

; #### select neckel histogram data
neckelfile='neckel-ultraviolet.dat'
neckelfile='neckel-optical.dat'

; ### set segwidth in AA (bin width of histogram averages, 0 = none)
;; segwidth=0
segwidth=10 ; Vienna UV
segwidth=100 ; Vienna optical

; 
;; ============== end of Vienna choices 


;; xrange=[3300,3700] ; Vienna UV

;; xrange=[3700,6730] ; wav range optical = Dunn et al
;; xrange=[3290,3700] ; shortest Neckel wide
;; xrange=[3858,3861] ; FeI mult 4
;; xrange=[3930,3936] ; Bruls CaIIK OK, large central reversal
;; xrange=[6555,6570] ; Bruls Halpha weird spikes and central emission ?????
;; xrange=[3301,3308] ; shortest Neckel narrow
;; xrange=[4553,4557] ; my BaII segment 
;; xrange=[3930,3936] ; core CaII K
;; xrange=[3966,3971] ; core CaII H + Hepsilon
;; xrange=[6553,6573] ; H-alpha ;# wings reasonable but not deep enough
;; xrange=[4851,4871] ; H-beta  ;# RH misses the Holtsmark wings!
;; xrange=[4330,4350] ; H-gamma ;# RH misses the Holtsmark wings!

; ### choose addneckel (dashed) 
;; addneckel=1
addneckel=0

; ### add neckel means histogram
neckelhist=1

; ### set Tb range (K)
yrange=[3200,7200] ; Vienna both optical and UV

; read 


; =============== parameter-free from here =================================

; extend outfilename
wav1=xrange[0]
wav2=xrange[1]
psfilename=psdir+outfilename+'_'+trim(wav1)+'-'+trim(wav2)+'.ps'

; check or get radial intensity 
if (n_elements(radint) eq 0) then begin
;;  print,' ===== run ../solveray first if no file spectrum_1.0'
  radint=readray('spectrum_1.00')
endif

; find index start and end
ix1=where(abs(spectrum.lambda-xrange[0]/10.) eq $
  min(abs(spectrum.lambda-xrange[0]/10.)))
ix1=ix1[0]-1
ix2=where(abs(spectrum.lambda-xrange[1]/10.) eq $
  min(abs(spectrum.lambda-xrange[1]/10.)))
ix2=ix2[0]+1
if (ix1 eq -1 or ix2 eq -1) then $
  print,' ====== no wavindex found: ix1, ix2 = '+trim(ix1)+'  '+trim(ix2)
  
; convert to brightness temperature
tb=brighttemp(spectrum.lambda[ix1:ix2],radint.i[ix1:ix2],/Hz)

; make plot
openpsplot,psfilename,thick=1,fontsize=6
!p.thick=0.1   ; thin curves
angstrom=cgsymbol("angstrom") ; Coyote cg, probably most robust
xtitle='wavelength  ['+angstrom+']'
ytitle='brightness temperature  [K]'
wavs=spectrum.lambda[ix1:ix2]*10.
if (wav2-wav1 ge 3) then tickformat='(I8)' else $ 
  if (wav2-wav1 ge 1) then tickformat='(f8.1)' else $
    if (wav2-wav1 ge 0.1) then tickformat='(f8.2)' else $
      if (wav2-wav1 ge 0.01) then tickformat='(f8.3)'
plot,wavs,tb,$
  position=[0.15,0.15,0.95,0.95],/normal,$        ; margins
  xticklen=0.03,yticklen=0.03/1.6,$   ; same-length ticks
  xtitle=xtitle,ytitle=ytitle,$
  xrange=xrange,xstyle=1,$
  xtickformat=tickformat,$
  xtickinterval=(wav2-wav1 gt 3)*!x.tickinterval + $ 
    (wav2-wav1 le 3)*fix((wav2-wav1)/3.),$
  yrange=yrange,ystyle=1

xyouts,0.40,0.86,/norm,charsize=1.3,plotlabel

; get neckel if requested and if not already open
if (addneckel eq 1) then begin
  neckelpath='/home/rutten/rr/wrk/atlases/neckel/'
  neckelsave='neckel_intens_atlas.idlsave'
  restore,neckelpath+neckelsave
; convert into brightness temperature
  neckeltb=brighttemp(neckelwav*1.E-4,neckelint*1.E7*1E4)
endif

if (addneckel eq 1) then $
oplot,neckelwav,neckeltb,linestyle=1

; optionally add segwidth averaged rectangular curve
if (segwidth ne 0) then begin

; copied from plotftsint.pro
  nwavs=n_elements(wavs)
  startseg=fix(wav1/segwidth)*segwidth
  endseg=fix(wav2/segwidth)*segwidth
  nseg=(endseg-startseg)/segwidth
  segwavs=fltarr(nseg)
  segmeans=fltarr(nseg)
  segwav1=indgen(nseg)*segwidth+startseg
  segwav2=segwav1+segwidth
  segwavs=(segwav1+segwav2)/2.
  for iw1=0l,nwavs-1 do if (wavs[iw1] ge segwav1[0]) then break
  for iseg=0,nseg-1 do begin  
    for iw1=iw1,nwavs-1 do if (wavs[iw1] ge segwav1[iseg]) then break
    for iw2=iw1,nwavs-1 do if (wavs[iw2] ge segwav2[iseg]) then break
    ;; segwavs[iseg]=(wavs[iw2]-wavs[iw1])/2.+wavs[iw1]
    ;; segwavs[iseg]=(segwav2[iseg]-segwav1[iseg])/2.+startseg
; check on NaNs (RH bunch at 3888.8 Angstrom)
    for iw=iw1,iw2 do if (finite(tb[iw]) eq 0) then begin
      print,' ----- T_b = NaN, wav, int = '+$
        trimd(wavs[iw])+trimd(radint.i[iw])+';  tb set to 4000'
        tb[iw]=4000.
    endif
    segmeans[iseg]=avg(tb[iw1:iw2])
   endfor
; extend end segments
  segwavs=[segwav1[0]-segwidth/2,segwavs,segwav2[nseg-1]+segwidth/2]
;;  segwavs=[segwavs,segwav2[nseg-1]+segwidth/2]
  segmeans=[segmeans[0],segmeans,segmeans[nseg-1]]
;;  segmeans=[segmeans,segmeans[nseg-1]]

  ; overplot - AHA: psym=10 histogram mode     
  oplot,segwavs,segmeans,psym=10,color=255,thick=3

; add yellow histogram for Neckel

if (neckelhist ne 0) then begin
 readcol,neckeldir+neckelfile,neckwavs,neckmeans
 oplot,neckwavs,neckmeans,psym=10,color=cgcolor('yellow'),thick=3
endif

; print mean   
  print,' ===== overall mean Tb ='+trimd(mean(segmeans))

endif

closepsplot,psfilename,opengv=1

end

; do NOT run per hyper-C but in RH terminal after @doinitrh 

; AHA RH does all non-detailed Kurucz lines as 2-level scattering 
;     and so their cores are generally far too dark in the optical
