; file: makefigtbprof.pro = main to produce intensity profile plot as T_b
; init: May 22 2016  Rob Rutten  Mitaka from makefigintprof.pro
; last: Dec 27 2016  Rob Rutten  Deil
; note: parameter-free except xrange, yrange axis tuning etc

; check or get radial intensity 
if (n_elements(radint) eq 0) then begin
;;  print,' #### run ../solveray first if no file spectrum_1.0'
  radint=readray('spectrum_1.00')
endif

; get emergent spectrum
iwav1=thisatom.transition[itrans].nblue         ; line start 
nwav=thisatom.transition[itrans].nlambda        ; nr samples
iwav2=iwav1+nwav-1
wav1=spectrum.lambda[iwav1]
wav2=spectrum.lambda[iwav2]

; double RH profile if only half is computed 
wavarr=spectrum.lambda[iwav1:iwav2]
;; profarr=spectrum.i[iwav1:iwav2,4]
profarr=radint.i[iwav1:iwav2]
if (iwav1 eq iwavlc) then begin
  wavarrleft=reverse(wavlc-(wavarr-wavlc))
  profarrleft=reverse(profarr)
  wavarr=[wavarrleft,wavarr[1:nwav-1]]
  profarr=[profarrleft,profarr[1:nwav-1]]
  wav1=wavarr[0]
  wavleft=wavarr[2*nwav-2]
endif

; open Neckel intensity atlas if not already open
if (neckel eq 0) then addneckel=0 
if (addneckel eq 1 and n_elements(neckelwav) eq 0) then begin
  neckelpath='/home/rutten/rr/wrk/atlases/neckel/'
  neckelsave='neckel_intens_atlas.idlsave'
  restore,neckelpath+neckelsave
; convert into brightness temperature
  neckeltbprof=brighttemp(neckelwav*1.E-4,neckelint*1.E7*1E4)
  neckeltbcont=brighttemp(neckelwav*1.E-4,neckelcont*1.E7*1E4)
endif

; convert delwav to velocity; shift to Neckel atlas in overlay format
clight=299792458.*1E-3  ; km/s
if (addneckel eq 1) then shiftwav=neckelshift else shiftwav=0 
delwav=wavarr-wavlc+shiftwav     ; delta labda from line center in nm
delvel=clight*delwav/wavarr ; delta lambda in km/s

; convert intensity to brightness temperature
profarrtb=brighttemp(wavarr,profarr,/Hz)

; plot RH's emergent profile
if (opengv) then spawn,'pkill -s 0 gv'
psfilename='fig-tbprof-'+modelname+'-'+filelinename+'.ps'
;RR fit to SBJtemp; font must be <  default 9 (smaller ymax in position)
openpsplot,psfilename,thick=2,fontsize=8,xsize=8.0,ysize=8./plotaspect
if (addneckel) then linestyle=1 else linestyle=0
angstrom=cgsymbol("angstrom") ; Coyote cg, probably most robust
xtitle=textoidl("\Delta\lambda as Dopplershift [km s^{-1}]")
ytitle=textoidl("I_\lambda(0,1)  as  T_{b}  [K]")
xrange=[-wavrange,+wavrange] ; km/s both directions
yrange=temprange
if (yrange[1]-yrange[0] lt 5000) then ytickinterval=1000 $
  else if  (yrange[1]-yrange[0] lt 10000) then ytickinterval=2000 $
  else  ytickinterval=5000
plot,delvel,profarrtb,linestyle=linestyle,$
  position=[0.2,0.2,0.85,0.8],/normal,$     ; set margins around plot
  xticklen=0.03,yticklen=0.03/plotaspect,$  ; same-length ticks
  xtitle=xtitle,ytitle=ytitle,$
  xrange=xrange,xstyle=9,$
  yrange=yrange,ystyle=9,ytickinterval=ytickinterval,ytickformat='(I8)'

; add wavelength axis on top 
aarange=wavlc*10.*xrange/clight  ;; AA
aatitle=textoidl("\Delta\lambda [")+angstrom+']'
xtickinterval=max([fix(float(wavrange)/4),1.])
axis,xaxis=1,xrange=aarange,xstyle=1,xtitle=aatitle
;RR no xtickinterval?

; oplot Neckel profile when requested
if (addneckel and neckel ne 0) then begin
  delneckelwav=neckelwav-wavlc*10. ; AA
  neckelvel=clight*delneckelwav/neckelwav
  oplot,neckelvel,neckeltbprof,linestyle=0
  oplot,neckelvel,neckeltbcont,linestyle=0
endif

; add vertical line-wav indicator(s)
;; if (PRD) then iwavarr=[iwavlc,iwavpeak,iwavdip,iwavwing] else iwavarr=[iwavlc] ;RR same as dip and too confusing
if (PRD) then iwavarr=[iwavlc,iwavpeak,iwavdip] else iwavarr=[iwavlc]
sizeiwavarr=size(iwavarr)
for iw=0,sizeiwavarr[1]-1 do begin
  iwavplot=iwavarr[iw]
  wavplot=spectrum.lambda[iwavplot]
  velplot=clight*(wavplot-wavlc)/wavplot
  plots,[velplot,velplot],[yrange[0],yrange[1]],linestyle=1
endfor

; add height[tau_lc=1] curve
htauone=fltarr(nwav+1)
;; tau=fltarr(nh)
for iwav=iwav1,iwav2 do begin
  readopacity,iwav
  tau=gettau(height,chi_as+chi_c)   ; getTau in readopacity.pro
  tabinv,tau,1.0,tau_one            ; fractional array index where tau=1
  htauone[iwav-iwav1]=linear(heightkm,tau_one)  ; can be large sprectrum piece
endfor

; double htauone array if only half profile computed
if (iwav1 eq iwavlc) then begin
  htauoneleft=reverse(htauone)
  htauone=[htauoneleft,htauone[1:nwav-1]]
endif

;; ; #### 
;; writecol,'tau1heights.dat',delwav,htauone

; transform htauone to intensity scale
minhone=0
maxhone=heightrange[1]
honeint=(htauone-minhone)/(maxhone-minhone)*(yrange[1]-yrange[0])+yrange[0]
oplot,delvel,honeint,linestyle=2

; add height[tau=1] axis to the right
axis,yaxis=1,yrange=[minhone,maxhone],ystyle=1,ytickinterval=500,yminor=5,$
  ytitle=textoidl("height (tau=1) [km]")

; add model name (no overlap problems for this plot)
xyouts,0.23,0.23,/norm,modelname

; add line name
xyouts,0.62,0.23,/norm,pslinelabel

; add run dir
if (addrundir eq 1) then begin
  cd,c=thedir
  lastdir=strsplit(thedir,'/',/extract)
  sizelastdir=size(lastdir)
  xyouts,0.01,0.01,/norm,lastdir[sizelastdir[1]-1]
endif

; close plot
closepsplot,psfilename,opengv=opengv


end

