; file: makefigtauchrom.pro 
; init: Aug  9 2013  Rob Rutten  Deil
; last: Aug  8 2018  Rob Rutten  Deil
; note:  @doinitrh   @doinitline  .r makefigtauchrom

;RR the line choice does not matter

; initialize figure
; -----------------
if (opengv) then spawn,'pkill -s 0 gv'
psfilename='fig-tau-chrom-'+modelname+'.ps'
openpsplot,psfilename,thick=2,xsize=8,ysize=8/plotaspect
xtitle='height  [km]'
ytitle='log(optical depth)'
xrange=[0,2300]
yrange=[-3,7]
labelheight=1500.

; Halpha 
linename='Halpha'
@atfindline
readopacity,iwavlc
tau=fltarr(nh)
tau=gettau(height,chi_as+chi_c)   ; getTau in readopacity.pro
labelind=where(abs(heightkm-labelheight) lt min(abs(heightkm-1500))+1)

; make plot
plot,heightkm,alog10(tau),$
    position=[0.2,0.2,0.8,0.95],/normal,$     ; set margins around plot
    xticklen=0.03,yticklen=0.03/plotaspect,$  ; same-length ticks
    xtitle=xtitle,ytitle=ytitle,$
    xrange=xrange,yrange=yrange,$  ; ,ytickinterval=1
    xstyle=1,ystyle=9,linestyle=1 

; overplot temperature with second y-axis on the right
temprange=[4000,7500]
temp=atmos.T
tempscaled=yrange[0]+(temp-temprange[0])/(temprange[1]-temprange[0])*$
   (yrange[1]-yrange[0])
oplot,heightkm,tempscaled,thick=3
; plot dummy axis to get IDL ticks including the zero value
axis,yaxis=1,yrange=temprange,ystyle=1,ytickinterval=1000,$
  ytitle='',ytickname=replicate(' ',60),ytick_get=yaxticks
; replot with labels, now you get the initial zero also
yticknames=string(yaxticks,format='(i5)') 
axis,yaxis=1,yrange=temprange,ystyle=1,ytickinterval=1000,$
  ytitle='temperature  [K]',ytickname=yticknames

; add model name
xyouts,0.5,0.25,/norm,alignment=0.5,modelname

; add line label
xyouts,labelheight,alog10(tau[labelind]),pslinelabel

; add MgIIk at three wavs
linename='MgIIk' & iwavpeak=1 & iwavdip=1  ;; fake other two
@atfindline
readopacity,iwavlc
tau=gettau(height,chi_as+chi_c) 
oplot,heightkm,alog10(tau),linestyle=2
xyouts,labelheight,alog10(tau[labelind]),pslinelabel

;; readopacity,iwavpeak
;; tau=gettau(height,chi_as+chi_c) 
;; oplot,heightkm,alog10(tau),linestyle=2

;; readopacity,iwavdip
;; tau=gettau(height,chi_as+chi_c) 
;; oplot,heightkm,alog10(tau),linestyle=2

; add CaIIK
linename='CaIIK' & iwavpeak=1 & iwavdip=1 ;; fake other two
@atfindline
readopacity,iwavlc
tau=gettau(height,chi_as+chi_c) 
oplot,heightkm,alog10(tau),linestyle=3
xyouts,labelheight,alog10(tau[labelind]),pslinelabel

; add Lya
linename='Lyalpha' & iwavpeak=1 & iwavdip=1 ; fake peak and dip
@atfindline
readopacity,iwavlc
tau=gettau(height,chi_as+chi_c) 
oplot,heightkm,alog10(tau),linestyle=3
xyouts,labelheight,alog10(tau[labelind]),pslinelabel

; oplot line tau=1
xtau0=[xrange[0],xrange[1]]
tau0=[0,0]
oplot,xtau0,tau0,thick=1
xyouts,200,-0.4,'tau = 1'

; close plot
closepsplot,psfilename,opengv=opengv

end
