; file: makefigspectrumneckel.pro = main to produce RH spectrum plot + Neckel
; init: Feb 15 2012 
; note: first runrh on the desired XXX.atmos and XXX.atom RH setup
;       parameter-free except xrange, yrange axis tuning etc

; check or get radial intensity 
if (n_elements(radint) eq 0) then begin
;;  print,' #### run ../solveray first if no file spectrum_1.00'
  radint=readray('spectrum_1.00')
endif

; =================== parameter free from here 

; set wavs
wav1aa=wavlc-wavrange/2.
wav2aa=wavlc+wavrange/2.
wav1nm=wav1aa/10.
wav2nm=wav2aa/10.
wavname=strtrim(string(wavlc),2)

; get emergent spectrum
@spectrum.common
tabinv,spectrum.lambda,wav1nm,iwav1 
tabinv,spectrum.lambda,wav2nm,iwav2 
iwav1=long(iwav1)
iwav2=long(iwav2)
wav1=spectrum.lambda[iwav1]
wav2=spectrum.lambda[iwav2]
rhwav=spectrum.lambda[iwav1:iwav2]
;;rhint=spectrum.i[iwav1:iwav2,4]   ; about 4% too low
rhint=radint.i[iwav1:iwav2]

; open Neckel intensity atlas if not already open
if (addneckel eq 1 and n_elements(neckelwav) eq 0) then begin
  neckelpath='/home/rutten/rr/wrk/atlases/neckel/'
  neckelsave='neckel_intens_atlas.idlsave'
  restore,neckelpath+neckelsave
  ; convert units to J m_2 s-1 Hz-1 ster-1
  clight=299792458.*1D10 ; in AA/s
  neckelint=(neckelwav*neckelwav/clight)*neckelint*1E4
endif

; === make figure

; plot RH spectrum
if (opengv) then spawn,'pkill -s 0 gv'
psfilename='fig-spectrum-'+modelname+'-'+wavname+'.ps'
openpsplot,psfilename,thick=1.5
if (addneckel) then linestyle=1 else linestyle=0
xtitle='wavelength  ['+string(197B)+']'
ytitle='intensity   [J m!U-2!N s!U-1!N Hz!U-1!N sr!U-1!N]'
xrange=[wav1*10,wav2*10]
yrange=[0,max(rhint)*1.05]
plot,rhwav*10+neckelshift,rhint,linestyle=linestyle,$
  position=[0.2,0.2,0.95,0.95],/normal,$     ; set margins around plot
  xticklen=0.03,yticklen=0.03/1.6,$  ; same-length ticks
  xtickformat='(i6)',xrange=xrange,xstyle=1,$
  yrange=yrange,ystyle=1,$
  xtitle=xtitle,ytitle=ytitle

; oplot Neckel profile
if (addneckel) then oplot,neckelwav,neckelint,linestyle=0
  
; add model name
xyouts,0.25,0.25,/norm,modelname

; add run dir
if (addrundir eq 1) then begin
  cd,c=thedir
  lastdir=strsplit(thedir,'/',/extract)
  sizelastdir=size(lastdir)
  xyouts,0.01,0.01,/norm,lastdir[sizelastdir[1]-1]
endif

; close plot
closepsplot,psfilename,opengv=opengv

end
