; file: makefignecontribs.pro = redo VALIII Fig 47b
; init: Mar 27 2020  Rob Rutten  Deil re question Jason Wright
; last: Dec 30 2021  Rob Rutten  Deil
; note: cd to run (maybe on RRHOME)
;       run with @doinitrh   .r makefignecontribs

; copy parts of VALIIIC doinition.pro

; model name for plotlabel and filename
;;modelname='VALIIIC-ltehaze'
;; modelname='ALC7'
;; modelname='Kurucz'
;; modelname='FCHTTB'
;; modelname='T5750-scathaze'
modelname='FALC-scathaze'

opengv=1

; loop over species 0,1,2 = Mg, Fe, Si
for ispecies=0,2 do begin

  print,' ===== ispecies ='+trimd(ispecies)

; ##### adjust nrs of levels below according to atoms.input choices
  
; ======== Mg

; select element, stage, menzel/zwaan
  if (ispecies eq 0) then begin
    ionelement=['MG']      ; capitals as in atom.XX.out
    ionelementname='Mg'    ; for plot entry

; define nr of levels per stage in the model atom (may be zero)
;; ; classic VALIII, FCHHTB
;;       nelemi=65  ;; MgI+II.atom nlevel=76 MgI 0-64  MgII 65-74  MNgIII 76
;;       nelemii=10 
;;       nelemiii=1 

;; ; ALC7, FALC
    nelemi=11  ;; MgI_b+II.atom nlevel=22 MgI 0-10  MgII 11-20  MNgIII 21
    nelemii=10 
    nelemiii=1 
  endif
  
; ====== Fe
  if (ispecies eq 1) then begin
    ionelement=['FE']      ; capitals as in atom.XX.out
    ionelementname='Fe'    ; for plot entry

; classic VALIIIC, FCHHTB  ## doesn't work = absence FeIII? 
   ;; nelemi=15  ; feI.atom nlevel=16  FeI 0-14  FeII 15
   ;; nelemii=1  
   ;; nelemiii=0 

; ALC7, FALC
    nelemi=31  ; Fe33.atom nlevel=33  FeI 0-30  FeII 31 FeIII 32
    nelemii=1  
    nelemiii=1

  endif

; ====== Si
  
; select element, stage, menzel/zwaan
  if (ispecies eq 2) then begin
    ionelement=['SI']      ; capitals as in atom.XX.out
    ionelementname='Si'    ; for plot entry

; ALC7 = VALIIIC new or classic = FCHHTB
    nelemi=14   ; Si.atom nlevel=24 SiI 0-14  SiII 15-22  SiIII 23
    nelemii=8
    nelemiii=1 
  endif

; get atom stuff
  thisatom=readatom('atom.'+ionelement+'.out')
  ntotlevels=thisatom.nlevel
  if (nelemi gt 0) then nelemicont=nelemi-1 else nelemicont=0
  nelemtopcont=ntotlevels-1

; compute NLTE ionization densities
  if (nelemi gt 0) then ni=(*thisatom.n_ptr)[*,0:nelemicont-1] $
  else ni=0
  if (nelemii gt 0) then nii=(*thisatom.n_ptr)[*,nelemicont:nelemtopcont-1] $
  else nii=0
  help,nii
  ntop=(*thisatom.n_ptr)[*,nelemtopcont]
  sizeni=size(ni)
  if (sizeni[0] eq 2) then sumni=total(ni,2) else sumni=ni
  sizenii=size(nii)
  if (sizenii[0] eq 2) then sumnii=total(nii,2) else sumnii=nii

; compute LTE ionization densities
  if (nelemi gt 0) then nistar=(*thisatom.nstar_ptr)[*,0:nelemicont-1] $
  else nistar=0
  if (nelemii gt 0) then $
    niistar=(*thisatom.nstar_ptr)[*,nelemicont:nelemtopcont-1] $
  else niistar=0
  ntopstar=(*thisatom.nstar_ptr)[*,nelemtopcont]
  if (sizeni[0] eq 2) then sumnistar=total(nistar,2) else sumni=nistar
  if (sizenii[0] eq 2) then sumniistar=total(niistar,2) else sumniistar=niistar

; get N_e for ratio to N_e
  nel=atmos.n_elec
  
; make figure
; -----------
  if (ispecies eq 0) then begin
    if (opengv) then spawn,'pkill -s 0 gv'
    psfilename='fig-necontribs-'+modelname+'.ps'
    openpsplot,psfilename,thick=2,xsize=12,ysize=8.
    xtitle='height  [km]'
    ytitle='fraction'
    xrange=[0,800]
    yrange=[0,0.5]
    plot,heightkm,sumnii/nel,$
      position=[0.2,0.2,0.95,0.95],/normal,$     ; set margins around plot
      xticklen=0.03,yticklen=0.03/1.6,$          ; same-length ticks
      xtitle=xtitle,ytitle=ytitle,xstyle=1,ystyle=1,$
      xrange=xrange,yrange=yrange,linestyle=ispecies
  endif
  
; overplot NLTE others
  if (ispecies ne 0) then oplot,heightkm,sumnii/nel,linestyle=ispecies

; overplot LTE results
  oplot,heightkm,sumniistar/nel,linestyle=ispecies
  
; add labels
  ih=where(abs(heightkm-400) eq min(abs(heightkm-400)))
  xyouts,heightkm[ih],sumnii[ih]/nel[ih]+0.01,ionelementname

; add model name
  xyouts,0.25,0.85,/norm,modelname

;;; try  if (ispecies eq 1) then STOP
  
endfor ; loop over ispecies

; close plot
  closepsplot,psfilename,opengv=opengv

end
