; file: makefigmodel.pro = plot RH input model atmosphere
; init: Dec 20 2016  Rob Rutten  Deil
; last: Dec 21 2016  Rob Rutten  Deil
; site: rridl/rhlib
; note: run with @doinitrh, @doinitrr, .r makemodelfig

; ======= parameter-free from here (except label placements at end?)

; start model figure
if (opengv) then spawn,'pkill -s 0 gv'
psfilename='fig-'+modelname+'-model.eps'
openpsplot,psfilename,thick=2
xtitle='height  [km]'
ytitle='temperature  [K]'
if (temprange[1]-temprange[0] lt 5000) then temptickinterval=1000 $
  else if  (temprange[1]-temprange[0] lt 10000) then temptickinterval=2000 $
  else  temptickinterval=5000

; plot temperature against height
eltemp=atmos.T
plot,heightkm,eltemp,$
    position=[0.2,0.2,0.85,0.95],/normal,$     ; set margins around plot
    xticklen=0.03,yticklen=0.03/1.62,$  ; same-length ticks
    xtitle=xtitle,ytitle=ytitle,$
    thick=1,ytickinterval=temptickinterval,$
    xrange=heightrange,xstyle=1,$
    yrange=temprange,ystyle=9

; add model name
xyouts,0.25,0.80,/norm,modelname

; add run dir
if (addrundir eq 1) then begin
  cd,c=thedir
  lastdir=strsplit(thedir,'/',/extract)
  sizelastdir=size(lastdir)
  xyouts,0.01,0.01,/norm,lastdir[sizelastdir[1]-1]
endif

; add density axis at right
axis,yaxis=1,yrange=densrange,ystyle=1,yminor=2,$     
  ytitle=textoidl("log (density)   [cm^{-3}]")

; overplot electron density
nel=alog10(atmos.n_elec*1.E-6)
nelscaled=temprange[0]+(nel-densrange[0]) $
  /(densrange[1]-densrange[0])*(temprange[1]-temprange[0])
oplot,heightkm,nelscaled,linestyle=2

; overplot total hydrogen density
nhtot=alog10(total(atmos.nh,2)*1.E-6)
nhtotscaled=temprange[0]+(nhtot-densrange[0]) $
  /(densrange[1]-densrange[0])*(temprange[1]-temprange[0])
oplot,heightkm,nhtotscaled,linestyle=0

; overplot neutral hydrogen density
nhneu=alog10((total(atmos.nh,2)-atmos.nh[*,9])*1.E-6)
nhneuscaled=temprange[0]+(nhneu-densrange[0]) $
  /(densrange[1]-densrange[0])*(temprange[1]-temprange[0])
oplot,heightkm,nhneuscaled,linestyle=1

;RR more protons than elecrons in FALP - why??
;; ; overplot proton density
;; nhprot=alog10(atmos.nh[*,9]*1.E-6)
;; nhprotscaled=temprange[0]+(nhprot-densrange[0]) $
;;   /(densrange[1]-densrange[0])*(temprange[1]-temprange[0])
;; oplot,heightkm,nhprotscaled,linestyle=1

; add curve labels (vertical offsets in degrees K)
ih=where(abs(heightkm-200) eq min(abs(heightkm-200)))
xyouts,heightkm[ih],eltemp[ih]-500,'T'
xyouts,heightkm[ih],nelscaled[ih]+100,textoidl("N_e")

ih=where(abs(heightkm-1200) eq min(abs(heightkm-1200)))
xyouts,heightkm[ih],eltemp[ih]+300,'T'
xyouts,heightkm[ih],nelscaled[ih]-350.,textoidl("N_e")
xyouts,heightkm[ih],nhneuscaled[ih]-1000.,textoidl("N_{H neutral}")

ih=where(abs(heightkm-1700) eq min(abs(heightkm-1700)))
xyouts,heightkm[ih],nhtotscaled[ih]+100.,textoidl("N_{H total}")

; close plot
closepsplot,psfilename,opengv=opengv

end




