; file: makefigionization.pro = main to produce figure ionization ratio
; init: Feb 19 2012 
; last: Mar 28 2020  Rob Rutten  Deil
; note: run with @doinitrh   @doinition   .r makefigionization
;       this is ratio given stage to total i+ii+iii but one may have zero

; compute ionization fractions
if (nelemi gt 0) then ni=(*thisatom.n_ptr)[*,0:nelemicont-1] $
   else ni=0
if (nelemii gt 0) then nii=(*thisatom.n_ptr)[*,nelemicont:nelemtopcont-1] $
   else nii=0
ntop=(*thisatom.n_ptr)[*,nelemtopcont]
sizeni=size(ni)
if (sizeni[0] eq 2) then sumni=total(ni,2) else sumni=ni
sizenii=size(nii)
if (sizenii[0] eq 2) then sumnii=total(nii,2) else sumnii=nii
sumntop=ntop
tot=sumni+sumnii+sumntop
ratni=sumni/tot
ratnii=sumnii/tot
ratntop=sumntop/tot

; compute LTE ionization fractions
if (nelemi gt 0) then nistar=(*thisatom.nstar_ptr)[*,0:nelemicont-1] $
  else nistar=0
if (nelemii gt 0) then $
  niistar=(*thisatom.nstar_ptr)[*,nelemicont:nelemtopcont-1] $
  else niistar=0
ntopstar=(*thisatom.nstar_ptr)[*,nelemtopcont]
if (sizeni[0] eq 2) then sumnistar=total(nistar,2) else sumni=nistar
if (sizenii[0] eq 2) then sumniistar=total(niistar,2) else sumniistar=niistar
sumntopstar=ntopstar
totstar=sumnistar+sumniistar+sumntopstar
ratnistar=sumnistar/tot
ratniistar=sumniistar/tot
ratntopstar=sumntopstar/tot

; make figure
; -----------
if (opengv) then spawn,'pkill -s 0 gv'
psfilename='fig-ionization-'+modelname+'-'+ionelementname+'.ps'
openpsplot,psfilename,thick=2,xsize=8.,ysize=8./plotaspect 
xtitle='height  [km]'
ytitle=textoidl("log (N_{stage} / N_{total})")
if (n_elements(maxplotheight) eq 0) then maxplotheight=max(heightkm) 
if (maxplotheight eq 0) then maxplotheight=max(heightkm)
xrange=[min(heightkm),maxplotheight]
;;xrange=[-100,2100]  ; popdeps ms
; stage 1 or stage 2
if (nelemi ne 0) then y=alog10(ratni) else y=alog10(ratnii) 
ymin=min(y)
ymax=max(y)
yrange=[ymin-0.1*(ymax-ymin),ymax+0.1*(ymax-ymin)]
yrange=[-5,+0.3]   ; popdeps ms
plot,heightkm,y,$
    position=[0.2,0.2,0.95,0.95],/normal,$     ; set margins around plot
    xticklen=0.03,yticklen=0.03/1.6,$  ; same-length ticks
    xtitle=xtitle,ytitle=ytitle,$
    xrange=xrange,xstyle=1, yrange=yrange,ystyle=1,yminor=1 

; overplot others
if (nelemi ne 0) then oplot,heightkm,alog10(ratnii),linestyle=2
oplot,heightkm,alog10(ratntop),linestyle=3 ; N_ii or N_iii 
if (nelemi ne 0) then oplot,heightkm,alog10(ratnistar),linestyle=1
oplot,heightkm,alog10(ratniistar),linestyle=1 ; LTE dotted
oplot,heightkm,alog10(ratntopstar),linestyle=1 ; LTE dotted

; add labels
ih=where(abs(heightkm-200) eq min(abs(heightkm-200)))
xyouts,heightkm[ih],alog10(ratni[ih])-0.25,'neutral'
ih=where(abs(heightkm-(maxplotheight-400)) eq $
   min(abs(heightkm-(maxplotheight-400))))
xyouts,heightkm[ih],alog10(ratnistar[ih])-0.25,alignment=1,'LTE'
ih=where(abs(heightkm-1300) eq min(abs(heightkm-1300)))
xyouts,heightkm[ih],alog10(ratntop[ih])-0.25,'ion'
ih=where(abs(heightkm-1000) eq min(abs(heightkm-1000)))
xyouts,heightkm[ih],alog10(ratntopstar[ih])+0.25,alignment=1,'LTE'

; add model name
xyouts,0.25,0.75,/norm,modelname

; add element name
xyouts,0.25,0.68,/norm,ionelementname

; add run dir
if (addrundir eq 1) then begin
  cd,c=thedir
  lastdir=strsplit(thedir,'/',/extract)
  sizelastdir=size(lastdir)
  xyouts,0.01,0.01,/norm,lastdir[sizelastdir[1]-1]
endif

; close plot
closepsplot,psfilename,opengv=opengv

end
