; file: makefigintprof.pro = main to produce intensity profile plot + Neckel
; init: Feb  6 2012 
; note: parameter-free except xrange, yrange axis tuning etc

; check or get radial intensity 
if (n_elements(radint) eq 0) then begin
;;  print,' #### run ../solveray first if no file spectrum_1.0'
  radint=readray('spectrum_1.00')
endif

; get emergent spectrum
;; nw=spectrum.nspect ; not needed? Aug 24 2013  
iwav1=thisatom.transition[itrans].nblue         ; line start 
nwav=thisatom.transition[itrans].nlambda        ; nr samples
iwav2=iwav1+nwav
wav1=spectrum.lambda[iwav1]
wav2=spectrum.lambda[iwav2]

; double RH profile if only half is computed 
wavarr=spectrum.lambda[iwav1:iwav2]
;; profarr=spectrum.i[iwav1:iwav2,4]
profarr=radint.i[iwav1:iwav2]
if (iwav1 eq iwavlc) then begin
  wavarr2=reverse(wavlc-(wavarr-wavlc))
  profarr2=reverse(profarr)
  wavarr=[wavarr2,wavarr[1:nwav]]
  profarr=[profarr2,profarr[1:nwav]]
  wav1=wavarr[0]
  wav2=wavarr[2*nwav]
endif

; open Neckel intensity atlas if not already open
if (addneckel eq 1 and n_elements(neckelwav) eq 0) then begin
  neckelpath='/home/rutten/rr/wrk/atlases/neckel/'
  neckelsave='neckel_intens_atlas.idlsave'
  restore,neckelpath+neckelsave
  ; convert units to J m_2 s-1 Hz-1 ster-1
  clight=299792458.*1D10 ; in AA/s ;RR wat een rare schrijfwijze
  neckelint=(neckelwav*neckelwav/clight)*neckelint*1E4
  neckelcont=(neckelwav*neckelwav/clight)*neckelcont*1E4
endif

; === make figure

; plot RH profile
if (opengv) then spawn,'pkill -s 0 gv'
psfilename='fig-intprof-'+modelname+'-'+filelinename+'.ps'
openpsplot,psfilename,thick=1.5
if (addneckel) then linestyle=1 else linestyle=0
xtitle='wavelength  ['+string(197B)+']'
ytitle='intensity   [J m!U-2!N s!U-1!N Hz!U-1!N sr!U-1!N]'
lcoff=wavlc*10+neckelshift
xrange=[lcoff-wavrange/2.,lcoff+wavrange/2.]
yrange=[0,max(profarr)*1.05]
;;yrange=[0,max(profarr)*3.]
plot,wavarr*10+neckelshift,profarr,linestyle=linestyle,$
  position=[0.2,0.2,0.95,0.95],/normal,$     ; set margins around plot
  xticklen=0.03,yticklen=0.03/1.6,$  ; same-length ticks
;;  xtickformat='(i6)',$
  xtickformat='(f8.1)',$
  xrange=xrange,xstyle=1,yrange=yrange,ystyle=1,$
  xtitle=xtitle,ytitle=ytitle

; oplot Neckel profile
if (addneckel) then begin
  oplot,neckelwav,neckelint,linestyle=0
  oplot,neckelwav,neckelcont,linestyle=0
endif

; add model name
xyouts,0.25,0.25,/norm,modelname

; add run dir
if (addrundir eq 1) then begin
  cd,c=thedir
  lastdir=strsplit(thedir,'/',/extract)
  sizelastdir=size(lastdir)
  xyouts,0.01,0.01,/norm,lastdir[sizelastdir[1]-1]
endif

; close plot
closepsplot,psfilename,opengv=opengv

end
