; file: makefigexttau.pro
; init: Feb  8 2012 
; note: first runrh on the desired model
;       adapt dothisrhinit.pro
;       then in new IDL session first @dorhinit
;       parameter-free except xrange, yrange axis tuning etc

; plot line-center opacity, *scaleh to put on good tau scale
if (opengv) then spawn,'pkill -s 0 gv'
psfilename='fig-exttau-'+modelname+'-'+filelinename+'.ps'
openpsplot,psfilename,thick=1.5  
xtitle='height  [km]'
if (n_elements(maxplotheight) eq 0) then maxplotheight=max(heightkm) 
if (maxplotheight eq 0) then maxplotheight=max(heightkm)
xrange=[min(heightkm),maxplotheight]
expscaleh=strmid(string(alog10(scaleh),format='(i2)'),1) 
ytitle='log (10!u'+expscaleh+'!N'+textoidl("\alpha_\nu)     log (\tau_\nu)")
y=alog10(chi_as*scaleh)
ymin=min(y)
ymax=max(y)
yrange=[ymin-0.1*(ymax-ymin),ymax+0.1*(ymax-ymin)]
plot,heightkm,y,$  
    position=[0.2,0.2,0.95,0.95],/normal,$     ; set margins around plot
    xticklen=0.03,yticklen=0.03/1.6,$  ; same-length ticks
    xtitle=xtitle,ytitle=ytitle,$
    xrange=xrange,xstyle=1,yrange=yrange,ystyle=1

; oplot LTE opacity
nlow=(*thisatom.n_ptr)[*,ilow] 
nstarlow=(*thisatom.nstar_ptr)[*,ilow] 
blow=nlow/nstarlow
oplot,heightkm,alog10(chi_as*scaleh/blow),linestyle=3

; oplot continuum opacity
oplot,heightkm,alog10(chi_c*scaleh),linestyle=0

xyouts,heightkm[45],alog10(chi_as[45]*scaleh)+0.1*(ymax-ymin),'line center'
xyouts,heightkm[45],alog10(chi_c[45]*scaleh)-0.1*(ymax-ymin),'continuum'

; oplot tau_line center on proper scale
taulc=fltarr(nh)
taulc=gettau(height,chi_as+chi_c)   ; getTau in readopacity.pro
oplot,heightkm,alog10(taulc),linestyle=1

; oplot ticks
tabinv,taulc,[0.3,1.0,3.0],tau_eff
xtau=linear(heightkm,tau_eff)
ytau=alog10(linear(taulc,tau_eff))
ydash=(yrange[1]-yrange[0])/20.
for itau=0,2 do begin
  xtick=[xtau[itau],xtau[itau]]
  ytick=[ytau[itau]-ydash,ytau[itau]+ydash]
  oplot,xtick,ytick
endfor

; oplot tau_cont
tauc=fltarr(nh)
tauc=gettau(height,chi_c)   ; getTau in readopacity.pro
oplot,heightkm,alog10(tauc),linestyle=1

; oplot ticks - see popdeps/uitenbroek/BSJ_Halpha.pro
tabinv,tauc,[0.3,1.0,3.0],tau_eff
xtau=linear(heightkm,tau_eff)
ytau=alog10(linear(tauc,tau_eff))
ydash=(yrange[1]-yrange[0])/20.
for itau=0,2 do begin
  xtick=[xtau[itau],xtau[itau]]
  ytick=[ytau[itau]-ydash,ytau[itau]+ydash]
  oplot,xtick,ytick
endfor

; add model name
xyouts,0.25,0.32,/norm,modelname

; add line name
xyouts,0.25,0.25,/norm,pslinelabel

; add run dir
if (addrundir eq 1) then begin
  cd,c=thedir
  lastdir=strsplit(thedir,'/',/extract)
  sizelastdir=size(lastdir)
  xyouts,0.01,0.01,/norm,lastdir[sizelastdir[1]-1]
endif

; close plot
closepsplot,psfilename,opengv=opengv

end
