; file: makefigbetasline.pro = main to produce departure coefficient figure
; init: Feb  7 2012 
; last: Apr 10 2015  Rob Rutten  Deil
; note: first runrh on the desired XXX.atmos and XXX.atom RH setup
;       adapt dothisrhinit.pro
;       then in new IDL session first @dorhinit
;       parameter-free except xrange, yrange axis tuning etc

; get populations, compute departure coefficients
nlow=(*thisatom.n_ptr)[*,ilow] 
nstarlow=(*thisatom.nstar_ptr)[*,ilow] 
nupp=(*thisatom.n_ptr)[*,jupp] 
nstarupp=(*thisatom.nstar_ptr)[*,jupp] 
blow=nlow/nstarlow
bupp=nupp/nstarupp

; make betas figure
; -----------------
if (opengv) then spawn,'pkill -s 0 gv'
psfilename='fig-betas-'+modelname+'-'+filelinename+'.ps'
openpsplot,psfilename,thick=2,xsize=8.,ysize=8./plotaspect
xtitle='height  [km]'
ytitle='log  b'
logbl=alog10(blow)
logbu=alog10(bupp)
;; xrange=[-100,2100]
if (n_elements(maxplotheight) eq 0) then maxplotheight=max(heightkm) 
if (maxplotheight eq 0) then maxplotheight=max(heightkm)
xrange=[min(heightkm),maxplotheight]
ymin=min([[logbl],[logbu]])
ymax=max([[logbl],[logbu]]) 
yrange=[ymin-0.1*(ymax-ymin),ymax+0.1*(ymax-ymin)]
;;yrange=[-0.6,+2.0]
plot,heightkm,logbl,$
    position=[0.2,0.2,0.95,0.95],/normal,$     ; set margins around plot
    xticklen=0.03,yticklen=0.03/plotaspect,$   ; same-length ticks
    xtitle=xtitle,ytitle=ytitle,$
    xrange=xrange,xstyle=1, yrange=yrange,ystyle=1 ; ,ytickinterval=1
oplot,heightkm,logbu,linestyle=2

; add line tau ticks on b_low curve
tau=fltarr(nh)
tau=gettau(height,chi_as+chi_c)   ; getTau in readopacity.pro
tabinv,tau,[0.3,1.0,3.0],tau_eff
xtau=linear(heightkm,tau_eff)
ytau=linear(logbl,tau_eff)
ydash=(yrange[1]-yrange[0])/20.
for itau=0,2 do begin
  xtick=[xtau[itau],xtau[itau]]
  ytick=[ytau[itau]-0.10,ytau[itau]+0.10]
  ytick=[ytau[itau]-ydash,ytau[itau]+ydash]
  oplot,xtick,ytick
endfor

; add model name
xyouts,0.25,0.85,/norm,modelname

; add line name
xyouts,0.25,0.78,/norm,pslinelabel

; add run dir
if (addrundir eq 1) then begin
  cd,c=thedir
  lastdir=strsplit(thedir,'/',/extract)
  sizelastdir=size(lastdir)
  xyouts,0.01,0.01,/norm,lastdir[sizelastdir[1]-1]
endif

; close plot
closepsplot,psfilename,opengv=opengv

end
