; file: makefigbetasextratio.pro = main
; init: Apr 10 2015  Rob Rutten  Deil from makefigbetaslinefrac.pro
; last: Apr 16 2015  Rob Rutten  Deil
; note: first runrh on the desired XXX.atmos and XXX.atom RH setup
;       adapt dothisrhinit.pro
;       then in new IDL session first @dorhinit
;       parameter-free except xrange, yrange axis tuning etc

; get populations, compute departure coefficients
nlow=(*thisatom.n_ptr)[*,ilow] 
nstarlow=(*thisatom.nstar_ptr)[*,ilow] 
nupp=(*thisatom.n_ptr)[*,jupp] 
nstarupp=(*thisatom.nstar_ptr)[*,jupp] 
blow=nlow/nstarlow
bupp=nupp/nstarupp

; make betas figure
; -----------------
if (opengv) then spawn,'pkill -s 0 gv'
psfilename='fig-betas-'+modelname+'-'+filelinename+'.ps'
openpsplot,psfilename,thick=2,xsize=8.,ysize=8./plotaspect
xtitle='height  [km]'
ytitle='log  b'
logbl=alog10(blow)
logbu=alog10(bupp)
;; xrange=[-100,2100]
if (n_elements(maxplotheight) eq 0) then maxplotheight=max(heightkm) 
if (maxplotheight eq 0) then maxplotheight=max(heightkm)
xrange=[min(heightkm),maxplotheight]
ymin=min([[logbl],[logbu]])
ymax=max([[logbl],[logbu]]) 
yrange=[ymin-0.1*(ymax-ymin),ymax+0.1*(ymax-ymin)]
yrange=[-1.0,+2.0]
plot,heightkm,logbl,$
    position=[0.2,0.2,0.85,0.95],/normal,$     ; set margins around plot
    xticklen=0.03,yticklen=0.03/plotaspect,$   ; same-length ticks
    xtitle=xtitle,ytitle=ytitle,ytickinterval=1,$
    xrange=xrange,xstyle=1, yrange=yrange,ystyle=9 ; ,ytickinterval=1
oplot,heightkm,logbu,linestyle=2

; add line tau ticks on b_low curve
tau=fltarr(nh)
tau=gettau(height,chi_as+chi_c)   ; getTau in readopacity.pro
tabinv,tau,[0.3,1.0,3.0],tau_eff
xtau=linear(heightkm,tau_eff)
ytau=linear(logbl,tau_eff)
ydash=(yrange[1]-yrange[0])/20.
for itau=0,2 do begin
  xtick=[xtau[itau],xtau[itau]]
  ytick=[ytau[itau]-0.10,ytau[itau]+0.10]
  ytick=[ytau[itau]-ydash,ytau[itau]+ydash]
  oplot,xtick,ytick
endfor

; add model name
xyouts,0.25,0.85,/norm,modelname

; add line name
xyouts,0.25,0.78,/norm,pslinelabel

; add run dir
if (addrundir eq 1) then begin
  cd,c=thedir
  lastdir=strsplit(thedir,'/',/extract)
  sizelastdir=size(lastdir)
  xyouts,0.01,0.01,/norm,lastdir[sizelastdir[1]-1]
endif

;; ; Apr 10 2015 add dotted curve population fraction
;; ; ------------------------------------------------
;; ; sum all pops to find total population (= density/abundance or such) 
;; ntotlevels=thisatom.nlevel
;; sumpop=(*thisatom.n_ptr)[*,0] 
;; for ilevel=1,ntotlevels-1 do sumpop=sumpop+(*thisatom.n_ptr)[*,ilevel] 
;; ; get fraction
;; fracpop=nlow/sumpop
;; ; find index for h=0
;; indh0=where(abs(heightkm) eq min(abs(heightkm)))
;; normzero=fracpop[indh0[0]]  ; bloody IDL array > scalar 
;; norm=normzero[0]
;; offset=1.5
;; normfrac=alog10(fracpop/norm)+offset
;; oplot,heightkm,normfrac,linestyle=1

;; ; Apr 29 2015 add fraction axis on right (Jorrit suggestion)
;; fracrange=[(alog10(norm)-offset)+yrange[0],(alog10(norm)-offset)+yrange[1]]
;; axis,yaxis=1,yrange=fracrange,ystyle=1,ytickinterval=1,$
;;   ytitle=textoidl("log (fraction)")

; Jun  3 2015 HAO add not population fraction but line/cont extinction ratio
logext=alog10(chi_as/chi_c)
; find index for h=0
indh0=where(abs(heightkm) eq min(abs(heightkm)))
normzero=logext[indh0[0]]  ; bloody IDL array > scalar 
norm=normzero[0]
offset=0.
extspan=2.
extrange=[2,9]
normext=(logext-extrange[0])*(yrange[1]-yrange[0])/(extrange[1]-extrange[0])$
  +yrange[0]
oplot,heightkm,normext,linestyle=1

; add axis righthandside
axis,yaxis=1,yrange=extrange,ystyle=1,ytickinterval=1,$
  ytitle=textoidl("log (extinction ratio)")

; close plot
closepsplot,psfilename,opengv=opengv

end


