; file: makefigbetasstage.pro = main to produce departure coefficient figure
; init: Nov 14 2016  Rob Rutten  Deil from makefigbetasstage.pro 
; last: Nov 14 2016  Rob Rutten  Deil
; note: run with @doinitrh, .r  makefigbetasedges


; ========== parameter settings

; file name and plot labels
modelname='ALC7'
psfilename='fig-betas-'+modelname+'-edges.ps'

; element and level selection
elements=['H','MG','FE','SI','AL']  ; caps as in atom.XX.out
lowlevels=[1,0,0,0,0]
contlevels=[9,11,31,15,9]   ; look up in used atom files
curvelabels=['H','Mg','Fe','Si','Al']

; axis stuff 
xrange=[-100.,2300.]   ; standard ALC7 for ssx 
xrange=[-20,1280]
xtickinterval=200
xminor=2
yrange=[-2,+2]  ; ALC7
yrange=[-1.2,+2.5]

; define gv opening or not (=1 for new; =0 to keep size if resized)
opengv=1

; =========== end parameter part except label placement below

; check sizes
nelements=n_elements(elements)
nlow=n_elements(lowlevels)
ncont=n_elements(contlevels)
nlabels=n_elements(curvelabels)
if (nelements ne nlow or nelements ne ncont or nelements ne nlabels) $
then begin
  print,' ####### abort: nelements, nlow, ncont, nlabels inequal'
  return
endif

; plot setup
openpsplot,psfilename,thick=3
xtitle='height  [km]'
ytitle=textoidl("log (b/b_{cont})")

; --------- loop over curves 

n=fltarr(nh,2)
nstar=fltarr(nh,2)
b=fltarr(nh,2)
lograt=fltarr(nh)


for icurve=0,nelements-1 do begin

thisatom=readatom('atom.'+elements[icurve]+'.out')

; get departure coefficient ratio (works only for neutral stages)
for ilevel=0,1 do begin
  if (ilevel eq 0) then level=lowlevels[icurve]
  if (ilevel eq 1) then level=contlevels[icurve]
  n[*,ilevel]=(*thisatom.n_ptr)[*,level] 
  nstar[*,ilevel]=(*thisatom.nstar_ptr)[*,level]
  b[*,ilevel]=n[*,ilevel]/nstar[*,ilevel]
  if (ilevel eq 1) then lograt[*]=alog10(b[*,0]/b[*,1])
endfor

; make betas figure
; -----------------
if (opengv) then spawn,'pkill -s 0 gv'
if (icurve eq 0) then plot,heightkm,lograt,$
    position=[0.2,0.2,0.95,0.95],/normal,$     ; set margins around plot
    xticklen=0.03,yticklen=0.03/1.6,$  ; same-length ticks
    xtitle=xtitle,ytitle=ytitle,$
    xtickinterval=xtickinterval,xminor=xminor,$
    xrange=xrange,xstyle=1, yrange=yrange,ystyle=1,yminor=1 

; overplot other curve
if (icurve gt 0) then oplot,heightkm,lograt

; add curve label ## VERY manually 
ih1=115
ih2=96
if (icurve eq 0) then begin
  xyouts,300,lograt[ih1]+0.1,curvelabels[icurve]
  xyouts,heightkm[ih2],lograt[ih2]-0.3,curvelabels[icurve]
endif
if (icurve eq 3) then $
  xyouts,300,lograt[ih1]+0.1,curvelabels[icurve]
if (icurve eq 2) then $
  xyouts,heightkm[ih2],lograt[ih2]+0.1,curvelabels[icurve]
if (icurve eq 3) then $
  xyouts,heightkm[ih2],lograt[ih2]+0.1,curvelabels[icurve]
if (icurve eq 1) then $
  xyouts,heightkm[ih2+1],lograt[ih2]-0.3,$
    curvelabels[icurve]+' '+ curvelabels[4]

; add model name
if (icurve eq 0) then xyouts,0.25,0.85,/norm,modelname

endfor ; end loop over curves

; close plot
closepsplot,psfilename,opengv=opengv

end
