; file: makefigalphacont.pro = main to produce RH alpha_cont plot Vienna
; init: May 13 2019  Rob Rutten  Deil
; last: May 14 2019  Rob Rutten  Deil
; note: IDL in terminal in RH run dir:   @doinitrh   .r makefigalphacont

; set parameters
writelines=0 ; 1 in run dir with lines, 0 in rundir without lines
psfilename='FALC-alphacont.ps'  
xrange=[2.6,4.9]    ; log wavelength [AA]
yrange=[-14,+2]     ; log alpha^cont [cm-1]
heights=[0,500,1000,1500,2000]

; ------------- parameter-free from here

; get wavs
wavs=spectrum.lambda*10.
nwavs=n_elements(wavs)
extcont=fltarr(nwavs)
extcont=fltarr(nwavs)

; loop over sample height
nh=n_elements(heights)
for ih=0,nh-1 do begin
  iheight=where(min(abs(heightkm-heights[ih])) eq abs(heightkm-heights[ih]))
  iheight=round(iheight[0])

; get wavs and continuum extinction at this sample height
  for iwav=0l,nwavs-1 do begin
    readopacity,iwav
    extcont[iwav]=chi_c[iheight]*1.E-2  ; from per m to per cm
    if (ih eq 0) then extcont[iwav]=(chi_c[iheight]+chi_as[iheight])*1.E-2 
  endfor

; ih=0: add all background lines (Kurucz lines and passive-atom lines)
; ih>0: clean continua
  if (ih eq 0) then begin 
    if (writelines eq 1) then begin
      writecol,'/tmp/alphacontlines.dat',wavs,extcont,fmt='(2E15.3)'
      plot,alog10(wavs),alog10(extcont)
      goto,DONE
    endif else readcol,'/tmp/alphacontlines.dat',wavs0,extcont0
  endif
  
; make or add to plot
    if (ih eq 0) then begin
      axrat=1.
      axrat=1.6
      openpsplot,psfilename,thick=2,fontsize=7,xsize=8.8,ysize=8.8/axrat
      !p.thick=1                    ; curves
      angstrom=cgsymbol("angstrom") ; Coyote cg, probably most robust
      xtitle=textoidl("log \lambda")+' ['+angstrom+']'
      ytitle=textoidl("log \alpha_\lambda")+' ['+textoidl("cm^{-1}")+']'
      plot,alog10(wavs0),alog10(extcont0),$
        position=[0.15,0.15,0.95,0.95],/normal,$        ; margins
        xticklen=0.03,yticklen=0.03/axrat,$             ; same-length ticks
        xtitle=xtitle,ytitle=ytitle,$
        xrange=xrange,xstyle=1,yrange=yrange,ystyle=1
    endif else oplot,alog10(wavs),alog10(extcont)
    
  endfor ; end loop over heights

  closepsplot,psfilename,opengv=0

DONE:

end

