; file: makefig_H_betas.pro 
; init: Dec 21 2016  Rob Rutten  Deil from makefigHbetasssx.pro
; last: Nov 11 2016  Rob Rutten  Deil
; note: @doinitrh, @doinitrr, .r makefig_H_betas

; next depend on H atom used
levelselection=[0,1,2,9]
nelemicont=9
lowlevel=1 

; ======= parameter-free from here (except label placements?)

; start figure
psfilename='fig-H-betas-'+modelname+'.eps'
openpsplot,psfilename,thick=2
xtitle='height  [km]'
ytitle='log b'

; select element, stage, menzel/zwaan
ionelement=['H']      ; capitals as in atom.XX.out
ionelementname='H'    ; for plot entry
ionstage=0             ; 0 = neutral atom; 1 = ion
menzel=0               ; 1 for Menzel definition instead of Zwaan

; define nr of levels per stage in the model atom (may be zero)
nelemi=10     ; nr neutral stage levels
nelemii=0    ; nr ion levels
nelemiii=0    ; nr 2nd ion levels

; get populations, compute departure coefficients
sizelevelselec=size(levelselection)
nlevels=sizelevelselec[1]
n=fltarr(nh,nlevels)
nstar=fltarr(nh,nlevels)
b=fltarr(nh,nlevels)
for ilevel=0,nlevels-1 do begin
  level=levelselection[ilevel]
  n[*,ilevel]=(*thisatom.n_ptr)[*,level+ionstage*nelemicont] 
  nstar[*,ilevel]=(*thisatom.nstar_ptr)[*,level+ionstage*nelemicont]
  b[*,ilevel]=n[*,ilevel]/nstar[*,ilevel]
endfor

; compute Menzel format
if (menzel eq 1) then begin
  if (ionstage eq 0) then begin
    ncont=(*thisatom.n_ptr)[*,nelemicont]
    nstarcont=(*thisatom.nstar_ptr)[*,nelemicont]
  endif
  if (ionstage eq 1) then begin
    ncont=(*thisatom.n_ptr)[*,nelemiicont]
    nstarcont=(*thisatom.nstar_ptr)[*,nelemiicont]
  endif
  for ilevel=0,nlevels-1 do b[*,ilevel]=b[*,ilevel]/(ncont/nstarcont)
endif

; make betas figure
; -----------------
if (opengv) then spawn,'pkill -s 0 gv'
if (ionstage eq 0) then stagename='I' 
if (ionstage eq 1) then stagename='II'
psfilename='fig-H-betas-frac-'+modelname+'.eps'
openpsplot,psfilename,thick=2
xtitle='height'
ytitle='log  b'
logb=alog10(b)
plot,heightkm,logb[*,0],$
    position=[0.2,0.2,0.85,0.95],/normal,$     ; set margins around plot
    xticklen=0.03,yticklen=0.03/1.62,$  ; same-length ticks
    xtitle=xtitle,ytitle=ytitle,$
    xrange=heightrange,xstyle=1, yrange=betarange,ystyle=9,yminor=2

; overplot others
for ilevel=1,nlevels-1 do oplot,heightkm,logb[*,ilevel]

; add model name
xyouts,0.25,0.85,/norm,modelname

; add element name
xyouts,0.25,0.78,/norm,ionelementname+' '+stagename

; add run dir
if (addrundir eq 1) then begin
  cd,c=thedir
  lastdir=strsplit(thedir,'/',/extract)
  sizelastdir=size(lastdir)
  xyouts,0.01,0.01,/norm,lastdir[sizelastdir[1]-1]
endif

; add dotted curves population fractions as in makefigbetaslinefrac.pro
; ------------------------------------------------
; sum all pops to find total population (= density/abundance or such) 
nlow=n[*,lowlevel] 
nlowstar=nstar[*,lowlevel]
ntotlevels=thisatom.nlevel
sumpop=(*thisatom.n_ptr)[*,0] 
for ilevel=1,ntotlevels-1 do sumpop=sumpop+(*thisatom.n_ptr)[*,ilevel] 
; get fraction
fracpop=nlow/sumpop

; rescale 
fracrange=[-13,-6]  ;; fixed choice for hydrogen (no longer shift)
normfrac=betarange[0]+$
  (alog10(fracpop)-fracrange[0])/(fracrange[1]-fracrange[0])*$
  (betarange[1]-betarange[0])
oplot,heightkm,normfrac,linestyle=2

; add LTE curve 
fracpopstar=nlowstar/sumpop
;; normfracstar=alog10(fracpopstar/norm)+offset
normfracstar=betarange[0]+$
  (alog10(fracpopstar)-fracrange[0])/(fracrange[1]-fracrange[0])*$
  (betarange[1]-betarange[0])
oplot,heightkm,normfracstar,linestyle=1

; add fraction axis on right (Jorrit suggestion)
axis,yaxis=1,yrange=fracrange,ystyle=1,ytickinterval=2,$
  ytitle=textoidl("log (fraction)"),yminor=2

; ========== add level labels (tricky placement)  
temp=atmos.T
ihmin=where(temp eq min(temp))
ih=ihmin[0]  ; fuck IDL
for ilevel=0,nlevels-2 do xyouts,heightkm[ih],logb[ih,ilevel],trim(ilevel+1)
xyouts,heightkm[ih],logb[ih,nlevels-1]+0.2,alignment=0.5,'cont'

ih=where(abs(heightkm-1000) eq min(abs(heightkm-1000)))
for ilevel=0,nlevels-2 do xyouts,heightkm[ih],logb[ih,ilevel],trim(ilevel+1)
xyouts,heightkm[ih],logb[ih,nlevels-1]-0.5,alignment=0.5,'cont'

ih=where(abs(heightkm-1600) eq min(abs(heightkm-1600)))
for ilevel=0,nlevels-2 do xyouts,heightkm[ih],logb[ih,ilevel],trim(ilevel+1)
xyouts,heightkm[ih],logb[ih,nlevels-1]-0.5,alignment=0.5,'cont'

;; xyouts,1800,0.4,'1'
;; xyouts,1800,-0.4,'2'
;; xyouts,1250,-0.6,'3'
;; xyouts,1000,-1.4,'cont'
;; xyouts,400,0.7,'cont'
;; xyouts,500,-0.4,'1'

;; ;RR for run_2012_FCHHTB
;; ; add label level n (starting at 1; cont special)
;; for ilevel=1,nlevels-2 do xyouts,heightkm[57],logb[57,ilevel]+0.,$
;;   string(levelselection[ilevel]+1,format='(i3)')
;; for ilevel=0,nlevels-2 do xyouts,heightkm[41],logb[41,ilevel]+0.,$
;;   string(levelselection[ilevel]+1,format='(i1)')
;; ilevel=0
;;  xyouts,heightkm[60],logb[60,ilevel]+0.,$
;;   string(levelselection[ilevel]+1,format='(i3)')
;; ; label cont
;; ilevel=nlevels-1
;; xyouts,heightkm[57],logb[57,ilevel]+0.2,'cont'
;; xyouts,heightkm[46],logb[46,ilevel]-0.7,'cont'

; close plot
closepsplot,psfilename,opengv=opengv


end
