; file: makefig_H_SBJ.pro
; init: Dec 21 2016  Rob Rutten  Deil = from older makefigHSBJssx.pro
; last: Dec 21 2016  Rob Rutten  Deil
; note: @dointrh, @doinitrr, .r makefig_H_SBJ

; ======= parameter-free from here (except label placements?)

; start figure
if (opengv) then spawn,'pkill -s 0 gv'
psfilename='fig-H-SBJtemp-'+modelname+'.eps'
openpsplot,psfilename,thick=2
xtitle='height  [km]'
ytitle='B, S, J  [K]'
if (temprange[1]-temprange[0] lt 5000) then temptickinterval=1000 $
else if  (temprange[1]-temprange[0] lt 10000) then temptickinterval=2000 $
else  temptickinterval=5000

; plot temperature against height
eltemp=atmos.T
plot,heightkm,eltemp,$
  position=[0.2,0.2,0.85,0.95],/normal,$     ; set margins around plot
  xticklen=0.03,yticklen=0.03/1.62,$         ; same-length ticks
  xtitle=xtitle,ytitle=ytitle,$
  thick=1,ytickinterval=temptickinterval,$
  xrange=heightrange,xstyle=1,$
  yrange=temprange,ystyle=1

; add model name
xyouts,0.28,0.85,/norm,modelname

; add element name
xyouts,0.28,0.78,/norm,'H I'

; add run dir
if (addrundir eq 1) then begin
  cd,c=thedir
  lastdir=strsplit(thedir,'/',/extract)
  sizelastdir=size(lastdir)
  xyouts,0.01,0.01,/norm,lastdir[sizelastdir[1]-1]
endif


; #################
; start with Halpha 
; #################

; ##### cut-and-paste parts of findline.pro for use within program

linename='Halpha'

; copy of Halpha specification in findline.pro
if (linename eq 'Halpha') then begin 
  filelinename='Halpha'  & pslinelabel='H '+greek("alpha") 
  element='H' & linewav=656.37  
  neckelshift=-0.008
  wavrange=75 & betarange=betarange & temprange=temprange  
endif 

; #### = cut-and-paste from findline.pro bottom part
; get RH line stuff 
nrtrans=0
text=' - elem,itrans,i,j,wavnr,wavair,wavvac ='
thisatom=readatom('atom.'+element+'.out')
ntr=thisatom.nline+thisatom.ncont
for itr=0,ntr-1 do $
  if (abs(thisatom.transition[itr].lambda0-linewav) lt transinterval) $
  then begin
    wavlc=thisatom.transition[itr].lambda0
    tabinv,spectrum.lambda,wavlc,iwavlc
    itrans=itr
    nrtrans=nrtrans+1
    iwavlc=long(iwavlc+0.1)
    ilow=thisatom.transition[itr].i
    jupp=thisatom.transition[itr].j
    if (thisatom.transition[itrans].shape eq 2) then PRD=1 else PRD=0
    if (PRD) then begin
      wavpeak=wavlc+delwavpeak
      iwavpeak=where(abs(spectrum.lambda-wavpeak) eq $
        min(abs(spectrum.lambda-wavpeak)))
      wavdip=wavlc+delwavdip
      iwavdip=where(abs(spectrum.lambda-wavdip) eq $
        min(abs(spectrum.lambda-wavdip)))
      wavwing=wavlc+delwavwing
      iwavwing=where(abs(spectrum.lambda-wavwing) eq $
        min(abs(spectrum.lambda-wavwing)))
    endif
    if (transprint) then print,text,element,itr,$
      ilow,jupp,iwavlc,wavlc,airtovacuum(wavlc),$
      format='(A43, A3, I5, I3, I3, I7, F9.3, F9.3)'
  endif
if (nrtrans eq 0) then print,' ### FINDLINE.PRO: no line found'
if (nrtrans gt 1 and transprint eq 0) then $
    print,' ### FINDLINE.PRO: multiple lines found'
; end cut-and-paste from findline.pro

readopacity,iwavlc

; if PRD then large loop over 3 sample wavs, otherwise line center only
if (PRD) then iwavarr=[iwavlc,iwavpeak,iwavdip] else iwavarr=[iwavlc]
sizeiwavarr=size(iwavarr)
for iw=0,sizeiwavarr[1]-1 do begin
  iwavplot=iwavarr[iw]
  wavplot=spectrum.lambda[iwavplot] 

; compute J_bar = R_lu/B_lu (holds also for PRD)
  @constants_si.idl
  Rlu=*thisatom.transition[itrans].Rij_ptr
  gl=thisatom.g[ilow]
  gu=thisatom.g[jupp]
  Aul=thisatom.transition[itrans].strength
  Blu=(gu/gl)*Aul*(wavlc*nm_to_m)^3/(2.*hplanck*clight)
  Jbar=Rlu/Blu

; compute various source functions
  readj,iwavplot
  readopacity,iwavplot
  Sline=eta_as/chi_as    
  Stotal=(eta_as + eta_c + J*scatt) / (chi_c + chi_as)
  if (PRD) then Jplot=J else Jplot=Jbar ; monochromatic or freq average

; convert into formal temperature
  exctemp=brighttemp(wavlc,Sline,/Hz)
  tottemp=brighttemp(wavlc,Stotal,/Hz)
  radtemp=brighttemp(wavlc,Jplot,/Hz)
  if (PRD) then bartemp=brighttemp(wavlc,Jbar,/Hz)

; overplot these
oplot,heightkm,exctemp,linestyle=1   ; dotted, S^l
oplot,heightkm,radtemp,linestyle=2   ; dashed, J_bar or J

; add tau ticks
  tau=fltarr(nh)
  tau=gettau(height,chi_as+chi_c)   ; getTau in readopacity.pro
  valtau=[0.3,1.0,3.0]
  tabinv,tau,valtau,tau_eff
  ytau=linear(exctemp,tau_eff)
  xtau=linear(heightkm,tau_eff)
  ydash=(temprange[1]-temprange[0])/20.
  for itau=0,2 do begin
    xtick=[xtau[itau],xtau[itau]]
    ytick=[ytau[itau]-0.10,ytau[itau]+0.10]
    ytick=[ytau[itau]-ydash,ytau[itau]+ydash]
    oplot,xtick,ytick
  endfor

; end big loop over wavs for this line
endfor

; add curve labels (improve?)
ih=where(abs(heightkm-1000) eq min(abs(heightkm-1000)))
xyouts,heightkm[ih],eltemp[ih]+300,'B'
ih=where(abs(heightkm-1400) eq min(abs(heightkm-1400)))
xyouts,heightkm[ih],radtemp[ih]+200,textoidl("S, J  H \alpha"),charsize=0.9


; ##################
; REPEAT for Lyalpha
; ##################

; get RH line stuff = taken from initline.pro
linename='Lyalpha' 

; Lyalpha
if (linename eq 'Lyalpha') then begin
  filelinename='Lyalpha'  & pslinelabel='Ly '+greek("alpha")
  element='H' & linewav=121.5
  delwavpeak=0.015 & delwavdip=0.04 & delwavwing=0.2  ; PRD
  addneckel=0
  wavrange=170 & betarange=betarange & temprange=temprange 
endif 

; #### = cut-and-paste from findline.pro bottom part
; get RH line stuff 
nrtrans=0
text=' - elem,itrans,i,j,wavnr,wavair,wavvac ='
thisatom=readatom('atom.'+element+'.out')
ntr=thisatom.nline+thisatom.ncont
for itr=0,ntr-1 do $
  if (abs(thisatom.transition[itr].lambda0-linewav) lt transinterval) $
  then begin
    wavlc=thisatom.transition[itr].lambda0
    tabinv,spectrum.lambda,wavlc,iwavlc
    itrans=itr
    nrtrans=nrtrans+1
    iwavlc=long(iwavlc+0.1)
    ilow=thisatom.transition[itr].i
    jupp=thisatom.transition[itr].j
    if (thisatom.transition[itrans].shape eq 2) then PRD=1 else PRD=0
    if (PRD) then begin
      wavpeak=wavlc+delwavpeak
      iwavpeak=where(abs(spectrum.lambda-wavpeak) eq $
        min(abs(spectrum.lambda-wavpeak)))
      wavdip=wavlc+delwavdip
      iwavdip=where(abs(spectrum.lambda-wavdip) eq $
        min(abs(spectrum.lambda-wavdip)))
      wavwing=wavlc+delwavwing
      iwavwing=where(abs(spectrum.lambda-wavwing) eq $
        min(abs(spectrum.lambda-wavwing)))
    endif
    if (transprint) then print,text,element,itr,$
      ilow,jupp,iwavlc,wavlc,airtovacuum(wavlc),$
      format='(A43, A3, I5, I3, I3, I7, F9.3, F9.3)'
  endif
if (nrtrans eq 0) then print,' ### FINDLINE.PRO: no line found'
if (nrtrans gt 1 and transprint eq 0) then $
    print,' ### FINDLINE.PRO: multiple lines found'
; end cut-and-paste from findline.pro

readopacity,iwavlc

; if PRD then large loop over 3 sample wavs, otherwise line center only
if (PRD) then iwavarr=[iwavlc,iwavpeak,iwavdip] else iwavarr=[iwavlc]
sizeiwavarr=size(iwavarr)
for iw=0,sizeiwavarr[1]-1 do begin
  iwavplot=iwavarr[iw]
  wavplot=spectrum.lambda[iwavplot] 

; compute J_bar = R_lu/B_lu (holds also for PRD)
  @constants_si.idl
  Rlu=*thisatom.transition[itrans].Rij_ptr
  gl=thisatom.g[ilow]
  gu=thisatom.g[jupp]
  Aul=thisatom.transition[itrans].strength
  Blu=(gu/gl)*Aul*(wavlc*nm_to_m)^3/(2.*hplanck*clight)
  Jbar=Rlu/Blu

; compute various source functions
  readj,iwavplot
  readopacity,iwavplot
  Sline=eta_as/chi_as    
  Stotal=(eta_as + eta_c + J*scatt) / (chi_c + chi_as)
  if (PRD) then Jplot=J else Jplot=Jbar ; monochromatic or freq average

; convert into formal temperature
  exctemp=brighttemp(wavlc,Sline,/Hz)
  tottemp=brighttemp(wavlc,Stotal,/Hz)
  radtemp=brighttemp(wavlc,Jplot,/Hz)
  if (PRD) then bartemp=brighttemp(wavlc,Jbar,/Hz)

; overplot these
oplot,heightkm,exctemp,linestyle=1   ; dotted, S^l
oplot,heightkm,radtemp,linestyle=2   ; dashed, J_bar or J

;RR too confusing from PRD - ticks too deep
;; ; add tau ticks
;;   tau=fltarr(nh)
;;   tau=gettau(height,chi_as+chi_c)   ; getTau in readopacity.pro
;;   valtau=[0.3,1.0,3.0]
;;   tabinv,tau,valtau,tau_eff
;;   ytau=linear(exctemp,tau_eff)
;;   xtau=linear(heightkm,tau_eff)
;;   ydash=(temprange[1]-temprange[0])/20.
;;   for itau=0,2 do begin
;;     xtick=[xtau[itau],xtau[itau]]
;;     ytick=[ytau[itau]-0.10,ytau[itau]+0.10]
;;     ytick=[ytau[itau]-ydash,ytau[itau]+ydash]
;;     oplot,xtick,ytick
;;   endfor

; end big loop over wavs for this line
endfor

; add curve labels (improve?)
xyouts,heightkm[ih],radtemp[ih]+200,textoidl("S, J  Ly \alpha"),charsize=0.9


; ##################
; REPEAT for Lybeta
; ##################

linename='Lybeta'

; Lybeta  ? PRD?
if (linename eq 'Lybeta') then begin
  filelinename='Lybeta'  & pslinelabel='Ly '+greek("beta")
  element='H' & linewav=102.6
  addneckel=0  
  wavrange=170 & betarange=betarange & temprange=temprange 
endif 

; #### = cut-and-paste from findline.pro bottom part
; get RH line stuff 
nrtrans=0
text=' - elem,itrans,i,j,wavnr,wavair,wavvac ='
thisatom=readatom('atom.'+element+'.out')
ntr=thisatom.nline+thisatom.ncont
for itr=0,ntr-1 do $
  if (abs(thisatom.transition[itr].lambda0-linewav) lt transinterval) $
  then begin
    wavlc=thisatom.transition[itr].lambda0
    tabinv,spectrum.lambda,wavlc,iwavlc
    itrans=itr
    nrtrans=nrtrans+1
    iwavlc=long(iwavlc+0.1)
    ilow=thisatom.transition[itr].i
    jupp=thisatom.transition[itr].j
    if (thisatom.transition[itrans].shape eq 2) then PRD=1 else PRD=0
    if (PRD) then begin
      wavpeak=wavlc+delwavpeak
      iwavpeak=where(abs(spectrum.lambda-wavpeak) eq $
        min(abs(spectrum.lambda-wavpeak)))
      wavdip=wavlc+delwavdip
      iwavdip=where(abs(spectrum.lambda-wavdip) eq $
        min(abs(spectrum.lambda-wavdip)))
      wavwing=wavlc+delwavwing
      iwavwing=where(abs(spectrum.lambda-wavwing) eq $
        min(abs(spectrum.lambda-wavwing)))
    endif
    if (transprint) then print,text,element,itr,$
      ilow,jupp,iwavlc,wavlc,airtovacuum(wavlc),$
      format='(A43, A3, I5, I3, I3, I7, F9.3, F9.3)'
  endif
if (nrtrans eq 0) then print,' ### FINDLINE.PRO: no line found'
if (nrtrans gt 1 and transprint eq 0) then $
    print,' ### FINDLINE.PRO: multiple lines found'
; end cut-and-paste from findline.pro

readopacity,iwavlc

; if PRD then large loop over 3 sample wavs, otherwise line center only
if (PRD) then iwavarr=[iwavlc,iwavpeak,iwavdip] else iwavarr=[iwavlc]
sizeiwavarr=size(iwavarr)
for iw=0,sizeiwavarr[1]-1 do begin
  iwavplot=iwavarr[iw]
  wavplot=spectrum.lambda[iwavplot] 

; compute J_bar = R_lu/B_lu (holds also for PRD)
  @constants_si.idl
  Rlu=*thisatom.transition[itrans].Rij_ptr
  gl=thisatom.g[ilow]
  gu=thisatom.g[jupp]
  Aul=thisatom.transition[itrans].strength
  Blu=(gu/gl)*Aul*(wavlc*nm_to_m)^3/(2.*hplanck*clight)
  Jbar=Rlu/Blu

; compute various source functions
  readj,iwavplot
  readopacity,iwavplot
  Sline=eta_as/chi_as    
  Stotal=(eta_as + eta_c + J*scatt) / (chi_c + chi_as)
  if (PRD) then Jplot=J else Jplot=Jbar ; monochromatic or freq average

; convert into formal temperature
  exctemp=brighttemp(wavlc,Sline,/Hz)
  tottemp=brighttemp(wavlc,Stotal,/Hz)
  radtemp=brighttemp(wavlc,Jplot,/Hz)
  if (PRD) then bartemp=brighttemp(wavlc,Jbar,/Hz)

; overplot these
oplot,heightkm,exctemp,linestyle=1   ; dotted, S^l
oplot,heightkm,radtemp,linestyle=2   ; dashed, J_bar or J

;RR too confusing from PRD - ticks too deep
;; ; add tau ticks
;;   tau=fltarr(nh)
;;   tau=gettau(height,chi_as+chi_c)   ; getTau in readopacity.pro
;;   valtau=[0.3,1.0,3.0]
;;   tabinv,tau,valtau,tau_eff
;;   ytau=linear(exctemp,tau_eff)
;;   xtau=linear(heightkm,tau_eff)
;;   ydash=(temprange[1]-temprange[0])/20.
;;   for itau=0,2 do begin
;;     xtick=[xtau[itau],xtau[itau]]
;;     ytick=[ytau[itau]-0.10,ytau[itau]+0.10]
;;     ytick=[ytau[itau]-ydash,ytau[itau]+ydash]
;;     oplot,xtick,ytick
;;   endfor

; end big loop over wavs for this line
endfor

; add curve label (improve?)
xyouts,heightkm[ih],exctemp[ih]+200,textoidl("S, J  Ly \beta"),charsize=0.9


; ####################
; ADD Balmer continuum
; ####################

linename='Ba-cont'
element='H'

; edge selection (from makefigSBJtempedges.pro)
aaedge=3646.   ; Balmer edge wavelength in AA
aaextent=100.  ; summation extent below threshold in AA

; find start-stop wavelength indices 
wav2=aaedge/10.
iwav=where(abs(spectrum.lambda-wav2) eq min(abs(spectrum.lambda-wav2)))
iwav2=iwav[0]   ; bloody IDL
wav1=wav2-aaextent/10.
iwav=where(abs(spectrum.lambda-wav1) eq min(abs(spectrum.lambda-wav1)))
iwav1=iwav[0]

; compute, sum, average S and J  ;## Nov 10 2016 should have averaged B too?
  nh=n_elements(heightkm)
  Smean=dblarr(nh)
  Jmean=dblarr(nh)
  for iwav=iwav1,iwav2 do begin
    readj,iwav
    readopacity,iwav
    Smean=Smean+(eta_c+J*scatt)/chi_c
    Jmean=Jmean+J
  endfor
  Smean=Smean/(iwav2-iwav1)
  Jmean=Jmean/(iwav2-iwav1)

; convert into formal temperature
  meanwav=(wav1+wav2)/2.
  exctemp=brighttemp(meanwav,Smean,/Hz)
  radtemp=brighttemp(meanwav,Jmean,/Hz)

; overplot these
  oplot,heightkm,exctemp,linestyle=1   ; dotted S
  oplot,heightkm,radtemp,linestyle=2   ; dashed J

; ====== end of Balmer continuum

; add curve label (improve?)
xyouts,heightkm[ih],radtemp[ih]+100,textoidl("S, J  Ba edge"),charsize=0.9


; close plot
closepsplot,psfilename,opengv=opengv

end
